/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.15")
@CheckID(value="SVTB.14.10.18")
@CheckName(value="SVTB.14.10.18")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.LOOP})
@CheckTitle(value="Assertions in loops must use loop index")
@CheckDescription(value="Assertions in loops must use loop index.\n\nExamples\nfor (int j=0; j<10; j++) begin\n\tassert1: assert property ( a |-> b |=> c ); // not allowed\n\tassert2: assert property ( (j%2) |-> b |=> c );  // allowed\nend\n")
public class Check_SVTB_14_10_18
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();
    public static final Set<HidFlatteningOption> ONLY_HIDS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS));

    public Check_SVTB_14_10_18(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String pFailureMessageFormatValue = "";
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(Arrays.asList("(_ANY_)")), pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    protected boolean checkAssertExpression(IHidObject pattern, IHidObject expression, StringBuilder matchedExpressionString, final RfNamedElement assertion) {
        final RfAbstractBlock loopActionBlock = this.isInsideLoop(assertion.getEnclosingScope());
        if (loopActionBlock == null) {
            return false;
        }
        if (expression instanceof RfHidOperator var6_7 && propertySpec.isPropertySpec()) {
            IHidObject iHidObject = expression = propertySpec.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR ? propertySpec.getLHValue() : propertySpec.getFirstRHValue();
        }
        if ((assertExpressionHids = HidUtils.flattenToHids((IHidObject)expression, ONLY_HIDS)) == null || assertExpressionHids.isEmpty()) {
            return false;
        }
        if (assertion instanceof RfAssertExpect && (disabledIffExpresionHids = HidUtils.flattenToHids((IHidObject)this.getDisableIffExpressionTree((RfAssertExpect)assertion), ONLY_HIDS)) != null && !disabledIffExpresionHids.isEmpty()) {
            assertExpressionHids.addAll(disabledIffExpresionHids);
        }
        IHidVisitor<RfHidOperator> visitor = new IHidVisitor<RfHidOperator>(){
            private IRfNamedElement scope;

            public boolean visit(RfHidOperator hidObject) {
                if (!loopActionBlock.equals(this.scope)) {
                    return true;
                }
                if (hidObject.isForStep()) {
                    this.checkLoopIndexes(assertExpressionHids, hidObject.getLHValue(), assertion);
                    return true;
                }
                if (hidObject.hasOccurrence(HidQualifierCache.IS_LOOP_EXPRESSION_QUALIFIER)) {
                    if (hidObject.isForCondition()) {
                        return true;
                    }
                    IHidObject conditionalExpression = hidObject.getLHValue();
                    if (conditionalExpression == null) {
                        return true;
                    }
                    if (conditionalExpression instanceof RfHidAccess) {
                        List selects = ((RfHidAccess)conditionalExpression).getSelects();
                        for (IHidObject select : selects) {
                            this.checkLoopIndexes(assertExpressionHids, select, assertion);
                        }
                    } else {
                        this.checkLoopIndexes(assertExpressionHids, conditionalExpression, assertion);
                    }
                }
                return true;
            }

            private void checkLoopIndexes(Set<IHid> assertionHids, IHidObject loopExpression, RfNamedElement assertion2) {
                if (loopExpression == null) {
                    return;
                }
                Set loopExpressionHids = HidUtils.flattenToHids((IHidObject)loopExpression, ONLY_HIDS);
                for (IHid expressionHid : loopExpressionHids) {
                    if (assertionHids.contains(expressionHid)) continue;
                    Check_SVTB_14_10_18.this.addHit(assertion2, "Assertion '" + LintUtils.getNamedElementFullName(assertion2) + "' does not use loop index '" + expressionHid.getName() + "'!");
                }
            }

            public void setHolder(IHidHolder holder) {
                this.scope = ((RfHidHolder)holder).getScope();
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        };
        loopActionBlock.visitHidObject(null, visitor);
        return false;
    }

    private RfAbstractBlock isInsideLoop(RfNamedElement rfNamedElement) {
        RfAbstractBlock actionBlock;
        long blockQualifiers;
        if (rfNamedElement == null) {
            return null;
        }
        if (rfNamedElement instanceof RfAbstractBlock && ((blockQualifiers = (actionBlock = (RfAbstractBlock)rfNamedElement).getBlockQualifiers()) & IRfActionBlockElement.BlockQualifier.FOR.value() + IRfActionBlockElement.BlockQualifier.FOREACH.value()) != 0L) {
            return actionBlock;
        }
        return this.isInsideLoop(rfNamedElement.getEnclosingScope());
    }
}

