/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.16")
@CheckID(value="SVTB.14.10.19")
@CheckName(value="SVTB.14.10.19")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use unbounded repetition windows at the start or end of the antecedent of an implication")
@CheckDescription(value="Do not use unbounded repetition windows at the start or end of the antecedent of an implication.\n\nExamples\nassert_1: assert property(@(posedge clk) (a[*] #-#  b |-> c)); // not allowed\nassert_2: assert property(@(posedge clk) (a |=> (a or b)));  // allowed\n")
public class Check_SVTB_14_10_19
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();
    private static final List<String> UNBOUNDED_REPETITION_PATTERNS = Arrays.asList("(_A_[* _B_ : $])", "(_A_[*])", "(_A_[+])", "(_A_[-> _B_ : $])", "(_A_[= _B_ : $])");

    public Check_SVTB_14_10_19(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(UNBOUNDED_REPETITION_PATTERNS), "", numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    protected boolean checkAssertExpression(IHidObject pattern, IHidObject expression, StringBuilder matchedExpressionString, RfNamedElement assertion) {
        final ArrayList implications = new ArrayList();
        Predicate<IHidObject> cons = new Predicate<IHidObject>(){

            @Override
            public boolean test(IHidObject element) {
                if (element instanceof RfHidOperator && (((RfHidOperator)element).isDashImplication() || ((RfHidOperator)element).isEqualImplication())) {
                    implications.add((RfHidOperator)element);
                }
                return true;
            }
        };
        HidUtils.flattenToObjects((Predicate)cons, (IHidObject)expression, (Set)HidFlatteningOption.NONE_EXCLUDED);
        for (RfHidOperator implicationOperator : implications) {
            IHidObject antecedent = implicationOperator.getLHValue();
            IHidObject matchedExpression = this.checkLeftMostOperator(pattern, antecedent);
            if (matchedExpression != null) {
                this.addHit(assertion, "Unbounded repetition '" + HidUtils.toNiceString((IHidObject)matchedExpression) + "' found at the beginning of antecedent ' " + HidUtils.toNiceString((IHidObject)antecedent) + "'.");
            }
            if ((matchedExpression = this.checkRightMostOperator(pattern, antecedent)) == null) continue;
            this.addHit(assertion, "Unbounded repetition '" + HidUtils.toNiceString((IHidObject)matchedExpression) + "' found at the end of antecedent ' " + HidUtils.toNiceString((IHidObject)antecedent) + "'.");
        }
        return false;
    }

    private IHidObject checkLeftMostOperator(IHidObject pattern, IHidObject antecedent) {
        if (antecedent == null) {
            return null;
        }
        if (Check_SVTB_14_10_19.checkPattern(pattern, antecedent, new HashMap<String, String>(), new HashMap<String, String>())) {
            return antecedent;
        }
        if (antecedent instanceof RfHidOperator) {
            return this.checkLeftMostOperator(pattern, ((RfHidOperator)antecedent).getLHValue());
        }
        return null;
    }

    private IHidObject checkRightMostOperator(IHidObject pattern, IHidObject antecedent) {
        if (antecedent == null) {
            return null;
        }
        if (Check_SVTB_14_10_19.checkPattern(pattern, antecedent, new HashMap<String, String>(), new HashMap<String, String>())) {
            return antecedent;
        }
        if (antecedent instanceof RfHidOperator) {
            ListContainer rhValues = ((RfHidOperator)antecedent).getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return null;
            }
            return this.checkRightMostOperator(pattern, (IHidObject)rhValues.get(0));
        }
        return null;
    }
}

