/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.16")
@CheckID(value="SVTB.14.10.20")
@CheckName(value="SVTB.14.10.20")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use unbounded time windows in the antecedent of an implication")
@CheckDescription(value="Do not use unbounded time windows in the antecedent of an implication.\n\nExamples\nassert_1: assert property ((B ##[*] A) |=> C |=> D); // not allowed\nassert10:assert property (A |=> (B [-> 1 : $] or E) |-> D);  // allowed\n")
public class Check_SVTB_14_10_20
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();

    public Check_SVTB_14_10_20(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(Arrays.asList("(_ANY_)")), "", numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    protected boolean checkAssertExpression(IHidObject pattern, IHidObject expression, StringBuilder matchedExpressionString, RfNamedElement assertion) {
        ArrayList implications = new ArrayList();
        Predicate<IHidObject> cons = element -> {
            if (element instanceof RfHidOperator && (((RfHidOperator)element).isDashImplication() || ((RfHidOperator)element).isEqualImplication())) {
                implications.add((RfHidOperator)element);
            }
            return true;
        };
        HidUtils.flattenToObjects(cons, (IHidObject)expression, (Set)HidFlatteningOption.NONE_EXCLUDED);
        implications.stream().forEach(implicationOperator -> this.checkForUnboundedTimeWindows(implicationOperator.getLHValue(), assertion));
        return false;
    }

    private void checkForUnboundedTimeWindows(IHidObject antecedent, RfNamedElement assertion) {
        if (antecedent == null) {
            return;
        }
        Predicate<IHidObject> cons = element -> {
            if (element instanceof RfHidOperator && ((RfHidOperator)element).isSequenceCycleDelayRange()) {
                IHidObject candidate = null;
                RfHidOperator cycleDelayRangeOperator = (RfHidOperator)element;
                if (cycleDelayRangeOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                    candidate = cycleDelayRangeOperator.getLHValue();
                } else if (cycleDelayRangeOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR) {
                    IHidObject iHidObject2 = candidate = cycleDelayRangeOperator.getRHValues() != null ? (IHidObject)cycleDelayRangeOperator.getRHValues().get(1) : null;
                }
                if (!(candidate instanceof RfHidOperator)) {
                    return true;
                }
                if (!((RfHidOperator)candidate).isPoundPound()) {
                    return true;
                }
                IHidObject cycleDelayRange = ((RfHidOperator)candidate).getLHValue();
                if (cycleDelayRange instanceof RfHidImplicit && (((RfHidImplicit)cycleDelayRange).isStar() || ((RfHidImplicit)cycleDelayRange).isPlus())) {
                    this.addHit(assertion, "Unbounded time window '" + HidUtils.toNiceString((IHidObject)candidate) + "' found in the antecedent ' " + HidUtils.toNiceString((IHidObject)antecedent) + "'.");
                }
                if (cycleDelayRange instanceof RfHidOperator && ((RfHidOperator)cycleDelayRange).isColon()) {
                    ListContainer endIntervalRangeValues = ((RfHidOperator)cycleDelayRange).getRHValues();
                    if (endIntervalRangeValues == null || endIntervalRangeValues.size() != 1) {
                        return true;
                    }
                    IHidObject endIntervalRange = (IHidObject)endIntervalRangeValues.get(0);
                    if (endIntervalRange instanceof RfHidImplicit && ((RfHidImplicit)endIntervalRange).isDollar()) {
                        this.addHit(assertion, "Unbounded time window '" + HidUtils.toNiceString((IHidObject)candidate) + "' found in the antecedent ' " + HidUtils.toNiceString((IHidObject)antecedent) + "'.");
                    }
                }
            }
            return true;
        };
        HidUtils.flattenToObjects(cons, (IHidObject)antecedent, (Set)HidFlatteningOption.NONE_EXCLUDED);
    }
}

