/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.16")
@CheckID(value="SVTB.14.10.21")
@CheckName(value="SVTB.14.10.21")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use implications with antecedents that allow an empty match")
@CheckDescription(value="Do not use implications with antecedents that allow an empty match.\nExample: s[*] |=> p is equivalent to p")
public class Check_SVTB_14_10_21
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();

    public Check_SVTB_14_10_21(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(Arrays.asList("(_ANY_)")), "", numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    protected boolean checkAssertExpression(IHidObject pattern, IHidObject expression, StringBuilder matchedExpressionString, RfNamedElement assertion) {
        final ArrayList implications = new ArrayList();
        Predicate<IHidObject> cons = new Predicate<IHidObject>(){

            @Override
            public boolean test(IHidObject element) {
                if (element instanceof RfHidOperator && (((RfHidOperator)element).isDashImplication() || ((RfHidOperator)element).isEqualImplication())) {
                    implications.add((RfHidOperator)element);
                }
                return true;
            }
        };
        HidUtils.flattenToObjects((Predicate)cons, (IHidObject)expression, (Set)HidFlatteningOption.NONE_EXCLUDED);
        implications.stream().forEach(implicationOperator -> this.checkForEmptyMatches(implicationOperator.getLHValue(), assertion));
        return false;
    }

    private void checkForEmptyMatches(final IHidObject antecedent, final RfNamedElement assertion) {
        if (antecedent == null) {
            return;
        }
        Predicate<IHidObject> cons = new Predicate<IHidObject>(){

            @Override
            public boolean test(IHidObject element) {
                if (element instanceof RfHidOperator && ((RfHidOperator)element).isSequenceAbbrev()) {
                    ListContainer rhValues = ((RfHidOperator)element).getRHValues();
                    if (rhValues == null || rhValues.size() != 1) {
                        return true;
                    }
                    IHidObject sequenceRepetition = (IHidObject)rhValues.get(0);
                    if (sequenceRepetition instanceof RfHidOperator && ((RfHidOperator)sequenceRepetition).isSequenceRepetition()) {
                        IHidObject sequenceRepetitionRange = ((RfHidOperator)sequenceRepetition).getLHValue();
                        if (!(sequenceRepetitionRange instanceof RfHidOperator)) {
                            Check_SVTB_14_10_21.this.addHit(assertion, "Empty match expression '" + HidUtils.toNiceString((IHidObject)element) + "' found in the antecedent ' " + HidUtils.toNiceString((IHidObject)antecedent) + "'.");
                            return true;
                        }
                        IHidObject startOfRange = ((RfHidOperator)sequenceRepetitionRange).getLHValue();
                        if (!(startOfRange instanceof RfHidImplicit)) {
                            return true;
                        }
                        if (((RfHidImplicit)startOfRange).isNumber() && "0".equals(((RfHidImplicit)startOfRange).getName())) {
                            Check_SVTB_14_10_21.this.addHit(assertion, "Empty match expression '" + HidUtils.toNiceString((IHidObject)element) + "' found in the antecedent ' " + HidUtils.toNiceString((IHidObject)antecedent) + "'.");
                        }
                    }
                }
                return true;
            }
        };
        HidUtils.flattenToObjects((Predicate)cons, (IHidObject)antecedent, (Set)HidFlatteningOption.NONE_EXCLUDED);
    }
}

