/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.17")
@CheckID(value="SVTB.14.10.22")
@CheckName(value="SVTB.14.10.22")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use large time or repetition windows")
@CheckDescription(value="Use unbounded time or repetition windows instead of large time or repetition windows.\n\nExamples\nassert_1: assert property(@(posedge clk) (A[* 0 : 1111] |-> B)); // not allowed\nassert_2: assert property(@(posedge clk) (A[* 0 : 11] |-> B));  // allowed\n")
public class Check_SVTB_14_10_22
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();
    @CheckParameter(defaultValue="1000", description="Maximum value allowed for time or repetition window.", name="allowedWindowSize", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pAllowedWindowSizeValue;

    public Check_SVTB_14_10_22(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(Arrays.asList("(_ANY_)")), "", numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    protected boolean checkAssertExpression(IHidObject pattern, IHidObject expression, StringBuilder matchedExpressionString, RfNamedElement assertion) {
        Predicate<IHidObject> cons = element -> {
            this.checkTimeWindows((IHidObject)element, assertion, expression);
            this.checkRepetitionWindows((IHidObject)element, assertion, expression);
            return true;
        };
        HidUtils.flattenToObjects(cons, (IHidObject)expression, (Set)HidFlatteningOption.NONE_EXCLUDED);
        return false;
    }

    private void checkRepetitionWindows(IHidObject element, RfNamedElement assertion, IHidObject assertExpression) {
        if (!(element instanceof RfHidOperator) || !((RfHidOperator)element).isSequenceAbbrev()) {
            return;
        }
        ListContainer rhValues = ((RfHidOperator)element).getRHValues();
        if (rhValues == null || rhValues.size() != 1) {
            return;
        }
        IHidObject sequenceRepetition = (IHidObject)rhValues.get(0);
        if (!(sequenceRepetition instanceof RfHidOperator) || !((RfHidOperator)sequenceRepetition).isSequenceRepetition()) {
            return;
        }
        IHidObject sequenceRepetitionRange = ((RfHidOperator)sequenceRepetition).getLHValue();
        if (!(sequenceRepetitionRange instanceof RfHidOperator) || !((RfHidOperator)sequenceRepetitionRange).isColon()) {
            return;
        }
        if (this.getEndRangeValue((RfHidOperator)sequenceRepetitionRange) >= this.pAllowedWindowSizeValue) {
            this.addHit(assertion, "Large repetition window '" + HidUtils.toNiceString((IHidObject)sequenceRepetition) + "' found in expression ' " + HidUtils.toNiceString((IHidObject)assertExpression) + "'!");
        }
    }

    private void checkTimeWindows(IHidObject element, RfNamedElement assertion, IHidObject assertExpression) {
        if (!(element instanceof RfHidOperator) || !((RfHidOperator)element).isSequenceCycleDelayRange()) {
            return;
        }
        IHidObject candidate = null;
        RfHidOperator cycleDelayRangeOperator = (RfHidOperator)element;
        if (cycleDelayRangeOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
            candidate = cycleDelayRangeOperator.getLHValue();
        } else if (cycleDelayRangeOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR) {
            IHidObject iHidObject = candidate = cycleDelayRangeOperator.getRHValues() != null ? (IHidObject)cycleDelayRangeOperator.getRHValues().get(1) : null;
        }
        if (!(candidate instanceof RfHidOperator)) {
            return;
        }
        if (!((RfHidOperator)candidate).isPoundPound()) {
            return;
        }
        IHidObject cycleDelayRange = ((RfHidOperator)candidate).getLHValue();
        if (!(cycleDelayRange instanceof RfHidOperator) || !((RfHidOperator)cycleDelayRange).isColon()) {
            return;
        }
        if (this.getEndRangeValue((RfHidOperator)cycleDelayRange) >= this.pAllowedWindowSizeValue) {
            this.addHit(assertion, "Large time window '" + HidUtils.toNiceString((IHidObject)cycleDelayRangeOperator) + "' found in expression ' " + HidUtils.toNiceString((IHidObject)assertExpression) + "'!");
        }
    }

    private int getEndRangeValue(RfHidOperator cycleDelayConstRangeExpression) {
        int endIntervalIntValue = -1;
        if (cycleDelayConstRangeExpression == null) {
            return -1;
        }
        ListContainer endIntervalRangeValues = cycleDelayConstRangeExpression.getRHValues();
        if (endIntervalRangeValues == null || endIntervalRangeValues.size() != 1) {
            return -1;
        }
        String endIntervalStringValue = "";
        IHidObject endIntervalRange = (IHidObject)endIntervalRangeValues.get(0);
        if (endIntervalRange instanceof RfHidImplicit) {
            endIntervalStringValue = ((RfHidImplicit)endIntervalRange).getName();
        } else if (endIntervalRange instanceof RfHid) {
            IRfNamedElement element = ((RfHid)endIntervalRange).getElement();
            if (!(element instanceof RfField)) {
                return -1;
            }
            if (!((RfField)element).isParameter() && !((RfElement)element).isConst()) {
                return -1;
            }
            endIntervalStringValue = ((RfField)element).getInitialValue(false);
        }
        if (endIntervalStringValue == null || !LintUtils.isIntegralNumber(endIntervalStringValue)) {
            return -1;
        }
        try {
            endIntervalIntValue = Integer.parseInt(endIntervalStringValue);
        }
        catch (NumberFormatException numberFormatException) {
            endIntervalIntValue = -1;
        }
        return endIntervalIntValue;
    }
}

