/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAssertsVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.25")
@CheckID(value="SVTB.14.10.23")
@CheckName(value="SVTB.14.10.23")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.CONDITIONAL})
@CheckTitle(value="Use sampled value function on variables used in disable conditions of properties")
@CheckDescription(value="A property that has a disable condition must use a sampled value function to sample all variables used in the disable condition.\nConcurrent assertions and several other constructs have special rules for sampling values of their expressions.\nFor a property the values of variables used in the disable condition(disable iff) are those in the current simulation cycle, i.e., not sampled.\n\nExamples\nassert_1: assert property (@(posedge clk) disable iff (enable[1]) a |-> b); // not allowed\nassert_2: assert property (@(posedge clk) disable iff ($sampled(~enable[1] | reset )) a |-> b); // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_14_10_23
extends AbstractSVAssertsVisitor {
    @CheckParameter(defaultValue="$sampled, $rose, $fell, $stable, $changed, $past", description="Comma separated list of allowed sample value functions.", name="allowedSampleValueFunctions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedSampleValueFunctions = new HashSet();

    public Check_SVTB_14_10_23(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> pAssertionKindValue = new HashSet<String>(Arrays.asList("concurrent_assert", "concurrent_assume", "concurrent_cover_property", "expect", "restrict", "property"));
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(pAssertionKindValue);
        this.performCheckOnAssertions(this.fOVMProject, numericalAssertKind, numericalPropertySequenceKind, this.pAllowedSampleValueFunctions);
    }

    @Override
    public void visitAssertionSignalsOrDisableCondition(RfNamedElement assertExpect, ParserPath parserPath, final HashSet<String> allowedSampleValueFunctions) {
        if (assertExpect instanceof RfAssertExpect && !((RfAssertExpect)assertExpect).hasDisabledIff()) {
            return;
        }
        assertExpect.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new HidOperatorVisitor(new HidOperatorQualifier[0]){

            public boolean visit(HidOperator operator) {
                if (!(operator instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator hidOperator = (RfHidOperator)operator;
                Check_SVTB_14_10_23.this.notifyCheckAlive();
                if (!hidOperator.isDisableIffExpr()) {
                    return true;
                }
                IHidObject iffHid = hidOperator.getLHValue();
                if (!(iffHid instanceof RfHidOperator)) {
                    return true;
                }
                if (!((RfHidOperator)iffHid).isIffExpression()) {
                    return true;
                }
                IHidObject disableConditionHids = ((RfHidOperator)iffHid).getLHValue();
                if (disableConditionHids == null) {
                    return true;
                }
                Check_SVTB_14_10_23.this.visitExpressionsTree(disableConditionHids, this.parserPath, allowedSampleValueFunctions);
                return true;
            }
        });
    }

    @Override
    public String computeErrorMessage(RfNamedElement resolvedElement) {
        return "Variable " + resolvedElement.getFullName() + "  is not sampled using an allowed sample value function!";
    }
}

