/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAssertsVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.25")
@CheckID(value="SVTB.14.10.24")
@CheckName(value="SVTB.14.10.24")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Do not use signals referenced in an assertion action block without $sampled")
@CheckDescription(value="Do not use signals referenced in an assertion action block without $sampled\nAcording to the LRM standard, the function $sampled is useful to access the value of expressions used in concurrent assertions in their action blocks because such action blocks are evaluated in the Reactive region.\n\nExamples\nassert property (@(posedge clk)  a == b)\n\t$display(\"PASS: a = %d, b = %d, c = %d\", a, $sampled(b), $sampled(c)); // not allowed\nelse\n\t$display(\"FAIL: a = %d, b = %d, c = %d\", $sampled(a), $sampled(b), $sampled(c)); // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_14_10_24
extends AbstractSVAssertsVisitor {
    private final String SAMPLE_FUNCTION = "$sampled";
    private final HashSet<String> pAllowedSampleValueFunctions = new HashSet<String>(Arrays.asList("$sampled"));
    public LinkedHashMap<ParserPath, LinkedHashMap<HidOccurrence, RfHid>> actionBlockSignals = new LinkedHashMap();

    public Check_SVTB_14_10_24(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> pAssertionKindValue = new HashSet<String>(Arrays.asList("concurrent_assert", "concurrent_assume", "concurrent_cover_property", "expect"));
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(new HashSet<String>());
        this.performCheckOnAssertions(this.fOVMProject, numericalAssertKind, numericalPropertySequenceKind, this.pAllowedSampleValueFunctions);
    }

    @Override
    public void visitAssertionSignalsOrDisableCondition(final RfNamedElement assertExpect, final ParserPath parserPath, final HashSet<String> allowedSampleValueFunctions) {
        final List<RfActionBlock> actionBlocks = ((RfAssertExpect)assertExpect).getLocalMembers(RfActionBlock.class);
        assertExpect.visitHidObject(this.fOVMProject.getRfProject(), new IHidVisitor<RfHid>(){
            ParserPath elemParserPath;

            public boolean visit(RfHid rfHid) {
                if (!this.elemParserPath.equals((Object)parserPath)) {
                    return true;
                }
                if (rfHid.getOccurrence().getOffset() < Check_SVTB_14_10_24.this.getCloseBound(assertExpect)) {
                    return true;
                }
                HidAccess acc = rfHid.getFirstAccess();
                if (acc != null && !(acc instanceof RfHidAccessArgs)) {
                    return true;
                }
                if (actionBlocks != null) {
                    for (RfActionBlock actionBlock : actionBlocks) {
                        boolean isHisInsideActionBlock;
                        boolean bl = isHisInsideActionBlock = rfHid.getOccurrence().getOffset() > actionBlock.getStartOffset() && rfHid.getOccurrence().getOffset() < actionBlock.getEndOffset();
                        if (!isHisInsideActionBlock) continue;
                        return true;
                    }
                }
                Check_SVTB_14_10_24.this.updateSignalsMapForHid(rfHid, null, allowedSampleValueFunctions, parserPath);
                return true;
            }

            public Class<RfHid> getType() {
                return RfHid.class;
            }

            public void setParserPath(ParserPath parserPath2) {
                this.elemParserPath = parserPath2;
            }
        });
        if (actionBlocks == null) {
            return;
        }
        for (RfActionBlock rfActionBlock : actionBlocks) {
            final List<RfField> localFields = rfActionBlock.getLocalMembers(RfField.class);
            rfActionBlock.visitHidObject(this.fOVMProject.getRfProject(), new IHidVisitor<RfHid>(){
                ParserPath elemParserPath;

                public boolean visit(RfHid rfHid) {
                    if (!this.elemParserPath.equals((Object)parserPath)) {
                        return true;
                    }
                    HidAccess acc = rfHid.getFirstAccess();
                    if (acc != null && !(acc instanceof RfHidAccessArgs)) {
                        return true;
                    }
                    Check_SVTB_14_10_24.this.updateSignalsMapForHid(rfHid, localFields, allowedSampleValueFunctions, parserPath);
                    return true;
                }

                public Class<RfHid> getType() {
                    return RfHid.class;
                }

                public void setParserPath(ParserPath parserPath2) {
                    this.elemParserPath = parserPath2;
                }
            });
        }
        for (LinkedHashMap linkedHashMap : this.actionBlockSignals.values()) {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                HidOccurrence unsampledSignal = (HidOccurrence)entry.getKey();
                RfHid notSampletVariable = (RfHid)((Object)entry.getValue());
                this.addErrorMessage((IHidObject)notSampletVariable, parserPath, unsampledSignal);
            }
            linkedHashMap.clear();
        }
        actionBlocks.clear();
    }

    public void updateSignalsMapForHid(RfHid rfHid, List<RfField> localFields, HashSet<String> allowedSampleValueFunctions, ParserPath parserPath) {
        IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)rfHid);
        if (resolvedElement instanceof RfField) {
            if (localFields != null && localFields.contains(resolvedElement)) {
                return;
            }
            if (!((RfField)resolvedElement).isField()) {
                return;
            }
            HidOccurrence occurence = rfHid.getOccurrence(rfHid.getQualifiers());
            LinkedHashMap<Object, RfHid> signalOccurences = this.actionBlockSignals.get(parserPath);
            if (signalOccurences == null) {
                signalOccurences = new LinkedHashMap();
            }
            signalOccurences.put(occurence, rfHid);
            this.actionBlockSignals.put(parserPath, signalOccurences);
            return;
        }
        if (!(resolvedElement instanceof RfPredefinedFunction)) {
            return;
        }
        if (!allowedSampleValueFunctions.contains(resolvedElement.getName())) {
            return;
        }
        List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
        for (MethodCall methodCall : methodCalls) {
            Map argVals = methodCall.argumentValuesMapRaw;
            for (IHidObject argument : argVals.values()) {
                if (!(argument instanceof RfHid)) continue;
                HidOccurrence occurence = ((RfHid)argument).getOccurrence(rfHid.getQualifiers());
                LinkedHashMap<HidOccurrence, RfHid> hidOccurenceMap = this.actionBlockSignals.get(parserPath);
                if (hidOccurenceMap == null || hidOccurenceMap.isEmpty()) continue;
                hidOccurenceMap.remove(occurence);
                this.actionBlockSignals.put(parserPath, hidOccurenceMap);
            }
        }
    }

    public int getCloseBound(RfNamedElement assertExpect) {
        if (!(assertExpect instanceof RfAssertExpect)) {
            return Integer.MAX_VALUE;
        }
        IHidObject ex = ((RfAssertExpect)assertExpect).getExpression();
        if (ex instanceof RfHidAccessArgs) {
            List<? extends IHidObject> arguments = ((RfHidAccessArgs)ex).getArgumentValues();
            if (arguments == null || arguments.isEmpty()) {
                return ((RfHidAccessArgs)ex).getOccurrence().getOffset() + 1;
            }
            int maxOffset = -1;
            for (IHidObject iHidObject : arguments) {
                int closeBoundary;
                if (!(iHidObject instanceof RfHidOperator) || (closeBoundary = ((RfHidOperator)iHidObject).getCloseBoundary()) <= maxOffset) continue;
                maxOffset = closeBoundary;
            }
            return maxOffset == -1 ? Integer.MAX_VALUE : maxOffset;
        }
        if (ex instanceof RfHidAccess) {
            ex = ((RfHidAccess)ex).getParentHid();
        }
        if (ex instanceof RfHidOperator) {
            return ((RfHidOperator)ex).getCloseBoundary();
        }
        if (ex instanceof RfHid) {
            return ((RfHid)ex).getOccurrence().getOffset() + 1;
        }
        if (ex instanceof RfHidImplicit) {
            List<IHidOperator> clockingEvents = ((RfAssertExpect)assertExpect).getClockingEvents();
            int maxOffset = -1;
            for (IHidOperator iHidOperator : clockingEvents) {
                int closeBoundary;
                if (!(iHidOperator instanceof RfHidOperator) || (closeBoundary = ((RfHidOperator)iHidOperator).getCloseBoundary()) <= maxOffset) continue;
                maxOffset = closeBoundary;
            }
            return maxOffset == -1 ? Integer.MAX_VALUE : maxOffset;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public String computeErrorMessage(RfNamedElement resolvedElement) {
        return "Signal '" + resolvedElement.getFullName() + "'  used without sample value function '$sampled'!";
    }
}

