/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.10.5")
@CheckName(value="SVTB.14.10.5")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.OPERATOR, RuleLabel.PERFORMANCE})
@CheckTitle(value="Do not use trivially true expressions (A == A) in assertions")
@CheckDescription(value="Do not use trivially true expressions (A == A) in assertions. Macros might expand to these expressions and can cause severe simulation performance problems.\n\nExamples\nassert1:assert property (A == A); // not allowed\nassert2:assert property (A == B);  // allowed\n")
public class Check_SVTB_14_10_5
extends AbstractSVAPatternDetector {
    String pFailureMessageFormatValue = "Trivially true expression ''{0}'' found on ''{1}''!";
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();

    public Check_SVTB_14_10_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(Arrays.asList("(_A_ == _A_)")), this.pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
    }

    @Override
    protected boolean checkAssertExpression(IHidObject pattern, IHidObject expression, StringBuilder matchedExpressionString, RfNamedElement assertion) {
        if (assertion instanceof RfAssertExpect && super.checkAssertExpression(pattern, this.getDisableIffExpressionTree((RfAssertExpect)assertion), matchedExpressionString, assertion)) {
            this.addLocalHit(assertion, MessageFormat.format(this.pFailureMessageFormatValue, "(_A_ == _A_)", matchedExpressionString), false);
        }
        return super.checkAssertExpression(pattern, expression, matchedExpressionString, assertion);
    }
}

