/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.10.9")
@CheckName(value="SVTB.14.10.9")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Ensure time is consumed before using a sampled value function")
@CheckDescription(value="Ensure time is consumed before using a sampled value function in antecedent to avoid evaluating values before the start of simulation.\nExample:\n$fell(A) |-> B // not allowed\n##1 $fell(A) |-> B // allowed")
public class Check_SVTB_14_10_9
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="concurrent_assert, sequence, property", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();
    private Map<RfNamedElement, String> failures;
    private Map<RfNamedElement, String> filteredFailures;

    public Check_SVTB_14_10_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.failures = new HashMap<RfNamedElement, String>();
        this.filteredFailures = new HashMap<RfNamedElement, String>();
        String pFailureMessageFormatValue = "Not time consuming sampled value function ''{0}'' found on ''{1}''! Use ''##A $sampled_valued_function(B) |-> C'' instead.";
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, new HashSet<String>(Arrays.asList("($fell(_ANY_) |-> _B_)", "($past(_ANY_) |-> _B_)", "($stable(_A_) |-> _B_)", "($sampled(_ANY_) |-> _B_)", "($rose(_ANY_) |-> _B_)", "($changed(_ANY_) |-> _B_)")), pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
        this.detectPattern(this.fOVMProject, new HashSet<String>(Arrays.asList("(##_ANY_ $fell(_ANY_) |-> _B_)", "(##_ANY_ $past(_ANY_) |-> _B_)", "(##_ANY_ $stable(_A_) |-> _B_)", "(##_ANY_ $sampled(_ANY_) |-> _B_)", "(##_ANY_ $rose(_ANY_) |-> _B_)", "(##_ANY_ $changed(_ANY_) |-> _B_)")), pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind, true);
        for (Map.Entry<RfNamedElement, String> failure : this.failures.entrySet()) {
            if (this.filteredFailures.get(failure.getKey()) != null) continue;
            this.addHit(failure.getKey(), failure.getValue());
        }
    }

    @Override
    public void addLocalHit(RfNamedElement elm, String details, boolean filter) {
        if (!filter) {
            this.failures.put(elm, details);
        } else {
            this.filteredFailures.put(elm, details);
        }
    }
}

