/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.4")
@CheckID(value="SVTB.14.11")
@CheckName(value="SVTB.14.11")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use assertions in scope.")
@CheckDescription(value="Do not use assertions in <scope>.\n\nExamples for scope = 'function':\nfunction f()\n\tassert_1: assert (a == b);  // not allowed\nendfunction\n\nassert_1: assert (a != b); // allowed, outside function scope\n\nCheck supports pre-waiving.")
public class Check_SVTB_14_11
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="function, task, module", description="Comma separated list of: function, task, module, class.", name="scope", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pScope = new HashSet();
    @CheckParameter(defaultValue="", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover, expect, deferred_immediate_assert, simple_immediate_assert, immediate_assert, deferred_immediate_assume, simple_immediate_assume, immediate_assume, deferred_immediate_cover, simple_immediate_cover, immediate_cover, restrict. When empty, all kinds will be checked.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKindValue = new HashSet();

    public Check_SVTB_14_11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement assertion : this.fOVMProject.getAllAssertsExpects()) {
            RfAssertExpect tmpAssertion = (RfAssertExpect)assertion;
            RfFileDef file = assertion.getFile();
            if (file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this) || !this.pElementKindValue.isEmpty() && !this.checkKind(tmpAssertion)) continue;
            this.notifyCheckAlive();
            RfNamedElement enclosingScope = tmpAssertion.getEnclosingScope();
            this.checkEnclosingScope(assertion, enclosingScope);
        }
    }

    private boolean checkKind(RfAssertExpect tmpAssertion) {
        for (String elementKind : this.pElementKindValue) {
            if (elementKind.equals("deferred_immediate_assert") && tmpAssertion.isImmediateAssert() && tmpAssertion.isDeferred()) {
                return true;
            }
            if (elementKind.equals("simple_immediate_assert") && tmpAssertion.isImmediateAssert() && !tmpAssertion.isDeferred()) {
                return true;
            }
            if (elementKind.equals("immediate_assert") && tmpAssertion.isImmediateAssert()) {
                return true;
            }
            if (elementKind.equals("concurrent_assert") && tmpAssertion.isConcurrentAssert()) {
                return true;
            }
            if (elementKind.equals("expect") && tmpAssertion.isExpect()) {
                return true;
            }
            if (elementKind.equals("deferred_immediate_assume") && tmpAssertion.isImmediateAssume() && tmpAssertion.isDeferred()) {
                return true;
            }
            if (elementKind.equals("simple_immediate_assume") && tmpAssertion.isImmediateAssume() && !tmpAssertion.isDeferred()) {
                return true;
            }
            if (elementKind.equals("immediate_assume") && tmpAssertion.isImmediateAssume()) {
                return true;
            }
            if (elementKind.equals("concurrent_assume") && tmpAssertion.isConcurrentAssume()) {
                return true;
            }
            if (elementKind.equals("deferred_immediate_cover") && tmpAssertion.isImmediateCover() && tmpAssertion.isDeferred()) {
                return true;
            }
            if (elementKind.equals("simple_immediate_cover") && tmpAssertion.isImmediateCover() && !tmpAssertion.isDeferred()) {
                return true;
            }
            if (elementKind.equals("immediate_cover") && tmpAssertion.isImmediateCover()) {
                return true;
            }
            if (elementKind.equals("concurrent_cover") && tmpAssertion.isConcurrentCover()) {
                return true;
            }
            if (!elementKind.equals("restrict") || !tmpAssertion.isRestrict()) continue;
            return true;
        }
        return false;
    }

    private void checkEnclosingScope(RfNamedElement assertion, RfNamedElement enclosingScope) {
        if (enclosingScope == null || enclosingScope instanceof RfLibrary) {
            return;
        }
        String enclosingScopeKind = this.getScopeKind(enclosingScope);
        if (enclosingScopeKind != null && this.pScope.contains(enclosingScopeKind)) {
            this.addHit(assertion, "Assertion used in " + enclosingScopeKind + ": '" + LintUtils.getNamedElementFullName(enclosingScope) + "'");
            return;
        }
        this.checkEnclosingScope(assertion, enclosingScope.getEnclosingScope());
    }

    private String getScopeKind(IRfNamedElement scope) {
        if (scope instanceof RfFunction) {
            if (((RfFunction)scope).isTask()) {
                return "task";
            }
            return "function";
        }
        if (scope instanceof RfModule) {
            return "module";
        }
        if (scope instanceof RfClass) {
            return "class";
        }
        return null;
    }
}

