/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="3.5.30")
@CheckID(value="SVTB.14.1.2")
@CheckName(value="SVTB.14.1.2")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Assert property must use an 'else' block to report errors")
@CheckDescription(value="All concurrent assertions must use 'else <errorReportingMacros>/<errorReportingMethods>'.\n\nNot allowed:\n   assert property(...) else some actions;\n\nAllowed:\n   assert(...) else $error(....);\n\nCheck supports pre-waiving.")
public class Check_SVTB_14_1_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of macros names used for reporting.", name="errorReportingMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pUsedErrorReportingMacrosValue;
    @CheckParameter(defaultValue="$error", description="Comma separated list of method full names used for reporting.", name="errorReportingMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pUsedErrorReportingMethodsValue;

    public Check_SVTB_14_1_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("assert_else", this.pUsedErrorReportingMacrosValue);
    }

    protected String getFailMessage() {
        return "Assertion reporting is not done through report macros, nor report functions";
    }

    protected String getPassMessage() {
        return "All assert property constructs have an 'else $report_method/`report_macro' clause.";
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement assertion : this.fOVMProject.getAllAssertsExpects()) {
            if (this.checkPreWaivers(assertion.getFile())) continue;
            RfAssertExpect tmpAssertion = (RfAssertExpect)assertion;
            this.notifyCheckAlive();
            if (this.checkAssertionKind(tmpAssertion) || !this.checkAssertion(tmpAssertion)) continue;
            this.addHit(tmpAssertion, this.getFailMessage());
        }
    }

    protected boolean checkAssertionKind(RfAssertExpect tmpAssertion) {
        return !tmpAssertion.isConcurrentAssert();
    }

    protected boolean checkAssertion(RfAssertExpect tmpAssertion) {
        return !this.checkMethodsReporting(tmpAssertion) && !this.checkMacroReporting(tmpAssertion);
    }

    protected boolean checkMacroReporting(RfAssertExpect tmpAssertion) {
        if (this.pUsedErrorReportingMacrosValue == null || this.pUsedErrorReportingMacrosValue.isEmpty()) {
            return false;
        }
        MacroCallInfo macroCallInfo = tmpAssertion.getMacroCallInfo();
        if (macroCallInfo == null) {
            return false;
        }
        List<MacroCallItem> macros = macroCallInfo.getItems();
        if (macros == null || macros.isEmpty()) {
            return false;
        }
        for (MacroCallItem macro : macros) {
            if (!this.pUsedErrorReportingMacrosValue.contains(macro.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMethodsReporting(RfAssertExpect tmpAssertion) {
        if (this.pUsedErrorReportingMethodsValue == null || this.pUsedErrorReportingMethodsValue.isEmpty()) {
            return true;
        }
        List<RfActionBlock> actionBlocks = tmpAssertion.getLocalMembers(RfActionBlock.class);
        if (actionBlocks == null || actionBlocks.isEmpty()) {
            return false;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            if (!actionBlock.isElse()) continue;
            List<RfFunctionCall> functionCalls = actionBlock.getFunctionCallsWithPrefix("", 2);
            if (functionCalls == null || functionCalls.isEmpty()) {
                return false;
            }
            for (RfFunctionCall functionCall : functionCalls) {
                RfFunction function = functionCall.getFunction();
                String functionName = LintUtils.getNamedElementFullName(function == null ? functionCall : function);
                if (!this.pUsedErrorReportingMethodsValue.contains(functionName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

