/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="17.1.14")
@CheckID(value="SVTB.14.2")
@CheckName(value="SVTB.14.2")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use anonymous assertions")
@CheckDescription(value="Do not use anonymous assertions.\nExamples\nassertion_name: assert property (1 == 0) // allowed\n\t$display(\"true\");\nelse\n\t$display(\"false\");\n\nassert property (1 == 0) // not allowed\n\t$display(\"true\");\nelse\n\t$display(\"false\");\n\nendmodule\n\nCheck supports pre-waiving.")
public class Check_SVTB_14_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="concurrent_assert, concurrent_assume, concurrent_cover, restrict", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover, expect, immediate_assert, immediate_assume, immediate_cover, restrict.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKindValue = new HashSet();

    public Check_SVTB_14_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement assertion : this.fOVMProject.getAllAssertsExpects()) {
            if (this.checkPreWaivers(assertion.getFile())) continue;
            RfAssertExpect tmpAssertion = (RfAssertExpect)assertion;
            this.notifyCheckAlive();
            if (!this.checkKind(tmpAssertion) || !tmpAssertion.isAnonymous()) continue;
            this.addHit(tmpAssertion, "Anonymous " + tmpAssertion.getKindName() + " used!");
        }
    }

    private boolean checkKind(RfAssertExpect tmpAssertion) {
        for (String elementKind : this.pElementKindValue) {
            if (elementKind.equals("immediate_assert") && tmpAssertion.isImmediateAssert()) {
                return true;
            }
            if (elementKind.equals("concurrent_assert") && tmpAssertion.isConcurrentAssert()) {
                return true;
            }
            if (elementKind.equals("expect") && tmpAssertion.isExpect()) {
                return true;
            }
            if (elementKind.equals("immediate_assume") && tmpAssertion.isImmediateAssume()) {
                return true;
            }
            if (elementKind.equals("concurrent_assume") && tmpAssertion.isConcurrentAssume()) {
                return true;
            }
            if (elementKind.equals("immediate_cover") && tmpAssertion.isImmediateCover()) {
                return true;
            }
            if (elementKind.equals("concurrent_cover") && tmpAssertion.isConcurrentCover()) {
                return true;
            }
            if (!elementKind.equals("restrict") || !tmpAssertion.isRestrict()) continue;
            return true;
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

