/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.3")
@CheckName(value="SVTB.14.3")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use assume")
@CheckDescription(value="Do not use assume, use assert instead.\nExamples\nassertion_name: assert property (1 == 0) // allowed\n\t$display(\"true\");\nelse\n\t$display(\"false\");\n\nassume_name: assume property (1 == 0) // not allowed\n\t$display(\"true\");\nelse\n\t$display(\"false\");\n\nendmodule\n")
public class Check_SVTB_14_3
extends OVMComplianceCheck {
    public Check_SVTB_14_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement assertExpect : this.fOVMProject.getAllAssertsExpects()) {
            this.notifyCheckAlive();
            if (!(assertExpect instanceof RfAssertExpect) || !((RfAssertExpect)assertExpect).isAssume()) continue;
            this.addHit(assertExpect, "Forbidden use of 'assume'!");
        }
    }
}

