/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="17.1.36")
@CheckID(value="SVTB.14.4")
@CheckName(value="SVTB.14.4")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.SEQUENCE})
@CheckTitle(value="Do not use cover sequence")
@CheckDescription(value="Do not use cover sequence, use cover property instead.\nExample:\ncover sequence ($fell(rst) ##[*] b); //not allowed\ncover property ($fell(rst) ##[*] b); //allowed ")
public class Check_SVTB_14_4
extends OVMComplianceCheck {
    public Check_SVTB_14_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement assertExpect : this.fOVMProject.getAllAssertsExpects()) {
            this.notifyCheckAlive();
            if (!(assertExpect instanceof RfAssertExpect) || !((RfAssertExpect)assertExpect).isConcurrentCoverSequence()) continue;
            this.addHit(assertExpect, "Forbidden use of 'cover sequence'!");
        }
    }
}

