/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMemberExternImplementationCheck;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.15.3.1")
@CheckName(value="SVTB.15.3.1")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.CONSTRAINT, RuleLabel.VERIFICATION})
@CheckTitle(value="External Constraint Block")
@CheckDescription(value="All constraint blocks must be declared in the body of a class and defined outside the body of the class.\nThis ensures that the class remains readable - at a quick glance the user can see what the members, methods, constraints and coverage groups are. \n\nExamples:\nclass A;\n\tinteger a;\n\tconstraint c1 { a > 2; a < 4; };  // not allowed\n\n\textern constraint c2; // allowed\nendclass\n\nconstraint A::c2 { a == 1;}\n")
@CheckParameterOverride(name="methodMaxNofLines", isVisible=false)
public class Check_SVTB_15_3_1
extends AbstractMemberExternImplementationCheck {
    public Check_SVTB_15_3_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected Set<Class<? extends RfNamedElement>> getClassTypes() {
        HashSet<Class<? extends RfNamedElement>> classTypes = new HashSet<Class<? extends RfNamedElement>>();
        classTypes.add(RfConstraint.class);
        return classTypes;
    }

    @Override
    protected int getMaxNofLinesFor(RfDefElement rfDefElement) {
        return rfDefElement instanceof RfConstraintDef ? this.pConstraintMaxNofLinesValue : Integer.MAX_VALUE;
    }
}

