/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.17")
@CheckID(value="SVTB.15.3.4.1")
@CheckName(value="SVTB.15.3.4.1")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.CONSTRAINT, RuleLabel.VERIFICATION, RuleLabel.DISTRIBUTION})
@CheckTitle(value="Constraint distribution weights must add up to a power of 10")
@CheckDescription(value="Constraint distribution weights must add up to a power of 10.\n\nImplementation Notes:\nLinter only checks literal numeric values. It doesn't evaluate expressions.\n\nExamples:\nconstraint c {\n\tmy_var dist { 0 := 80, 1 := 10, 2 := 5, 3 := 5 }; // allowed\n\tmy_var dist { 0 := 80, 1 := 10, 2 := 5, 3 := 1 }; // not allowed\n\n};\n\nCheck supports pre-waiving.")
public class Check_SVTB_15_3_4_1
extends OVMComplianceCheck {
    public Check_SVTB_15_3_4_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOp) {
                if (hidOp == null) {
                    return true;
                }
                if (!hidOp.hasOccurrence(HidOperatorQualifier.IS_DISTRIBUTION)) {
                    return true;
                }
                ListContainer rhValues = hidOp.getRHValues();
                if (rhValues == null || rhValues.isEmpty()) {
                    return true;
                }
                Check_SVTB_15_3_4_1.this.notifyCheckAlive();
                if (Check_SVTB_15_3_4_1.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                IHidObject weightsHolder = (IHidObject)rhValues.get(0);
                if (!HidUtils.isOperator((IHidObject)weightsHolder) || ((HidOperator)weightsHolder).getOperatorKind() != IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                    return true;
                }
                ListContainer weights = ((HidOperator)weightsHolder).getRHValues();
                if (weights == null || weights.isEmpty()) {
                    return true;
                }
                int sumOfWeights = 0;
                for (IHidObject weight : weights) {
                    if (HidUtils.isHidImplicit((IHidObject)weight) || HidUtils.isHid((IHidObject)weight) || HidUtils.isHidAccess((IHidObject)weight)) {
                        ++sumOfWeights;
                        continue;
                    }
                    if (!HidUtils.isOperator((IHidObject)weight)) continue;
                    RfHidOperator weightOperator = (RfHidOperator)weight;
                    if (weightOperator.isColonEq() || weightOperator.isColonDiv()) {
                        ListContainer weightRHValues = weightOperator.getRHValues();
                        if (weightRHValues == null || weightRHValues.isEmpty()) continue;
                        IHidObject weightValue = (IHidObject)weightRHValues.get(0);
                        if (!HidUtils.isHidImplicit((IHidObject)weightValue)) {
                            return true;
                        }
                        Number weightNumber = ((RfHidImplicit)weightValue).parseNumberValue();
                        if (weightNumber == null) continue;
                        IHidObject lhValue = weightOperator.getLHValue();
                        if (HidUtils.isOperator((IHidObject)lhValue) && ((RfHidOperator)lhValue).isColon()) {
                            int weightSum = this.getSumOfWeights((RfHidOperator)lhValue, weightNumber.intValue(), weightOperator.isColonEq());
                            if (weightSum == -1) {
                                return true;
                            }
                            sumOfWeights += weightSum;
                            continue;
                        }
                        sumOfWeights += weightNumber.intValue();
                        continue;
                    }
                    if (!weightOperator.isColon()) continue;
                    int weightSum = this.getSumOfWeights(weightOperator, 1, true);
                    if (weightSum == -1) {
                        return true;
                    }
                    sumOfWeights += weightSum;
                }
                if (sumOfWeights != 1 && sumOfWeights != 10 && sumOfWeights != 100 && sumOfWeights != 1000 && sumOfWeights != 10000 && sumOfWeights != 100000 && sumOfWeights != 1000000 && sumOfWeights != 10000000 && sumOfWeights != 100000000 && sumOfWeights != 1000000000) {
                    Check_SVTB_15_3_4_1.this.addHit(this.parserPath, (HidOccurrence)hidOp.getOccurrence(), "Constraint distribution weights sum " + sumOfWeights + " is not a power of 10!");
                }
                return true;
            }

            private int getSumOfWeights(RfHidOperator operator, int weightNumber, boolean isColonEqual) {
                if (!isColonEqual) {
                    return weightNumber;
                }
                IHidObject lhRange = operator.getLHValue();
                ListContainer rhRanges = operator.getRHValues();
                if (rhRanges == null || rhRanges.isEmpty()) {
                    return -1;
                }
                IHidObject rhRange = (IHidObject)rhRanges.get(0);
                if (!HidUtils.isHidImplicit((IHidObject)lhRange) || !HidUtils.isHidImplicit((IHidObject)rhRange)) {
                    return -1;
                }
                Number lhRangeNumber = ((RfHidImplicit)lhRange).parseNumberValue();
                Number rhRangeNumber = ((RfHidImplicit)rhRange).parseNumberValue();
                if (lhRangeNumber == null || rhRangeNumber == null) {
                    return -1;
                }
                int rangeLength = rhRangeNumber.intValue() - lhRangeNumber.intValue() + 1;
                rangeLength = rangeLength > 0 ? weightNumber * rangeLength : 0;
                return rangeLength;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

