/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1.4")
@CheckID(value="SVTB.15.4.10")
@CheckName(value="SVTB.15.4.10")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.PERFORMANCE, RuleLabel.FUNCTIONAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Not Allowed: randc")
@CheckDescription(value="Randc is a partial solution for a uniform distribution, as it is focused only on a specific property, not on a combination.\nIt impacts performance (cpu/memory) and it may lead to strange generation contradictions.\n\nExamples:\nrand int a; // allowed\nrandc int b; // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_15_4_10
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipMembersDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMembersDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes, for example uvm_pkg::uvm_.", name="skipMembersDeclaredInsideClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMembersDeclaredInsideClassesWithPrefixesValue;

    public Check_SVTB_15_4_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> classMembersIteratorKeys = new HashSet<String>();
        classMembersIteratorKeys.add("field");
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (eachClass == null || !(eachClass instanceof RfClass) || this.checkPreWaivers(eachClass.getFile())) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator((RfClass)eachClass, classMembersIteratorKeys, true, this.pSkipMembersDeclaredInsideMacrosWithPrefixesValue, this.pSkipMembersDeclaredInsideClassesWithPrefixesValue);
            while (classMembersIterator.hasNext()) {
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null) continue;
                String memberInfo = String.valueOf(eachClass.getName()) + "." + eachMember.getName();
                if (!eachMember.isRandc()) continue;
                this.addHit(eachMember, "Randc class member '" + memberInfo + "' not allowed!");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

