/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_15_4_1_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCheckCallsInIfAndAssert;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.15.4.1.1")
@CheckName(value="SVTB.15.4.1.1")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Check randomize calls")
@CheckDescription(value="The LRM does not specify a simulator runtime error in the event of failed randomization.\nYou must check randomization failures using if or assert.\n\nExamples:\n if(!myclass.randomize())\n    `xvm_fatal( get_type_name(), \"myclass randomize failed!\" )\n\n assert(myclass.randomize()) else\n    `xvm_fatal( get_type_name(), \"myclass randomize failed!\" )\n\n int tmp;\n tmp = myclass.randomize();\n assert(tmp) else\n    `xvm_fatal( get_type_name(), \"myclass randomize failed!\" )\n\nImplementation Notes:\nWhen using a local variable for checking the randomization status, it is recommended to perform the check immediately after the randomize call.\nThis recommendation is not enforced by the rule.\nWhen allowTempVariableChecking is set, the rule will pass for the following example:\n\n int tmp;\n tmp = myclass.randomize();\n tmp = 1;\n assert(tmp) else\n    `xvm_fatal( get_type_name(), \"myclass randomize failed!\")\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_15_4_1_1.class)
@CheckParametersOverrides(value={@CheckParameterOverride(name="skipCallsCastedToVoid", description="When true, randomize calls casted to void are not checked."), @CheckParameterOverride(name="allowOnlyIfChecking", description="When true, randomization failures must be checked using only if."), @CheckParameterOverride(name="allowTempVariableChecking", description="When true, a local variable may be used to hold the randomization status and subsequently checked."), @CheckParameterOverride(name="checkCondition", description="When true, if/assert conditions containing randomize are also checked(for if: !randomize, for assert:(!)randomize)."), @CheckParameterOverride(name="checkFailureMacros", description="Checked calls in if/assert conditions must also report potential failures using macros from this list."), @CheckParameterOverride(name="analyzeTypeParameterAccess", description="When true, functions with type param accesses are also analyzed.")})
public class Check_SVTB_15_4_1_1
extends AbstractCheckCallsInIfAndAssert {
    public Check_SVTB_15_4_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.performCallCheck("randomize");
    }

    @Override
    protected void addHitForCheck(ParserPath parserPath, HidOperatorOccurrence occurrence, String message, VerissimoAutofixAdditionalInfo verissimoAutofixAdditionalInfo) {
        this.addHit(parserPath, (HidOccurrence)occurrence, message, verissimoAutofixAdditionalInfo);
    }

    @Override
    protected void addHitForCheck(ParserPath parserPath, int line, String message, ReparseInfo reparseInfo, VerissimoAutofixAdditionalInfo verissimoAutofixAdditionalInfo) {
        this.addHit(parserPath, line, message, reparseInfo, verissimoAutofixAdditionalInfo);
    }
}

