/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.6")
@CheckID(value="SVTB.15.4.1.4")
@CheckName(value="SVTB.15.4.1.4")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.ASSIGNMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not assign the status of randomize() to the randomized variable")
@CheckDescription(value="Do not assign the status of randomize() to the randomized variable. This is a common mistake.\n\nExample\nNot Allowed:\n   a = randomize(a);\nAllowed:\n   success = randomize(a);\n\nCheck supports pre-waiving.")
public class Check_SVTB_15_4_1_4
extends OVMComplianceCheck {
    public Check_SVTB_15_4_1_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new RandomizeAssignmentVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class RandomizeAssignmentVisitor
    implements IHidVisitor<IHidOperator> {
        private RfNamedElement scope;
        private ParserPath parserPath;

        private RandomizeAssignmentVisitor() {
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidOperator operator) {
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            if (!operator.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) && !operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                return true;
            }
            ListContainer rhHids = operator.getRHValues();
            if (rhHids == null || rhHids.isEmpty()) {
                return true;
            }
            Check_SVTB_15_4_1_4.this.notifyCheckAlive();
            if (Check_SVTB_15_4_1_4.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            HashSet<IRfNamedElement> randomizedElements = new HashSet<IRfNamedElement>();
            for (IHidObject rhHid : rhHids) {
                RfHidAccessArgs rhHidAccessArgs;
                if (!(rhHid instanceof RfHidAccessArgs) || (rhHidAccessArgs = (RfHidAccessArgs)rhHid).getParentHid() == null || !rhHidAccessArgs.getParentHid().getName().equals("randomize")) continue;
                List<? extends IHidObject> argValues = ((RfHidAccessArgs)rhHid).getArgumentValues();
                for (IHidObject iHidObject : argValues) {
                    IRfNamedElement randomizeElement;
                    IHidObject randomizeArgument;
                    ListContainer randomizeArguments;
                    if (!(iHidObject instanceof RfHidOperator) || (randomizeArguments = ((RfHidOperator)iHidObject).getRHValues()) == null || randomizeArguments.size() != 1 || !((randomizeArgument = (IHidObject)randomizeArguments.get(0)) instanceof RfHid) || (randomizeElement = ((RfHid)randomizeArgument).getElement()) == null) continue;
                    randomizedElements.add(randomizeElement);
                }
            }
            if (randomizedElements.isEmpty()) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            if (!operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                if (lhValue == null || !(lhValue instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement lhElement = ((RfHid)lhValue).getElement();
                if (lhElement instanceof RfNamedElement && randomizedElements.contains(lhElement)) {
                    Check_SVTB_15_4_1_4.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "The status of randomize() is assigned to the variable being randomized '" + LintUtils.getNamedElementFullName((RfNamedElement)lhElement) + "'!");
                }
            } else {
                if (lhValue == null || !(lhValue instanceof RfHidImplicit)) {
                    return true;
                }
                String leftName = ((RfHidImplicit)lhValue).getName();
                if (leftName == null || leftName.isEmpty()) {
                    return true;
                }
                for (IRfNamedElement randomizedElement : randomizedElements) {
                    if (!randomizedElement.getName().equals(leftName)) continue;
                    Check_SVTB_15_4_1_4.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "The status of randomize() is assigned to the variable being randomized '" + LintUtils.getNamedElementFullName((RfNamedElement)randomizedElement) + "'!");
                    return true;
                }
            }
            return true;
        }

        public Class<IHidOperator> getType() {
            return IHidOperator.class;
        }
    }
}

