/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.15.4.9")
@CheckName(value="SVTB.15.4.9")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.FUNCTIONAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Not Allowed: Randomization of Non-Rand member variables")
@CheckDescription(value="The LRM allows the randomize method to select which variables to randomize. This includes allowing randomization of non-rand member variables.\nRandomization of non-rand class members is not allowed - as it overrides the class designer's intent and will likely result in unexpected behaviour.\nExample:\nclass randclass;\n  rand bit [1:0] x; //random variables\n  rand bit [1:0] y;\n  bit [1:0] a, b; // state variables\nendclass: randclass\n...\nrandclass myrand = new;\ninitial begin\n  int success;\n  success = myrand.randomize();\n  success = myrand.randomize(x);\n  success = myrand.randomize(x,a); // bad! a non rand\n  success = myrand.randomize(a,b); // bad! b non rand\nend\n\nCheck supports pre-waiving.")
public class Check_SVTB_15_4_9
extends OVMComplianceCheck {
    public Check_SVTB_15_4_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement callContainer : this.fOVMProject.getAllNonXVMFunctionCallContainers()) {
            List<RfFunctionCall> calls;
            if (this.checkPreWaivers(callContainer.getFile()) || (calls = callContainer.getFunctionCallsWithPrefix("", 2)) == null || calls.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfFunctionCall call : calls) {
                List<String> arguments;
                RfNamedElement callOf;
                if (!call.getName().endsWith(".randomize") && !call.getName().endsWith("::randomize") && !call.getName().equals(".randomize") || (callOf = LintUtils.getCallOfPhysicalType(call)) == null || !(callOf instanceof RfClass) || (arguments = call.getArguments()) == null) continue;
                int i = 0;
                while (i < arguments.size()) {
                    String[] nameAndSelect = LintUtils.getNameAndSelect(call.getArgumentValue(i));
                    String argName = nameAndSelect[0];
                    RfField member = callOf.getFieldWithPrefix(argName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                    if (member != null && !member.isRand() && !member.isRandc()) {
                        this.addHit(call, "randomize() call on non-rand variable '" + argName + "'");
                    }
                    ++i;
                }
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

