/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_15_5_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1.4")
@CheckID(value="SVTB.15.5.1")
@CheckName(value="SVTB.15.5.1")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Rand class members must be public")
@CheckDescription(value="Rand class members must be public in order to allow the inline randomization (\"with\" randomization) from outside the class.\nImplementation Notes:\nAll rand and randc class members are checked. They should not be private nor protected.\n\nExamples:\nclass a;\n  local rand int x; // not allowed\n  protected rand int y; // not allowed\n  rand int z; // allowed\nendclass\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_15_5_1.class)
public class Check_SVTB_15_5_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipMembersDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMembersDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes, for example uvm_pkg::uvm_.", name="skipMembersDeclaredInsideClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMembersDeclaredInsideClassesWithPrefixesValue;

    public Check_SVTB_15_5_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> fieldIteratorKeys = new HashSet<String>();
        fieldIteratorKeys.add("field");
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (eachClass == null || !(eachClass instanceof RfClass) || this.checkPreWaivers(eachClass.getFile())) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator((RfClass)eachClass, fieldIteratorKeys, true, this.pSkipMembersDeclaredInsideMacrosWithPrefixesValue, this.pSkipMembersDeclaredInsideClassesWithPrefixesValue);
            while (classMembersIterator.hasNext()) {
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null) continue;
                String memberInfo = String.valueOf(eachClass.getName()) + "." + eachMember.getName();
                if (!eachMember.isRand() && !eachMember.isRandc() || eachMember.isPublic()) continue;
                this.addHit(eachMember, "Rand class member '" + memberInfo + "' is not public!", new VerissimoAutofixAdditionalInfo(eachMember));
            }
        }
    }

    @Override
    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        return String.valueOf(LintUtils.getElementKind((RfNamedElement)element)) + " '" + ((RfNamedElement)element).getName() + "'";
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

