/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.DataTypeDimensions;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SDataType;

@CheckVersion(value="3.3")
@CheckID(value="SVTB.15.6.1")
@CheckName(value="SVTB.15.6.1")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.CONSTRAINT, RuleLabel.FUNCTIONAL, RuleLabel.VERIFICATION})
@CheckTitle(value=".sum() type mismatch in constraints")
@CheckDescription(value="Using expr.sum() == expr constraints without type matching may lead to unexpected results.\n\n Example:\n\n bit a [5] ;\n int b ;\n\n constraint c {\n    a.sum() == b;\n }\n\nThe LRM says a.sum() has the type bit, so it (and b) cannot have a value above 1.\n\nImplementation Notes:\nOnly hierarchical_access_expr are checked.\nThe following operators are checked: ==, !=, >, >=, <, <=\nLIMITATION: expressions are not computed => false alarms, for example [1+1:0] vs. [2:0]\nLIMITATION: constant expressions are not supported => false alarmas, for example a.sum() == 10;\n\nCheck supports pre-waiving.")
public class Check_SVTB_15_6_1
extends OVMComplianceCheck {
    public Check_SVTB_15_6_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new OperatorVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class OperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        public boolean visit(RfHidOperator hidOperator) {
            String message;
            String rightName;
            RfHidAccessArgs rightAccessArgs;
            IRfNamedElement element;
            RfHidAccessArgs leftAccessArgs;
            Hid parentHid;
            if (hidOperator == null) {
                return true;
            }
            if (Check_SVTB_15_6_1.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_SVTB_15_6_1.this.notifyCheckAlive();
            if (!hidOperator.isEqualityOrInequality() && !hidOperator.isRelational()) {
                return true;
            }
            if (this.scope.getEnclosingScope(RfConstraint.class) == null) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            ListContainer rhValues = hidOperator.getRHValues();
            if (lhValue == null || rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            boolean leftIsSum = false;
            boolean rightIsSum = false;
            if (lhValue instanceof RfHidAccessArgs && (parentHid = (leftAccessArgs = (RfHidAccessArgs)lhValue).getParentHid()) instanceof RfHid && (element = ((RfHid)parentHid).getElement()) instanceof RfPredefinedFunction && "sum".equals(element.getName())) {
                leftIsSum = true;
            }
            if (rhValue instanceof RfHidAccessArgs && (parentHid = (rightAccessArgs = (RfHidAccessArgs)rhValue).getParentHid()) instanceof RfHid && (element = ((RfHid)parentHid).getElement()) instanceof RfPredefinedFunction && "sum".equals(element.getName())) {
                rightIsSum = true;
            }
            if (!leftIsSum && !rightIsSum) {
                return true;
            }
            boolean isLeftOrRightImplicitNumber = false;
            IRfNamedElement leftType = null;
            if (leftIsSum) {
                RfHidAccessArgs args = (RfHidAccessArgs)lhValue;
                leftType = args.getAssociatedType();
                if (args.hasWithClause()) {
                    leftType = this.getActualTypeForWith(args);
                }
            } else if (lhValue instanceof RfHid) {
                element = ((RfHid)lhValue).getElement();
                if (element instanceof RfField) {
                    leftType = ((RfField)element).getAssociatedType();
                }
            } else if (lhValue instanceof RfHidAccess) {
                leftType = ((RfHidAccess)lhValue).getAssociatedType();
            } else if (lhValue instanceof RfHidImplicit && ((RfHidImplicit)lhValue).isNumber()) {
                isLeftOrRightImplicitNumber = true;
            }
            IRfNamedElement rightType = null;
            if (rightIsSum) {
                RfHidAccessArgs args = (RfHidAccessArgs)rhValue;
                rightType = args.getAssociatedType();
                if (args.hasWithClause()) {
                    rightType = this.getActualTypeForWith(args);
                }
            } else if (rhValue instanceof RfHid) {
                IRfNamedElement element2 = ((RfHid)rhValue).getElement();
                if (element2 instanceof RfField) {
                    rightType = ((RfField)element2).getAssociatedType();
                }
            } else if (rhValue instanceof RfHidAccess) {
                rightType = ((RfHidAccess)rhValue).getAssociatedType();
            } else if (rhValue instanceof RfHidImplicit && ((RfHidImplicit)rhValue).isNumber()) {
                isLeftOrRightImplicitNumber = true;
            }
            String leftName = lhValue instanceof RfHid ? ((RfHid)lhValue).getName() : lhValue.toString();
            String string = rightName = rhValue instanceof RfHid ? ((RfHid)rhValue).getName() : rhValue.toString();
            if (leftType == null || rightType == null) {
                if (isLeftOrRightImplicitNumber) {
                    if (leftType == null && rightType instanceof RfBitVectorScalarType) {
                        return true;
                    }
                    if (rightType == null && leftType instanceof RfBitVectorScalarType) {
                        return true;
                    }
                }
                String leftInfo = leftType != null ? leftType.getName() : "unknown";
                String rightInfo = rightType != null ? rightType.getName() : "unknown";
                String message2 = "Type mismatch: '" + leftName + "' of type '" + leftInfo + "' differs from '" + rightName + "' of type '" + rightInfo + "'!";
                Check_SVTB_15_6_1.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), message2);
                return true;
            }
            DataTypeDimensions leftDimensions = new DataTypeDimensions(leftType);
            if (leftType instanceof RfAssociatedType && !(leftType instanceof RfComputedListType)) {
                RfTypesResolver typesResolver = RfTypesResolver.create((IRfScopeElement)((RfAssociatedType)leftType).getEnclosingScope(), ((RfAssociatedType)leftType).getRfProject(), 6);
                IRfNamedElement result = ((RfAssociatedType)leftType).getAssociatedType(typesResolver);
                if (result instanceof RfTypeAlias) {
                    result = ((RfTypeAlias)result).getTranslatedType(typesResolver, false, leftDimensions, null);
                }
                leftType = result;
            }
            DataTypeDimensions rightDimensions = new DataTypeDimensions(rightType);
            if (rightType instanceof RfAssociatedType && !(rightType instanceof RfComputedListType)) {
                RfTypesResolver typesResolver = RfTypesResolver.create((IRfScopeElement)((RfAssociatedType)rightType).getEnclosingScope(), ((RfAssociatedType)rightType).getRfProject(), 6);
                IRfNamedElement result = ((RfAssociatedType)rightType).getAssociatedType(typesResolver);
                if (result instanceof RfTypeAlias) {
                    result = ((RfTypeAlias)result).getTranslatedType(typesResolver, false, rightDimensions, null);
                }
                rightType = result;
            }
            if (!this.compareTypes(leftType, leftDimensions, rightType, rightDimensions)) {
                message = "Type mismatch: '" + leftName + "' of type '" + leftType.getName() + "' differs from '" + rightName + "' of type '" + rightType.getName() + "'!";
                Check_SVTB_15_6_1.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), message);
                return true;
            }
            if (leftType instanceof RfComputedListType && rightType instanceof RfComputedListType) {
                if (!((RfComputedListType)leftType).checkUnpackedDimensionsCompatibility((RfComputedListType)rightType)) {
                    message = "Unpacked dimension mismatch: '" + leftName + "' of '" + leftType.getName() + "' differs from '" + rightName + "' of '" + rightType.getName() + "'!";
                    Check_SVTB_15_6_1.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), message);
                    return true;
                }
                if (!((RfComputedListType)leftType).checkPackedDimensionsCompatibility((RfComputedListType)rightType)) {
                    message = "Packed dimension mismatch: '" + leftName + "' of '" + leftType.getName() + "' differs from '" + rightName + "' of '" + rightType.getName() + "'!";
                    Check_SVTB_15_6_1.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), message);
                    return true;
                }
            } else {
                if (!leftDimensions.compareUnpackedDimension(rightDimensions)) {
                    message = "Unpacked dimension mismatch: '" + leftName + "' of '" + leftType.getName() + "' differs from '" + rightName + "' of '" + rightType.getName() + "'!";
                    Check_SVTB_15_6_1.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), message);
                    return true;
                }
                if (!leftDimensions.comparePackedDimension(rightDimensions)) {
                    message = "Packed dimension mismatch: '" + leftName + "' of '" + leftType.getName() + "' differs from '" + rightName + "' of '" + rightType.getName() + "'!";
                    Check_SVTB_15_6_1.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), message);
                    return true;
                }
            }
            return true;
        }

        private IRfNamedElement getActualTypeForWith(RfHidAccessArgs args) {
            IRfNamedElement returnType = args.getAssociatedType();
            HidOperator withClause = args.getWithClause();
            if (!(withClause instanceof RfHidOperator)) {
                return returnType;
            }
            RfHidOperator withClauseOp = (RfHidOperator)withClause;
            ISDataAbstract resolvedType = withClauseOp.getOperatorResolvedType();
            if (!(resolvedType instanceof SDataVariable)) {
                return returnType;
            }
            SDataVariable resolvedTypeVar = (SDataVariable)resolvedType;
            ISDataType varType = resolvedTypeVar.type;
            if (!(varType instanceof SDataType)) {
                return returnType;
            }
            if (((SDataType)varType).getType() != null) {
                returnType = ((SDataType)varType).getType();
            }
            if (returnType instanceof RfComputedListType) {
                return RfBitVectorScalarType.getBitVectorScalar(((RfComputedListType)returnType).getBitSize(), 1, 1);
            }
            return returnType;
        }

        private boolean compareTypes(IRfNamedElement leftType, DataTypeDimensions leftDimensions, IRfNamedElement rightType, DataTypeDimensions rightDimensions) {
            RfNamedElement leftFinalType = this.getFinalElementType(leftType, leftDimensions);
            RfNamedElement rightFinalType = this.getFinalElementType(rightType, rightDimensions);
            if (leftFinalType instanceof RfBitVectorScalarType && rightFinalType instanceof RfBitVectorScalarType && leftFinalType.getName() != null) {
                leftFinalType = ((RfBitVectorScalarType)leftFinalType).getScalarWithDefaultSign();
                rightFinalType = ((RfBitVectorScalarType)rightFinalType).getScalarWithDefaultSign();
                return leftFinalType.getName().equals(rightFinalType.getName());
            }
            return leftFinalType.checkEquals(rightFinalType);
        }

        public RfNamedElement getFinalElementType(IRfNamedElement leftType, DataTypeDimensions leftDimensions) {
            IRfNamedElement result = leftType;
            if (result instanceof RfComputedListType) {
                return (result = ((RfComputedListType)result).getAssociatedBaseType()) instanceof RfNamedElement ? (RfNamedElement)result : null;
            }
            if (result instanceof RfAssociatedType) {
                RfTypesResolver typesResolver = RfTypesResolver.create((IRfScopeElement)((RfAssociatedType)result).getEnclosingScope(), ((RfAssociatedType)result).getRfProject(), 6);
                while (result != null && (result instanceof RfListType || result instanceof RfTypeAlias)) {
                    if (result instanceof RfListType) {
                        DataType listDataType = ((RfListType)result).getDataType();
                        leftDimensions.appendPackedDimension(listDataType.getPackedDimension());
                        leftDimensions.appendUnpackedDimension(listDataType.getUnpackedDimension());
                        result = ((RfListType)result).getAssociatedTypeNoLastLevelParams(typesResolver);
                    }
                    if (!(result instanceof RfTypeAlias)) continue;
                    DataType aliasDataType = ((RfTypeAlias)result).getDataType();
                    leftDimensions.appendPackedDimension(aliasDataType.getPackedDimension());
                    leftDimensions.appendUnpackedDimension(aliasDataType.getUnpackedDimension());
                    result = ((RfTypeAlias)result).getAssociatedTypeNoLastLevelParams(typesResolver);
                }
            }
            if (result instanceof RfNamedElement) {
                return (RfNamedElement)result;
            }
            return null;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

