/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_15_7_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractRandomStabilityCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="3.5.35")
@CheckID(value="SVTB.15.7.1")
@CheckName(value="SVTB.15.7.1")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.CLASS_INSTANTIATION, RuleLabel.RANDOM_STABILITY})
@CheckTitle(value="Do not use new() without get_randstate()")
@CheckDescription(value="All functions that allocate new() objects should not break random stability as it may lead to unexpected behavior or inconsistencies.\n\nTo preserve random stability use 'randstate' guards:\n   process p = process::self();\n   string p_rand;\n   if(p!=null) p_rand = p.get_randstate();\n   // new here ...\n   if(p!=null) p.set_randstate(p_rand);\n\nImplementation Notes:\nThis rule flags all functions that call new(), but don't call get_randstate(). It doesn't fully check the above guard.\nIt goes recursively, foo() calling moo() that calls new() without randstate() is also flagged.\nbase.boo() calling virtual derived.foo() overridden with new() call does not flag the derived.boo() -> derived.foo() stack:\n class base;\n    function void boo();\n    endfunction\n\n    virtual function void foo();\n    endfunction\n endclass\n\n class derived;\n    virtual function void foo(); // this is flagged if random unstable, but the derived.boo() side effect is not signaled\n    // new here...\n    endfunction\n endclass\n\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_15_7_1.class)
@CheckReapplyDisable
public class Check_SVTB_15_7_1
extends AbstractRandomStabilityCheck {
    @CheckParameter(defaultValue="true", description="When true, calls to XVM library methods will be skipped.", name="skipXVMMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipXVMMethodsValue;

    public Check_SVTB_15_7_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
    }

    @Override
    protected Object isFunctionOrActionBlockUnstable(RfNamedElement function, List<RfFunctionCall> functionCalls) {
        for (RfFunctionCall call : functionCalls) {
            if (!Check_SVTB_15_7_1.checkFunctionCall(this.fOVMProject, this.pSkipXVMMethodsValue, call)) continue;
            return call;
        }
        return null;
    }

    public static boolean checkFunctionCall(OVMProject ovmProject, boolean skipXVMMethods, RfFunctionCall call) {
        if (!"new".equals(call.getName())) {
            return false;
        }
        RfFunction calledFunction = call.getFunction();
        if (calledFunction != null && calledFunction.isConstructor() && calledFunction.getEnclosingScope() instanceof RfClass) {
            RfNamedElement scope = call.getEnclosingScope();
            if (scope == null) {
                return false;
            }
            RfFileDef file = scope.getFile();
            if (file == null) {
                return false;
            }
            if (skipXVMMethods && ovmProject.isOVMFile(file.getName())) {
                return false;
            }
            RfDefElement declaration = call.getDeclaration();
            if (declaration == null) {
                return false;
            }
            ReparseInfo reparseInfo = declaration.getReparseInfo();
            if (reparseInfo == null) {
                return true;
            }
            if (skipXVMMethods) {
                ParserPath reparseInfoParserPath = reparseInfo.getLastReparseMacroFile();
                String shortFileName = LintUtils.getFileShortName(reparseInfoParserPath.path);
                if (shortFileName != null && ovmProject.isOVMFile(shortFileName)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getUnstableCause(RfNamedElement function, boolean verbose) {
        if (function == null) {
            return "";
        }
        Object unstableCause = this.unstableCauses.get(function.getFullName());
        if (unstableCause instanceof RfFunctionCall) {
            RfFunctionCall newCall = (RfFunctionCall)unstableCause;
            return this.addLineFileInfo(newCall, verbose ? "calls " + newCall.getFullName() + "() " : "");
        }
        return "";
    }

    @Override
    protected boolean checkIfValidHit(RfNamedElement elm, Set<RfActionBlock> startingScopes) {
        return startingScopes == null || startingScopes.isEmpty();
    }
}

