/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_15_7_1;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.29")
@CheckID(value="SVTB.15.7.1.1")
@CheckName(value="SVTB.15.7.1.1")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.CLASS_INSTANTIATION, RuleLabel.RANDOM_STABILITY})
@CheckTitle(value="Do not use new() without get_randstate() inside an if uvm_report_enabled() block")
@CheckDescription(value="All functions that allocate new() objects should not break random stability as it may lead to unexpected behavior or inconsistencies.\n\nTo preserve random stability use 'randstate' guards if under an if uvm_report_enabled() block:\n   if (uvm_report_enabled(UVM_HIGH, UVM_INFO, \"id\")) begin\n      process p = process::self();\n      string p_rand;\n      if (p!=null) p_rand = p.get_randstate();\n      // new here ...\n      if (p!=null) p.set_randstate(p_rand);\n   end\n\nImplementation Notes:\nThis rule flags all if uvm_report_enabled blocks that call new(), but don't call get_randstate(). It doesn't fully check the above guard.\nIt goes recursively, foo() calling moo() that calls new() without randstate() is also flagged.\nbase.boo() calling virtual derived.foo() overridden with new() call does not flag the derived.boo() -> derived.foo() stack:\n class base;\n    function void boo();\n    endfunction\n\n    virtual function void foo();\n    endfunction\n endclass\n\n class derived;\n    virtual function void foo(); // this is flagged if random unstable, but the derived.boo() side effect is not signaled\n    // new here...\n    endfunction\n endclass")
@CheckReapplyDisable
public class Check_SVTB_15_7_1_1
extends Check_SVTB_15_7_1 {
    public Check_SVTB_15_7_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
    }

    @Override
    protected Set<RfActionBlock> getStartingScopes() {
        final HashSet<RfActionBlock> result = new HashSet<RfActionBlock>();
        HidOperatorVisitor hidOperatorVisitor = new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION}){
            RfActionBlock actionBlockEnclosingScope;

            public boolean visit(HidOperator operator) {
                if (this.actionBlockEnclosingScope == null) {
                    return true;
                }
                if (!operator.hasOccurrence(HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION)) {
                    return true;
                }
                if (!(operator instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator hidOperator = (RfHidOperator)operator;
                if (hidOperator.getOperatorType() != IHidOperatorConstants.OperatorType.IF_CONDITION.id) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                if (lhValue == null || !(lhValue instanceof RfHidAccessArgs)) {
                    return true;
                }
                RfHidAccessArgs hidAccessArgs = (RfHidAccessArgs)lhValue;
                if (hidAccessArgs.getParentHid() == null || !"uvm_report_enabled".equals(hidAccessArgs.getParentHid().getName())) {
                    return true;
                }
                result.add(this.actionBlockEnclosingScope);
                return true;
            }

            public void setHolder(IHidHolder holder) {
                this.actionBlockEnclosingScope = holder instanceof RfHidHolder && ((HidHolder)holder).getScope() instanceof RfActionBlock ? (RfActionBlock)((HidHolder)holder).getScope() : null;
            }
        };
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            clazz.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)hidOperatorVisitor);
        }
        return result;
    }

    @Override
    protected boolean checkIfValidHit(RfNamedElement elm, Set<RfActionBlock> startingScopes) {
        return elm instanceof RfActionBlock && startingScopes != null && !startingScopes.isEmpty();
    }
}

