/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractRandomStabilityCheck;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.5.36")
@CheckID(value="SVTB.15.7.2")
@CheckName(value="SVTB.15.7.2")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.FORK, RuleLabel.RANDOM_STABILITY})
@CheckTitle(value="Do not use fork without get_randstate()")
@CheckDescription(value="All functions that fork should not break random stability as it may lead to unexpected behavior or inconsistencies.\n\nTo preserve random stability use 'randstate' guards:\n   process p = process::self();\n   string p_rand;\n   if(p!=null) p_rand = p.get_randstate();\n   // fork join here ...\n   if(p!=null) p.set_randstate(p_rand);\n\nImplementation Notes:\nThis rule flags all functions that fork, but don't call get_randstate(). It doesn't fully check the above guard.\nIt goes recursively, foo() calling moo() that forks without randstate() is also flagged.\nbase.boo() calling virtual derived.foo() overridden with fork does not flag the derived.boo() -> derived.foo() stack:\n class base;\n    function void boo();\n    endfunction\n\n    virtual function void foo();\n    endfunction\n endclass\n\n class derived;\n    virtual function void foo(); // this is flagged if random unstable, but the derived.boo() side effect is not signaled\n    // fork here...\n    endfunction\n endclass")
@CheckReapplyDisable
public class Check_SVTB_15_7_2
extends AbstractRandomStabilityCheck {
    public Check_SVTB_15_7_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
    }

    @Override
    protected Object isFunctionOrActionBlockUnstable(RfNamedElement function, List<RfFunctionCall> functionCalls) {
        if (function instanceof RfFunction) {
            return this.getForkBlockInFunction((RfFunction)function);
        }
        return null;
    }

    private RfActionBlock getForkBlockInFunction(RfFunction function) {
        return this.getForkBlockInActionBlocks(function.getLocalMembers(RfActionBlock.class));
    }

    private RfActionBlock getForkBlockInActionBlocks(List<RfActionBlock> actionBlocks) {
        if (actionBlocks == null) {
            return null;
        }
        for (RfActionBlock actionBlock : actionBlocks) {
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN)) {
                return actionBlock;
            }
            RfActionBlock forkBlock = this.getForkBlockInActionBlocks(actionBlock.getLocalMembers(RfActionBlock.class));
            if (forkBlock == null) continue;
            return forkBlock;
        }
        return null;
    }

    @Override
    protected String getUnstableCause(RfNamedElement function, boolean verbose) {
        ParserPath neParserPath;
        RfActionBlock forkBlock;
        RfFileDef neFile;
        if (function == null) {
            return "";
        }
        Object unstableCause = this.unstableCauses.get(function.getFullName());
        if (unstableCause instanceof RfFunctionCall) {
            RfFunctionCall newCall = (RfFunctionCall)unstableCause;
            return this.addLineFileInfo(newCall, verbose ? "calls " + this.link(newCall) + "() " : "");
        }
        if (unstableCause instanceof RfActionBlock && (neFile = (forkBlock = (RfActionBlock)unstableCause).getFile()) != null && (neParserPath = neFile.getParserPath()) != null) {
            return this.addLineFileInfo(forkBlock, "uses unguarded fork ");
        }
        return "";
    }

    @Override
    protected boolean checkIfValidHit(RfNamedElement elm, Set<RfActionBlock> startingScopes) {
        return startingScopes == null || startingScopes.isEmpty();
    }
}

