/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="16.1.19")
@CheckID(value="SVTB.15.8.1")
@CheckName(value="SVTB.15.8.1")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.NAME, RuleLabel.VERIFICATION, RuleLabel.SHADOWING})
@CheckTitle(value="Avoid name shadowing in randomize() with {...}")
@CheckDescription(value="Identifiers used in randomize() with {...} should be qualified if an identifier with the same name is visible in the scope where randomize() with '{'...'}' is called.\n\nclass trans_c;\n    rand int length;\nendclass\nclass test;\n    function foo();\n        int length = 3;\n        trans_c trans = new();\n        trans.randomize() with {\n            trans.length == local::length // ALLOWED \n            length == local::length // NOT ALLOWED / ALLOWED when allowIfLocalQualified is set\n            trans.length == length  // NOT ALLOWED \n        };\n    endfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_15_8_1
extends OVMComplianceCheck {
    private static final Set<HidFlatteningOption> VARIABLE_SELECT_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS);
    @CheckParameter(defaultValue="false", description="When true, allow unqualified identifiers when at least one identifier with the same name is qualified using local in the same constraint expression.", name="allowIfLocalQualified", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowIfLocalQualifiedValue;

    public Check_SVTB_15_8_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfHidVisitor visitor = new RfHidVisitor(){
            private Set<RfNamedElement> visitedCalls = new HashSet<RfNamedElement>();
            private ParserPath callParserPath;

            @Override
            public void setHolder(IHidHolder holder) {
                super.setHolder(holder);
                if (!(((HidHolder)holder).getScope() instanceof RfNamedElement)) {
                    return;
                }
                RfNamedElement currentScope = (RfNamedElement)((HidHolder)holder).getScope();
                if (Check_SVTB_15_8_1.this.fOVMProject.isOVMElement(currentScope)) {
                    return;
                }
                if (this.visitedCalls.contains(currentScope)) {
                    return;
                }
                Check_SVTB_15_8_1.this.notifyCheckAlive();
                RfDefElement declaration = currentScope.getDeclaration();
                if (declaration != null && Check_SVTB_15_8_1.this.checkPreWaivers(declaration.getParserPath())) {
                    return;
                }
                List<RfFunctionCall> functionCalls = currentScope.getFunctionCallsWithPrefix("", 2);
                for (RfFunctionCall functionCall : functionCalls) {
                    if (!functionCall.hasWith()) continue;
                    this.visitedCalls.add(functionCall);
                    this.callParserPath = functionCall.getDeclaration().getParserPath();
                    this.processOperators(this.collectCompleteOperators(functionCall));
                }
            }

            private Collection<? extends IHidOperator> collectCompleteOperators(RfNamedElement element) {
                final ArrayList collected = new ArrayList();
                element.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

                    public boolean visit(HidOperator operator) {
                        IHidObject lhSide;
                        if ((operator.isWithClauseConstraint() || operator.isWithClause()) && (lhSide = operator.getLHValue()) instanceof IHidOperator) {
                            IHidOperator constraintOperator = (IHidOperator)lhSide;
                            if (constraintOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                                for (IHidObject intern : constraintOperator.getRHValues()) {
                                    if (!(intern instanceof IHidOperator)) continue;
                                    collected.add((IHidOperator)intern);
                                }
                            } else {
                                collected.add(constraintOperator);
                            }
                        }
                        return true;
                    }
                });
                return collected;
            }

            private void processOperators(Collection<? extends IHidOperator> operators) {
                for (IHidOperator iHidOperator : operators) {
                    this.processOperator(iHidOperator);
                }
            }

            private void processOperator(IHidOperator op) {
                Set hids = HidUtils.flattenToHids((IHidObject)op, VARIABLE_SELECT_FLATTENING);
                HashSet<String> savedByLocalAccess = new HashSet<String>();
                HashMap<RfHid, List<RfNamedElement>> hitHidsWithIdentifier = new HashMap<RfHid, List<RfNamedElement>>();
                for (IHid hid : hids) {
                    List<RfNamedElement> list;
                    if (!(hid instanceof RfHid) || (list = this.checkHid((RfHid)hid, savedByLocalAccess)) == null) continue;
                    hitHidsWithIdentifier.put((RfHid)hid, list);
                }
                Set hitHids = hitHidsWithIdentifier.keySet();
                for (RfHid hid : hitHids) {
                    String message;
                    if (Check_SVTB_15_8_1.this.pAllowIfLocalQualifiedValue && savedByLocalAccess.contains(hid.getName())) continue;
                    List list = (List)hitHidsWithIdentifier.get((Object)hid);
                    if (list.size() == 1) {
                        RfNamedElement shadow = (RfNamedElement)list.get(0);
                        message = String.valueOf(Check_SVTB_15_8_1.this.addLineFileInfo((RfNamedElement)hid.getElement(), "Class member '" + hid.getName() + "' declared ")) + Check_SVTB_15_8_1.this.addLineFileInfo(shadow, " is shadowed by the variable:\n" + LintUtils.getElementKind(shadow) + " '" + LintUtils.getNamedElementFullName(shadow) + "' declared ") + "!";
                    } else {
                        RfNamedElement access = (RfNamedElement)list.get(0);
                        RfNamedElement shadow = (RfNamedElement)list.get(1);
                        message = String.valueOf(Check_SVTB_15_8_1.this.addLineFileInfo(access, "Class member '" + hid.getName() + "' accessed through\n" + LintUtils.getElementKind(access) + " '" + LintUtils.getNamedElementFullName(access) + "' declared ")) + Check_SVTB_15_8_1.this.addLineFileInfo(shadow, " is shadowed by the variable:\n" + LintUtils.getElementKind(shadow) + " '" + LintUtils.getNamedElementFullName(shadow) + "' declared ") + "!";
                    }
                    this.addHitForHid(hid, message, op.getOccurrence().getLine());
                }
            }

            public List<RfNamedElement> checkHid(RfHid hid, Set<String> savedByLocalAccess) {
                HidAccess parentAccess;
                IRfNamedElement secondaryScope = hid.getSecondaryScope();
                if (secondaryScope != null) {
                    secondaryScope = (IRfNamedElement)secondaryScope.getEnclosingScope(RfFunctionCall.class);
                }
                if (!(secondaryScope instanceof RfFunctionCall) || !((RfFunctionCall)secondaryScope).hasWith()) {
                    return null;
                }
                RfHid fieldHid = hid;
                while (fieldHid != null && (parentAccess = fieldHid.getParentAccess()) != null && parentAccess.getAccessKind() != 3) {
                    fieldHid = parentAccess.getParentHid();
                }
                if (fieldHid == null) {
                    return null;
                }
                if ("local".equals(fieldHid.getName())) {
                    savedByLocalAccess.add(hid.getName());
                    return null;
                }
                IRfScopeElement enclosingScope = secondaryScope.getEnclosingScope();
                if (!(enclosingScope instanceof RfNamedElement)) {
                    return null;
                }
                IRfNamedElement candidate = ((RfNamedElement)enclosingScope).semanticGetMember(fieldHid.getName(), (IHid)fieldHid, this.parserPath, null, null, true, fieldHid != hid, false);
                if (!(candidate instanceof RfField)) {
                    return null;
                }
                IRfNamedElement hitElement = fieldHid.getElement();
                if (hitElement == null) {
                    return null;
                }
                RfNamedElement candidateEnclosingScope = (RfNamedElement)candidate.getEnclosingScope();
                if (!candidateEnclosingScope.equals(hitElement.getEnclosingScope())) {
                    LinkedList<RfNamedElement> result = new LinkedList<RfNamedElement>();
                    if (!hid.equals((Object)fieldHid) && fieldHid.getElement() instanceof RfNamedElement) {
                        result.add((RfNamedElement)fieldHid.getElement());
                    }
                    result.add((RfNamedElement)candidate);
                    return result;
                }
                return null;
            }

            private void addHitForHid(RfHid hid, String message, int line) {
                HidOccurrence hidOccurrence = hid.getOccurrence();
                if (hidOccurrence != null && line == hidOccurrence.getLine()) {
                    Check_SVTB_15_8_1.this.addHit(this.callParserPath, hidOccurrence.getLine(), message, null, false);
                }
            }

            public boolean visit(RfHid hidObject) {
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

