/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="20.1.24")
@CheckID(value="SVTB.15.9")
@CheckName(value="SVTB.15.9")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.CONSTRAINT, RuleLabel.METHOD, RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.FUNCTIONAL, RuleLabel.VERIFICATION})
@CheckTitle(value="In constraints do not call methods that use class fields")
@CheckDescription(value="This check flags in constraints only the method calls that use class fields in their implementation.\nAccording to the System Verilog standard functions in constraints shall be called before constraints are solved, the return values of such functions is treated as state variables.\n\nExamples:\nclass A;\n\trand int a, b;\n\tconstraint c1 { a == 10; b == get(a) };  // not allowed\n\n\tfunction int get(int x)\n\t\tx = a;\n\t\treturn x;\n\tendfunction\nendclass\n")
public class Check_SVTB_15_9
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="When true, methods calls are allowed in constraints if only non-random fields are used in that method.", name="allowNonRandFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private Boolean pAllowNonRandFields;

    public Check_SVTB_15_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllNonXVMClasses()) {
            List<RfConstraint> constraints = rfNamedElement.getConstraintsWithPrefix("", 2, 2);
            if (constraints == null || constraints.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfConstraint rfConstraint : constraints) {
                rfConstraint.visitHidObject(this.fOVMProject.getRfProject(), new CheckMethodCalls(new HashSet<RfFunction>(), null));
            }
        }
    }

    private final class CheckMethodCalls
    implements IHidVisitor<RfHid> {
        protected List<RfField> classFields = null;
        private ParserPath parserPath;
        private Set<RfFunction> visitedFunctions;
        private RfFunction function;
        public boolean foundChange = false;

        public CheckMethodCalls(Set<RfFunction> visitedFunctions, RfFunction function) {
            this.visitedFunctions = visitedFunctions;
            this.function = function;
            this.foundChange = false;
            if (function != null && function.getEnclosingScope() instanceof RfClass) {
                this.classFields = function.getEnclosingScope().getFields();
            }
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject.isMethodCall(false)) {
                IRfNamedElement element = hidObject.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                if (this.function != null) {
                    this.visitedFunctions.add(this.function);
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
                for (MethodCall methodCall : methodCalls) {
                    if (methodCall.method == null) continue;
                    if (this.visitedFunctions.contains(methodCall.method)) {
                        return true;
                    }
                    CheckMethodCalls methodCallsVisitor = new CheckMethodCalls(this.visitedFunctions, (RfFunction)methodCall.method);
                    methodCall.method.visitHidObject((IRfSingleLangProject)Check_SVTB_15_9.this.fOVMProject.getRfProject(), (IHidVisitor)methodCallsVisitor);
                    if (this.function == null && methodCallsVisitor.foundChange) {
                        Check_SVTB_15_9.this.addHit(this.parserPath, hidObject.getOccurrence(), "Function " + methodCall.getMethodName() + " is called from a constrain block and uses class fields in the implementation!");
                        return true;
                    }
                    if (!methodCallsVisitor.foundChange) continue;
                    this.foundChange = true;
                    return false;
                }
            }
            if (this.function == null) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfField)) {
                return true;
            }
            if (this.classFields == null || this.classFields.isEmpty()) {
                return true;
            }
            if (Check_SVTB_15_9.this.pAllowNonRandFields.booleanValue() && !((RfField)hidObject.getElement()).isRand()) {
                return true;
            }
            if (this.classFields.contains(hidObject.getElement())) {
                this.foundChange = true;
                return false;
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

