/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="16.1.29")
@CheckID(value="SVTB.16.10")
@CheckName(value="SVTB.16.10")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERPOINT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use anonymous coverpoints/covercrosses")
@CheckDescription(value="Do not use anonymous coverpoints/covercrosses\n\nExamples:\ncoverpoint cp1; // not allowed\nnamed_cp : coverpoint cp2; // allowed\n\ncross c1; // not allowed\nnamed_cr cross c2; // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_16_10
extends OVMComplianceCheck {
    public Check_SVTB_16_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement covergroup : this.fOVMProject.getAllCovergroups()) {
            List<RfCoverpoint> coverpoints;
            if (this.checkPreWaivers(covergroup.getFile()) || (coverpoints = covergroup.getCoverpointsWithPrefix("", 2, 1)) == null || coverpoints.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfCoverpoint coverpoint : coverpoints) {
                if (!coverpoint.isAnonymous()) continue;
                this.addHit(coverpoint, "Anonymous " + (coverpoint instanceof RfCovercross ? "covercross" : "coverpoint") + " used!");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

