/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="17.1.24")
@CheckID(value="SVTB.16.11")
@CheckName(value="SVTB.16.11")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.OPTION, RuleLabel.COVERGROUP, RuleLabel.COVERPOINT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not set option.weight or option.goal of a covergroup, coverpoint or covercross")
@CheckDescription(value="There are two potential problems: firstly, the methodological problem that giving a greater or lesser weight to certain states might distort the coverage reporting, and secondly the practical problem that these options are not implemented consistently across simulators.\n\nExamples:\ncovergroup cg1;\n\toption.goal = 200;  // not allowed\n\toption.weight = 2;  // not allowed\nendgroup\n")
public class Check_SVTB_16_11
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, setting option.weight of a coverpoint to zero is allowed.", name="allowWeightZeroForCoverpoints", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowWeightZeroForCoverpoints;

    public Check_SVTB_16_11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_PATTERN_VALUE}){

            public boolean visit(HidOperator operator) {
                Number number;
                if (!operator.isAssignment()) {
                    return true;
                }
                IHidObject lhValue = operator.getLHValue();
                if (lhValue == null) {
                    return true;
                }
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                Check_SVTB_16_11.this.notifyCheckAlive();
                RfHid leftValue = (RfHid)operator.getLHValue();
                if (!leftValue.getName().equals("goal") && !leftValue.getName().equals("weight")) {
                    return true;
                }
                Hid parentHid = leftValue.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                if (!parentHid.getName().equals("option")) {
                    return true;
                }
                IRfNamedElement element = parentHid.getElement();
                if (element == null) {
                    return true;
                }
                IRfScopeElement enclosingScope = element.getEnclosingScope();
                if (!(enclosingScope instanceof RfCovergroup) && !(enclosingScope instanceof RfCoverpoint)) {
                    return true;
                }
                if (Check_SVTB_16_11.this.pAllowWeightZeroForCoverpoints && leftValue.getName().equals("weight") && enclosingScope instanceof RfCoverpoint && operator.getFirstRHValue() instanceof RfHidImplicit && (number = ((RfHidImplicit)operator.getFirstRHValue()).parseNumberValue()) != null && number.intValue() == 0) {
                    return true;
                }
                Check_SVTB_16_11.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "option.goal or option.weight is set for " + LintUtils.getElementKind((RfNamedElement)enclosingScope) + " '" + LintUtils.getNamedElementFullName((RfNamedElement)enclosingScope) + "'!");
                return true;
            }
        });
    }
}

