/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="18.1.21")
@CheckID(value="SVTB.16.12")
@CheckName(value="SVTB.16.12")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERPOINT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use implicit coverpoints")
@CheckDescription(value="Do not use implicit coverpoints.\nExample:\nbit a, b;\ncovergroup ccov @(posedge clk);\n  a_b : cross a, b; // not allowed\nendgroup\n\nCheck supports pre-waiving.")
public class Check_SVTB_16_12
extends OVMComplianceCheck {
    public Check_SVTB_16_12(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement covergroup : this.fOVMProject.getAllCovergroups()) {
            List<RfCoverpoint> coverpoints;
            if (this.checkPreWaivers(covergroup.getFile()) || (coverpoints = covergroup.getCoverpointsWithPrefix("", 2, 1)) == null || coverpoints.isEmpty()) continue;
            this.notifyCheckAlive();
            Set localCoverpointsNames = coverpoints.stream().filter(cp -> !cp.isPredefined() && !(cp instanceof RfCovercross)).map(cp -> cp.getName()).collect(Collectors.toSet());
            for (RfCoverpoint coverpoint : coverpoints) {
                RfCovercross covercross;
                IHidObject expr;
                if (!(coverpoint instanceof RfCovercross) || (expr = (covercross = (RfCovercross)coverpoint).getExpression()) == null) continue;
                Set flattenToHids = HidUtils.flattenToHids((IHidObject)expr, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_METHOD_CALLS));
                for (IHid crossItemHid : flattenToHids) {
                    IRfNamedElement crossItem;
                    if (!HidUtils.isHid((IHidObject)crossItemHid) || (crossItem = ((RfHid)crossItemHid).getElement()) == null || crossItem instanceof RfCoverpoint || localCoverpointsNames.contains(crossItem.getName())) continue;
                    this.addHit(covercross, "Implicit coverpoint '" + LintUtils.getNamedElementFullName((RfNamedElement)crossItem) + "' used in covercross '" + LintUtils.getNamedElementFullName(covercross) + "'!");
                }
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

