/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="20.1.27")
@CheckID(value="SVTB.16.13")
@CheckName(value="SVTB.16.13")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERGROUP, RuleLabel.ARRAY, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not declare embedded covergroup arrays")
@CheckDescription(value="Do not declare embedded covergroup arrays.\nExample:\nclass T;\ncovergroup covergroup_name @ covergroup_event;\nendgroup\n\nfunction foo();\n\tcovergroup_name cg[4]; // not allowed\nendfunction\nendclass")
public class Check_SVTB_16_13
extends OVMComplianceCheck {
    public Check_SVTB_16_13(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        IRfNamedElementVisitor cgVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (namedElement instanceof RfField) {
                    IRfNamedElement listType;
                    RfField field = (RfField)namedElement;
                    if (field.isTypeParameter()) {
                        return true;
                    }
                    Check_SVTB_16_13.this.notifyCheckAlive();
                    IRfNamedElement fieldType = field.getAssociatedType();
                    while (fieldType instanceof RfTypeAlias) {
                        fieldType = ((RfTypeAlias)fieldType).getAssociatedType();
                    }
                    if (fieldType instanceof RfListType && ((RfListType)fieldType).getAssociatedType() instanceof RfCovergroup && ((RfCovergroup)(listType = ((RfListType)fieldType).getAssociatedType())).getEnclosingScope() instanceof RfClass) {
                        Check_SVTB_16_13.this.addHit(namedElement, "Array of type " + LintUtils.getNamedElementFullName((RfNamedElement)listType) + " declared!");
                    }
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().accept(cgVisitor);
    }
}

