/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SDataType;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.16.1.3")
@CheckName(value="SVTB.16.1.3")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERPOINT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not auto_bin coverage points")
@CheckDescription(value="Always define and name bins. Coverpoint autobinning creates strangely named coverage points.\n\nIf you are defining a coverage group for a vector or integer type - then specify bins as a set of desirable value ranges.\nFor values: be sure to cover minimum, maximum, along with any key intermediate ranges.For values used for mode selection: cover each mode value.\nAutobinning creates coverage data not information. When a bin is named you know what is/isn't covered directly by reading the report.Autobinning is a lazy way to break a set (of numbers) down into manageable subsets.\nTake for example an autobinned register. What does it mean when auto[10] is covered? A named set of bins provides information.You can immediately see that the register was configured for mode ABCD when you read the report.\nAutobinning moves the 'work' from the coverage bin generation to the report analysis.When the work is done up-front by naming the bins there is little effort required to analyze the resulting coverage report.\n\nNot Allowed:\n   coverpoint pixel_offset;// no bins specified - autobins w/bins named 'auto'\nAllowed:\n   offset: coverpoint pixel_offset {\n      bins low = { [0:20] }; // name ranges that you care about\n      bins address[] = { [0:$] }; // not as clear - but allowed named bin array - allowed because address is directly mapped to the binned value\n   }\n\nCheck supports pre-waiving.")
public class Check_SVTB_16_1_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="bit, enum", description="Comma separated list of allowed autobin types.", name="allowedAutobinTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedAutobinTypes;
    private static final String OPEN_PACKED_DIMENSION = "[";
    private static final String CLOSED_PACKED_DIMENSION = "]";
    private static final String COLON = ":";

    public Check_SVTB_16_1_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfCoverpoint) || namedElement instanceof RfCovercross) {
                    return true;
                }
                if (Check_SVTB_16_1_3.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                this.checkCoverpoint((RfCoverpoint)namedElement);
                return true;
            }

            private void checkCoverpoint(RfCoverpoint coverpoint) {
                Check_SVTB_16_1_3.this.notifyCheckAlive();
                CoverpointVisitor visitor = new CoverpointVisitor();
                coverpoint.visitHidObject(null, visitor);
                boolean isSkippable = visitor.getIsSkippableCoverpoint();
                if (!isSkippable) {
                    Check_SVTB_16_1_3.this.addHit(coverpoint, this.getMessage(coverpoint));
                }
            }

            private String getMessage(RfCoverpoint coverpoint) {
                String name = coverpoint.getFullName();
                if (name == null || name.isEmpty()) {
                    return "Coverpoint doesn't have user-defined bins!";
                }
                return "Coverpoint '" + name + "' doesn't have user-defined bins!";
            }
        });
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private class CoverpointVisitor
    implements IHidVisitor<RfHidOperator> {
        private static final String STRING = "string";
        private static final String INT = "int";
        private static final String STRUCT = "struct";
        private static final String UNION = "union";
        private static final String ENUM = "enum";
        private boolean isSkippableCoverpoint = false;
        private IRfNamedElement scope;
        private ParserPath parserPath;

        private CoverpointVisitor() {
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean getIsSkippableCoverpoint() {
            return this.isSkippableCoverpoint;
        }

        public boolean visit(RfHidOperator operator) {
            if (this.isBins(operator) || this.isAllowedCoverpointType(operator)) {
                this.isSkippableCoverpoint = true;
            }
            return !this.isSkippableCoverpoint;
        }

        private boolean isBins(RfHidOperator operator) {
            return operator.isBins() || operator.isIgnoreBins() || operator.isIllegalBins();
        }

        private boolean isAllowedCoverpointType(RfHidOperator operator) {
            if (!operator.isCoverpointExpression()) {
                return false;
            }
            IHidObject lhValue = operator.getLHValue();
            String name = this.getTypeName(lhValue);
            return this.isAllowedType(name);
        }

        private boolean isAllowedType(String name) {
            return name != null && !name.isEmpty() && Check_SVTB_16_1_3.this.pAllowedAutobinTypes.contains(name);
        }

        private String getTypeName(IHidObject iHidObject) {
            if (iHidObject == null) {
                return null;
            }
            IHidObject.HidKind hidKind = iHidObject.getHidKind();
            switch (hidKind) {
                case HID: {
                    return this.getTypeFromHid((RfHid)iHidObject);
                }
                case IMPLICIT: {
                    return this.getTypeFromImplicit((RfHidImplicit)iHidObject);
                }
                case ACCESS: {
                    return this.getTypeFromAccess((RfHidAccess)iHidObject);
                }
                case OPERATOR: {
                    return this.getTypeFromOperator((RfHidOperator)iHidObject);
                }
            }
            return null;
        }

        private String getTypeFromOperator(RfHidOperator operator) {
            if (operator.isIffExpression()) {
                return this.getTypeName(operator.getLHValue());
            }
            IRfNamedElement type = null;
            ISDataAbstract resolvedType = operator.getOperatorResolvedType();
            if (resolvedType instanceof SDataVariable) {
                SDataVariable dataVariable = (SDataVariable)resolvedType;
                type = dataVariable.type.getType();
            } else if (resolvedType instanceof SDataType) {
                SDataType dataType = (SDataType)resolvedType;
                type = dataType.getType();
            }
            return this.getNameFromType(type);
        }

        private String getTypeFromAccess(RfHidAccess access) {
            access = access.upwardsCopy(false);
            RfHid hid = (RfHid)access.getParentHid().getAncestorHid();
            hid.resolve(new ConfigInfo(false, Check_SVTB_16_1_3.this.fOVMProject.getRfProject(), null, true, null), (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), this.scope, this.scope, this.parserPath, RfTypesResolver.create((IRfScopeElement)this.scope, Check_SVTB_16_1_3.this.fOVMProject.getRfProject(), 14), null, (byte)3, true, false, false);
            IRfNamedElement associatedType = access.getAssociatedType();
            return this.getNameFromType(associatedType);
        }

        private String getTypeFromImplicit(RfHidImplicit hidImplicit) {
            if (hidImplicit.isNumber()) {
                return INT;
            }
            if (hidImplicit.isStringLiteral()) {
                return STRING;
            }
            return null;
        }

        private String getTypeFromHid(RfHid hid) {
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                return null;
            }
            if (!(element instanceof RfField)) {
                return null;
            }
            RfField field = (RfField)element;
            IRfNamedElement type = field.getResolvedType(true);
            return this.getNameFromType(type);
        }

        private String getNameFromType(IRfNamedElement type) {
            RfField field;
            if (type == null) {
                return null;
            }
            if (type instanceof RfTypeAlias) {
                RfTypeAlias typeAlias = (RfTypeAlias)type;
                DataType dataType = typeAlias.getTranslatedDataType();
                if (dataType == null) {
                    return null;
                }
                String typeAsString = dataType.getType();
                String packedDimensionString = dataType.getPackedDimensionString();
                if (packedDimensionString != null) {
                    typeAsString = String.valueOf(typeAsString) + packedDimensionString;
                }
                if (typeAsString.startsWith(ENUM)) {
                    return ENUM;
                }
                if (typeAsString.startsWith(STRUCT)) {
                    return STRUCT;
                }
                if (typeAsString.startsWith(UNION)) {
                    return UNION;
                }
                return this.getTypeFromPackedDimension(typeAsString);
            }
            if (type instanceof RfStruct) {
                RfStruct struct = (RfStruct)type;
                if (struct.isEnum()) {
                    return ENUM;
                }
                if (struct.isUnion()) {
                    return UNION;
                }
                return STRUCT;
            }
            if (type instanceof RfField && (type = (field = (RfField)type).getResolvedType(true)) instanceof RfTypeAlias) {
                return this.getNameFromType(type);
            }
            if (type instanceof RfBitVectorScalarType) {
                type = ((RfBitVectorScalarType)type).getScalarWithDefaultSign();
            }
            return this.getTypeFromPackedDimension(type.getName());
        }

        private String getTypeFromPackedDimension(String type) {
            if (type == null) {
                return null;
            }
            if (!type.contains(Check_SVTB_16_1_3.OPEN_PACKED_DIMENSION) || !type.contains(Check_SVTB_16_1_3.CLOSED_PACKED_DIMENSION)) {
                return type;
            }
            int open = type.indexOf(Check_SVTB_16_1_3.OPEN_PACKED_DIMENSION);
            int close = type.indexOf(Check_SVTB_16_1_3.CLOSED_PACKED_DIMENSION);
            String packedDimension = type.substring(open + 1, close);
            String typeName = type.substring(0, open);
            int indexOfSplit = packedDimension.indexOf(Check_SVTB_16_1_3.COLON);
            if (packedDimension.length() < 2 || indexOfSplit == -1) {
                return typeName.isEmpty() ? null : typeName;
            }
            String first = packedDimension.substring(0, indexOfSplit);
            String second = packedDimension.substring(indexOfSplit + 1);
            return this.removeSpaces(first).equals(this.removeSpaces(second)) ? typeName : null;
        }

        private String removeSpaces(String s) {
            return s.replaceAll(" ", "");
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

