/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.16.1.5")
@CheckName(value="SVTB.16.1.5")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERPOINT, RuleLabel.VERIFICATION})
@CheckTitle(value="Coverpoint of bit vector cannot be larger than 32 bits")
@CheckDescription(value="Example:\nbit[63:0] v_b;\ncovergroup yg @(posedge clk);\n  coverpoint v_b; // Not Allowed\nendgroup: yg\n\nCheck supports pre-waiving.")
public class Check_SVTB_16_1_5
extends OVMComplianceCheck {
    public Check_SVTB_16_1_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement covergroup : this.fOVMProject.getAllCovergroups()) {
            RfDefElement declaration = covergroup.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<RfCoverpoint> allCoverpoints = covergroup.getCoverpointsWithPrefix("", 2, 1);
            if (allCoverpoints == null || allCoverpoints.isEmpty()) continue;
            for (RfCoverpoint coverpoint : allCoverpoints) {
                CoverpointVisitor visitor = new CoverpointVisitor(null);
                coverpoint.visitHidObject(null, (IHidVisitor<?>)visitor);
                for (IHidObject hidObject : visitor.getHidObjects()) {
                    int size;
                    DVTNumber numberForSize;
                    RfNamedElement element = null;
                    if (hidObject instanceof RfHid) {
                        elementHid = (RfHid)hidObject;
                        element = (RfNamedElement)elementHid.getElement();
                    } else if (hidObject instanceof RfHidAccess) {
                        elementHid = (RfHidAccess)hidObject;
                        element = (RfNamedElement)elementHid.getParentHid().getElement();
                    }
                    if (element == null || !(element instanceof RfField)) continue;
                    RfAssociatedType assocType = (RfField)element;
                    IRfNamedElement elemType = null;
                    while (assocType != null) {
                        elemType = assocType.getAssociatedType();
                        if (elemType == null || !(elemType instanceof RfTypeAlias)) break;
                        assocType = (RfAssociatedType)elemType;
                    }
                    if (elemType == null || !(elemType instanceof RfListType)) continue;
                    ELManager elManager = this.fOVMProject.getRfProject().getELManager();
                    ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(elManager);
                    IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)element, null, (boolean)true, (ELManager)elManager);
                    guardian.updateElements((IRfNamedElement)element, (IRfNamedElement)covergroup);
                    ELParamValueScope paramValueForSize = ELUtils.evaluateForSize((IHidObject)hidObject, (IHidEvaluator)evaluator, (IRfNamedElement)element, (IHidEvaluationGuardian)guardian);
                    if (ELUtils.isUnsuccessfulEval((ELParamValueScope)paramValueForSize) || !((numberForSize = paramValueForSize.getDVTNumber()) instanceof VlogBitVector) || (size = numberForSize.getSize()) <= 32) continue;
                    this.addHit(coverpoint, "Variable '" + element.getName() + "' used in a coverpoint is greater than 32 bits");
                }
            }
        }
    }

    private static class CoverpointVisitor
    extends HidOperatorVisitor {
        private Set<IHidObject> hidObjects = new HashSet<IHidObject>();

        public CoverpointVisitor(HidOperatorQualifier[] qualifiers) {
            super(qualifiers);
        }

        public boolean visit(HidOperator op) {
            if (!this.hidObjects.isEmpty()) {
                return false;
            }
            if (!(op instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator operator = (RfHidOperator)op;
            if (!operator.isCoverpointExpression()) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            return this.visitOperator(lhValue);
        }

        private boolean visitOperator(IHidObject hidObj) {
            if (hidObj instanceof RfHidOperator) {
                RfHidOperator op = (RfHidOperator)hidObj;
                boolean result = this.visitOperator(op.getLHValue());
                if (op.isIffExpression()) {
                    return result;
                }
                if (op.getRHValues() == null) {
                    return result;
                }
                for (IHidObject rhValue : op.getRHValues()) {
                    result &= this.visitOperator(rhValue);
                }
                return result;
            }
            if (hidObj instanceof RfHid || hidObj instanceof RfHidAccess) {
                this.hidObjects.add(hidObj);
                return false;
            }
            return true;
        }

        public Set<IHidObject> getHidObjects() {
            return this.hidObjects;
        }
    }
}

