/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.16.1.6")
@CheckName(value="SVTB.16.1.6")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.RANGE, RuleLabel.VERIFICATION})
@CheckTitle(value="Bins ranges must be [low:high]")
@CheckDescription(value="A range with first value larger than second is empty (LRM 11.4.13).\n\nImplementation Notes:\nLinter only checks constant ranges. It doesn't evaluate expressions.\n\nExamples:\ncovergroup cg1;\n\tcoverpoint m_address {\n\t\tbins m_address1 = {[0:10]}; // allowed\n\t\tbins m_address2 = {[100:0]}; // not allowed\n\t}\nendgroup;\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_16_1_6
extends AbstractSVTBSimpleIssues {
    public Check_SVTB_16_1_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(125);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Wrong [high:low] range in bins specification!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(125);
        Set<ParserPath> keySet = allIssues.keySet();
        for (ParserPath filename : keySet) {
            List<SVTBIssues> issues;
            RfFileDef filedef;
            if (this.checkPreWaivers(filename) || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(filename)) == null || (issues = allIssues.get(filename)) == null || issues.isEmpty()) continue;
            this.notifyCheckAlive();
            ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
            for (SVTBIssues issue : issues) {
                if (!this.isWrongSize(issue.getInfo(), issue.getAdditionalInfo())) continue;
                filteredList.add(issue);
            }
            filteredMap.put(filename, filteredList);
        }
        return filteredMap;
    }

    protected boolean isWrongSize(String range1, String range2) {
        int x2;
        int x1;
        if (range1 == null || range2 == null) {
            return false;
        }
        try {
            x1 = Integer.parseInt(range1);
            x2 = Integer.parseInt(range2);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return x1 > x2;
    }
}

