/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;

@CheckVersion(value="17.1.25")
@CheckID(value="SVTB.16.4")
@CheckName(value="SVTB.16.4")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERPOINT, RuleLabel.COVERGROUP, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use illegal_bins")
@CheckDescription(value="When designing coverpoints, specify any illegal values or values to be excluded for coverage as ignore_bins. Do not use illegal_bins.\nCovergroups should be confined to collecting functional coverage information and not linked directly to error reporting. Illegal values should be trapped either using assertions or using the UVM report handler.\n\nExamples:\ncovergroup cg1;\n\tcoverpoint cp {\n\t\tillegal_bins bad = {10, 11, 12}; // not allowed\n\t\tbins good = {1, 2, 3}; // not allowed\n\t}\nendgroup;\n\nCheck supports pre-waiving.")
public class Check_SVTB_16_4
extends OVMComplianceCheck {
    public Check_SVTB_16_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (final RfNamedElement covergroup : this.fOVMProject.getAllCovergroups()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(covergroup.getFile())) continue;
            covergroup.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

                public boolean visit(HidOperator operator) {
                    if (this.scope instanceof RfCoverpoint && operator instanceof IRfHidOperatorLayer && ((IRfHidOperatorLayer)operator).isIllegalBins()) {
                        IHidObject lhValue = operator.getLHValue();
                        Check_SVTB_16_4.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "illegal_bins" + (lhValue == null ? "" : " '" + lhValue.toString()) + "'" + " used in " + LintUtils.getElementKind((RfNamedElement)this.scope) + " '" + LintUtils.getNamedElementFullName(covergroup) + "." + LintUtils.getNamedElementFullName((RfNamedElement)this.scope) + "'!");
                    }
                    return true;
                }
            });
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

