/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleParamIssues;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.16.7.5")
@CheckName(value="SVTB.16.7.5")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.OPTION, RuleLabel.COVERGROUP, RuleLabel.VERIFICATION})
@CheckTitle(value="Set options in the body of the covergroup")
@CheckDescription(value="Options must be set in the body of the covergroup.\nDo not set options after the coverage group has been constructed.\nTo disable a coverpoint use iff (condition) and toggle the condition from outside the coverpoint instead of using cover_group.cover_point.option.weight = 0.\n  covergroup cg @(posedge clk);\n  \tcp: coverpoint a_var iff (condition);\n  endgroup\n\nExample:\nAllowed:\n  covergroup cg @(posedge clk);\n  \tcp1: coverpoint a_var {\n  \t\toption.weight = 100;\n  \t}\n  \tcp2b: coverpoint b_var;\n  endgroup\nNot allowed:\n  covergroup cg @(posedge clk);\n  cp1: coverpoint a_var;\n  cp2: coverpoint b_var;\n  endgroup\n  ...\n  cg g1 = new;\n  g1.cp1.option.weight = 100; //Not allowed\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_16_7_5
extends AbstractSVTBSimpleParamIssues {
    public Check_SVTB_16_7_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(33);
    }

    @Override
    protected String getFailMessage(String optionName) {
        return "'" + optionName + "' covergroup option is assigned from outside the covergroup";
    }

    protected ArrayList<String> getOptions() {
        return null;
    }

    protected String getOptionStructName() {
        return "struct/covergroup/option";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(33);
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
            List<SVTBIssues> issues;
            ParserPath fileName = entry.getKey();
            RfFileDef filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(fileName);
            if (filedef == null || this.checkPreWaivers(fileName) || (issues = entry.getValue()) == null || issues.isEmpty()) continue;
            LinkedList<SVTBIssues> filteredList = new LinkedList<SVTBIssues>();
            for (SVTBIssues issue : issues) {
                RfNamedElement destScopeScope;
                RfNamedElement destScope;
                String dest = issue.getInfo();
                if (dest == null || dest.length() == 0 || !dest.contains(".option.") && !dest.contains(".type_option.")) continue;
                this.notifyCheckAlive();
                RfDefElement defScope = filedef.getScope(issue.getOffset(), true);
                RfNamedElement scope = defScope.getNamedElement();
                RfNamedElement destination = LintUtils.getElementFromString(this.fOVMProject.getRfProject(), scope, issue.getOffset(), dest);
                if (destination == null || !(destination instanceof RfPredefinedField) || (destScope = destination.getEnclosingScope()) == null || !(destScope instanceof RfPredefinedStruct) || (destScopeScope = destScope.getEnclosingScope()) == null || !(destScopeScope instanceof RfCovergroup) && !(destScopeScope instanceof RfCoverpoint) || scope != null && (scope instanceof RfCovergroup || scope instanceof RfCoverpoint || scope instanceof RfCovercross)) continue;
                filteredList.add(issue);
            }
            if (filteredList.isEmpty()) continue;
            filteredMap.put(fileName, filteredList);
        }
        return filteredMap;
    }
}

