/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="17.1.24")
@CheckID(value="SVTB.16.9.2")
@CheckName(value="SVTB.16.9.2")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERGROUP, RuleLabel.EVENT_CONTROL, RuleLabel.VERIFICATION})
@CheckTitle(value="Sample covergroups using sample() instead of specifying a clocking event")
@CheckDescription(value="Covergroups must not specify a clocking event, sample() must be used instead. Calling sample() allows values to be sampled when and only when transactions arrive at the coverage collection component.\nThe rule checks that covergroups don't define a clocking event and if <allowUnsampledCovergroups> is set to false it will also fail for covergroups on which sample() is not called.\n\nCheck supports pre-waiving.")
public class Check_SVTB_16_9_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, it checks only the covergroups defined in classes.", name="checkOnlyClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlyClassesValue;
    @CheckParameter(defaultValue="true", description="When true, the check will not fail for covergroups on which sample() is never called.", name="allowUnsampledCovergroups", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowUnsampledCovergroupsValue;

    public Check_SVTB_16_9_2(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<RfCovergroup> covergroups = this.getCovergroups(this.pCheckOnlyClassesValue);
        Set sampledCovergroups = this.pAllowUnsampledCovergroupsValue ? Collections.emptySet() : this.getAllSampledCovergroups();
        for (RfCovergroup covergroup : covergroups) {
            if (covergroup.getEventName() != null && !covergroup.getEventName().isEmpty()) {
                this.addHit(covergroup, "'" + LintUtils.getNamedElementFullName(covergroup) + "' has a clocking event!");
            }
            if (this.pAllowUnsampledCovergroupsValue || sampledCovergroups.contains(covergroup)) continue;
            this.addHit(covergroup, "'" + LintUtils.getNamedElementFullName(covergroup) + "' doesn't call sample()!");
        }
    }

    public HashSet<RfCovergroup> getCovergroups(boolean onlyInClasses) {
        HashSet<RfCovergroup> covergroups = new HashSet<RfCovergroup>();
        for (RfNamedElement covergroup : this.fOVMProject.getAllCovergroups()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(covergroup.getFile()) || onlyInClasses && (!onlyInClasses || !(covergroup.getEnclosingScope() instanceof RfClass))) continue;
            covergroups.add((RfCovergroup)covergroup);
        }
        return covergroups;
    }

    public HashSet<RfCovergroup> getAllSampledCovergroups() {
        final HashSet<RfCovergroup> covergroups = new HashSet<RfCovergroup>();
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidObject>(){

            /*
             * WARNING - void declaration
             */
            public boolean visit(IHidObject hidObject) {
                RfCovergroup rfCovergroup;
                IRfNamedElement iRfNamedElement;
                Hid hid;
                HidAccess parentAccess;
                if (hidObject instanceof Hid && (parentAccess = (hid = (Hid)hidObject).getParentAccess()) != null && (iRfNamedElement = parentAccess.getAssociatedType()) instanceof RfCovergroup && (rfCovergroup = (RfCovergroup)iRfNamedElement) == (RfCovergroup)iRfNamedElement && "sample".equals(hid.getName())) {
                    void covergroup;
                    Check_SVTB_16_9_2.this.notifyCheckAlive();
                    covergroups.add(covergroup.getOriginal());
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
        return covergroups;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

