/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.3")
@CheckID(value="SVTB.16.9.3")
@CheckName(value="SVTB.16.9.3")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERGROUP, RuleLabel.EVENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Sample covergroups using sample() or @event")
@CheckDescription(value="Covergroups must not specify a signal, sample() or @event must be used instead. Calling sample() or triggering the @event allows values to be sampled when and only when transactions arrive at the coverage collection component.\n\nExamples:\nclass A;\n\tevent event1;\n\n\tcovergroup class_covergroup_with_event @event1; // allowed\n\t\toption.at_least = 0;\n\tendgroup\n\n\tcovergroup class_covergroup_without_event; // not allowed\n\t\toption.at_least = 0;\n\tendgroup\n\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_16_9_3
extends OVMComplianceCheck {
    public Check_SVTB_16_9_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfCovergroup[] allCovergroups = this.fOVMProject.getRfProject().getAllCovergroups();
        if (allCovergroups == null || allCovergroups.length == 0) {
            return;
        }
        SampleCallsVisitor sampleCallsVisitor = new SampleCallsVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, sampleCallsVisitor);
        Set<RfNamedElement> covergroupsWithSampleCalls = sampleCallsVisitor.getCovergroupsWithSampleCalls();
        RfCovergroup[] rfCovergroupArray = allCovergroups;
        int n = allCovergroups.length;
        int n2 = 0;
        while (n2 < n) {
            RfCovergroup covergroup = rfCovergroupArray[n2];
            if (!(covergroupsWithSampleCalls != null && covergroupsWithSampleCalls.contains(covergroup) || this.checkPreWaivers(covergroup.getFile()))) {
                EventsVisitor eventsVisitor = new EventsVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_CLOCKING_EVENT});
                covergroup.visitHidObject(null, (IHidVisitor<?>)eventsVisitor);
                if (!eventsVisitor.hasEvent()) {
                    this.addHit(covergroup, "'" + LintUtils.getNamedElementFullName(covergroup) + "' is not sampled using sample() or @event!");
                }
            }
            ++n2;
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private static class EventsVisitor
    extends HidOperatorVisitor {
        private boolean hasEvent = false;

        public EventsVisitor(HidOperatorQualifier[] qualifiers) {
            super(qualifiers);
        }

        public boolean visit(HidOperator operator) {
            if (!"@".equals(operator.getOperatorText())) {
                return true;
            }
            IHidObject leftValue = operator.getLHValue();
            if (!(leftValue instanceof RfHidOperator) && !(leftValue instanceof RfHid)) {
                return true;
            }
            EnumSet<HidFlatteningOption> hidFlatteningOPtions = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS);
            Set allHids = HidUtils.flattenToHids((IHidObject)leftValue, hidFlatteningOPtions);
            if (allHids == null) {
                return true;
            }
            for (IHid hid : allHids) {
                IRfNamedElement element;
                if (!(hid instanceof RfHid) || !((element = ((RfHid)hid).getElement()) instanceof RfField) || !((RfField)element).isEvent()) continue;
                this.hasEvent = true;
                return true;
            }
            return true;
        }

        public boolean hasEvent() {
            return this.hasEvent;
        }
    }

    private class SampleCallsVisitor
    implements IHidVisitor<IHidObject> {
        private Set<RfNamedElement> covergroupsWithSampleCalls = new HashSet<RfNamedElement>();

        /*
         * WARNING - void declaration
         */
        public boolean visit(IHidObject hidObject) {
            RfCovergroup rfCovergroup;
            IRfNamedElement iRfNamedElement;
            if (!(hidObject instanceof RfHid)) {
                return true;
            }
            Hid hid = (Hid)hidObject;
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess != null && (iRfNamedElement = parentAccess.getAssociatedType()) instanceof RfCovergroup && (rfCovergroup = (RfCovergroup)iRfNamedElement) == (RfCovergroup)iRfNamedElement && "sample".equals(hid.getName())) {
                void covergroup;
                this.covergroupsWithSampleCalls.add(covergroup.getOriginal());
            }
            return true;
        }

        public Set<RfNamedElement> getCovergroupsWithSampleCalls() {
            return this.covergroupsWithSampleCalls;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

