/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.18.2.3")
@CheckName(value="SVTB.18.2.3")
@CheckLabel(labels={RuleLabel.MACRO, RuleLabel.PARAMETER})
@CheckTitle(value="Do not define parameterized macros")
@CheckDescription(value="Creating parameterized macros (macros with arguments) is not required for general use.\nParameterized macros are not typechecked when they are used and generate difficult to debug compile errors when bad arguments are passed.\nMacros are expanded before any checking occurs - this results in strange line numbers and debugging messages from the tools.\n\nExamples:\n\n`define macro_with_args(args) $display(args);  // not allowed\n`define simple_macro $display(\"test\");  // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_18_2_3
extends OVMComplianceCheck {
    public Check_SVTB_18_2_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        block0: for (VlogMacroInfo macro : this.fOVMProject.getAllMacros()) {
            List<VlogMacroInfo> layers;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(macro.getFile()) || (layers = macro.getMacroZoneLayers()) == null) continue;
            for (VlogMacroInfo layer : layers) {
                if (!layer.hasParams()) continue;
                this.addHit(layer.getFileInstance().getParserPath(), layer.getLine(), "Macro '" + macro.getName() + "' has parameters", null);
                continue block0;
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

