/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.19.1")
@CheckName(value="SVTB.19.1")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.PORT, RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.DESIGN, RuleLabel.BIND})
@CheckTitle(value="Bind port connections by name when instantiating elements with many ports")
@CheckDescription(value="Connect ports by name when instantiating elements. This makes the code more readable.\n\nExamples:\n\nmodule example_module(input a, output b, inout c);\nendmodule\n\nexample_module inst1(a, b, c); // not allowed\nexample_module inst2(.a(a), .b(b), .c(c)); // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_19_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="3", description="Check only elements with at least nof ports. Default value: 3. ", name="checkIffNofPortsGreaterThan", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pCheckIffNofPortsGreaterThenValue;
    @CheckParameter(defaultValue="module, interface, program", description="Comma separated list of element kinds that will be checked. Possible values: module, interface, program.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pElementKind;
    @CheckParameter(defaultValue="false", description="When true, :* port connections are not allowed.", name="checkWildcardPortConnection", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckWildcardPortConnection;
    @CheckParameter(defaultValue="true", description="When true, implicit port connections are not allowed.", name="checkImplicitNamedPortConnections", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckImplicitNamedPortConnections;

    public Check_SVTB_19_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(instance -> {
            if (!(instance instanceof RfInstance)) {
                return true;
            }
            ParserPath parserPath = instance.getDeclaration().getParserPath();
            if (this.checkPreWaivers(parserPath)) {
                return true;
            }
            this.notifyCheckAlive();
            IRfDesignElement type = ((RfInstance)instance).getInstantiatedDesign();
            if (type == null) {
                return true;
            }
            if (!this.pElementKind.contains(LintUtils.getElementKind((RfNamedElement)type))) {
                return true;
            }
            RfHidHolder hidHolder = instance.getHidHolder();
            if (hidHolder == null || hidHolder.getHidObjectsMap() == null) {
                return true;
            }
            ListContainer ports = (ListContainer)hidHolder.getHidObjectsMap().get(parserPath);
            if (ports == null) {
                return true;
            }
            int nrPorts = 0;
            for (IHidObject port : ports) {
                IRfNamedElement instanceType;
                if (!(port instanceof IHidOperator) || ((IHidOperator)port).getOccurrence() == null) continue;
                if (((IHidOperator)port).getOccurrence().hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER)) {
                    ++nrPorts;
                }
                if (!this.pCheckWildcardPortConnection || !this.isDotStar((IHidOperator)port) || !((instanceType = ((RfInstance)instance).getAssociatedType()) instanceof RfInstanceHolder) || (nrPorts = ((RfInstanceHolder)instanceType).getPortsWithPrefix("", 2).size()) < this.pCheckIffNofPortsGreaterThenValue) continue;
                this.addLocalHit(instance);
                return true;
            }
            if (nrPorts >= this.pCheckIffNofPortsGreaterThenValue) {
                for (IHidObject port : ports) {
                    if (!(port instanceof IHidOperator) || ((IHidOperator)port).getOccurrence() == null || !((IHidOperator)port).getOccurrence().hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER) || PortConnectionUtils.isFullNamedConnected((IHidOperator)((IHidOperator)port)) || PortConnectionUtils.isFullNamedUnconnected((IHidOperator)((IHidOperator)port)) || !this.pCheckImplicitNamedPortConnections && PortConnectionUtils.isImplicitNamedConnected((IHidOperator)((IHidOperator)port))) continue;
                    this.addLocalHit(instance);
                    return true;
                }
            }
            return true;
        });
    }

    private boolean isDotStar(IHidOperator op) {
        IHidObject lhValue = op.getLHValue();
        if (!(lhValue instanceof RfHidImplicit)) {
            return false;
        }
        RfHidImplicit lhHid = (RfHidImplicit)lhValue;
        return lhHid.isDotStarAssociation();
    }

    private void addLocalHit(RfNamedElement element) {
        this.addHit(element, "All ports must be binded by name");
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

