/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.31")
@CheckID(value="SVTB.19.3.2")
@CheckName(value="SVTB.19.3.2")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.PROGRAM, RuleLabel.PACKAGE, RuleLabel.INTERFACE})
@CheckTitle(value="Specify timeunit and timeprecision in every module, program, package, or interface")
@CheckDescription(value="Every module, program, package, or interface must contain the timeunit and timeprecision statements. If the timeunit specifies the timeprecision with the optional second argument then the timeprecision statement can be omitted.\n\nCheck supports pre-waiving.")
public class Check_SVTB_19_3_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, ensure that timeunit and timeprecision are present in elements that use any time calls.", name="checkOnlyIfTimeCalled", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlyIfTimeCalled;
    protected static final Set<String> TIME_CALLS = new HashSet<String>(Arrays.asList("$time", "$stime", "$realtime"));

    public Check_SVTB_19_3_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement module : this.fOVMProject.getAllModules()) {
            if (this.isPrewaived(module)) continue;
            this.notifyCheckAlive();
            if (this.pCheckOnlyIfTimeCalled && !this.hasTimeCalls(module)) continue;
            if (!((RfModule)module).hasDirectiveTimeprecision()) {
                this.addHit(module, "Module '" + LintUtils.getNamedElementFullName(module) + "' has no timeprecision specified!");
            }
            if (((RfModule)module).hasDirectiveTimeunit()) continue;
            this.addHit(module, "Module '" + LintUtils.getNamedElementFullName(module) + "' has no timeunit specified!");
        }
        for (RfNamedElement intf : this.fOVMProject.getAllInterfaces()) {
            if (this.isPrewaived(intf)) continue;
            this.notifyCheckAlive();
            if (this.pCheckOnlyIfTimeCalled && !this.hasTimeCalls(intf)) continue;
            if (!((RfInterface)intf).hasDirectiveTimeprecision()) {
                this.addHit(intf, "Interface '" + LintUtils.getNamedElementFullName(intf) + "' has no timeprecision specified!");
            }
            if (((RfInterface)intf).hasDirectiveTimeunit()) continue;
            this.addHit(intf, "Interface '" + LintUtils.getNamedElementFullName(intf) + "' has no timeunit specified!");
        }
        for (RfNamedElement program : this.fOVMProject.getAllPrograms()) {
            if (this.isPrewaived(program)) continue;
            this.notifyCheckAlive();
            if (this.pCheckOnlyIfTimeCalled && !this.hasTimeCalls(program)) continue;
            if (!((RfProgram)program).hasDirectiveTimeprecision()) {
                this.addHit(program, "Program '" + LintUtils.getNamedElementFullName(program) + "' has no timeprecision specified!");
            }
            if (((RfProgram)program).hasDirectiveTimeunit()) continue;
            this.addHit(program, "Program '" + LintUtils.getNamedElementFullName(program) + "' has no timeunit specified!");
        }
        for (RfPackage pkg : this.fOVMProject.getAllPackages()) {
            if (this.isPrewaived(pkg)) continue;
            this.notifyCheckAlive();
            if (this.pCheckOnlyIfTimeCalled && !this.hasTimeCalls(pkg)) continue;
            if (!pkg.hasDirectiveTimeprecision()) {
                this.addHit(pkg, "Package '" + LintUtils.getNamedElementFullName(pkg) + "' has no timeprecision specified!");
            }
            if (pkg.hasDirectiveTimeunit()) continue;
            this.addHit(pkg, "Package '" + LintUtils.getNamedElementFullName(pkg) + "' has no timeunit specified!");
        }
    }

    private boolean isPrewaived(RfNamedElement element) {
        RfFileDef fileDef = element.getFile();
        return fileDef != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private boolean hasTimeCalls(RfNamedElement element) {
        LocalHidVisitor localVisitor = new LocalHidVisitor();
        element.visitHidObject(this.fOVMProject.getRfProject(), localVisitor);
        return localVisitor.hasTimeCalls();
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private RfNamedElement scope;
        private boolean hasTimeCalls = false;

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidObject hidObject) {
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            if (hidObject instanceof RfHidOperator) {
                RfHidOperator hidOperator = (RfHidOperator)hidObject;
                if (hidOperator.hasOccurrence(HidOperatorQualifier.IS_DELAY_CONTROL)) {
                    this.hasTimeCalls = true;
                    return false;
                }
            } else if (hidObject instanceof RfHid && ((RfHid)hidObject).isMethodCall(false) && TIME_CALLS.contains(((RfHid)hidObject).getName())) {
                this.hasTimeCalls = true;
                return false;
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public boolean hasTimeCalls() {
            return this.hasTimeCalls;
        }
    }
}

