/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.waivers.PathEntry;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;

@CheckVersion(value="19.1.9")
@CheckID(value="SVTB.19.4")
@CheckName(value="SVTB.19.4")
@CheckLabel(labels={RuleLabel.DESIGN_INSTANTIATION, RuleLabel.SIGNAL})
@CheckTitle(value="Do not access specific module instances or signals")
@CheckDescription(value="Do not access module instances and signals\n\nCheck supports pre-waiving.")
public class Check_SVTB_19_4
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="If true, only module access done from classes will be flagged.", name="checkOnlyAccessFromClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlyAccessFromClassesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of module instance paths to which access is forbidden.", name="moduleInstances", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pModuleInstancesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of full method names for which access is allowed if it's an argument of the method.", name="allowAccessAsArgumentOfMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowAccessAsArgumentOfMethodsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of file or directory paths that will be checked. When empty, check all files.", name="checkPaths", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCheckPathsValue;
    private Map<ParserPath, Set<HidOccurrence>> validArguments = new HashMap<ParserPath, Set<HidOccurrence>>();
    Set<PathEntry> pathPatterns = new HashSet<PathEntry>();
    Map<String, StringMatcher> moduleNames = new HashMap<String, StringMatcher>();

    public Check_SVTB_19_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.validArguments.clear();
        for (String path : this.pCheckPathsValue) {
            path = LintUtils.replaceAllSystemVariables(this.getIProject(), path, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED);
            if (path == null) continue;
            this.pathPatterns.add(new PathEntry(path, true));
        }
        for (String moduleName : this.pModuleInstancesValue) {
            if (moduleName == null || moduleName.isEmpty()) continue;
            this.moduleNames.put(moduleName, new StringMatcher(String.valueOf(moduleName) + ".", false, false));
        }
        if (!this.pCheckOnlyAccessFromClassesValue) {
            this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalMethodCallVisitor());
            this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
        } else {
            for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
                clazz.visitHidObject(this.fOVMProject.getRfProject(), new LocalMethodCallVisitor());
                clazz.visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
            }
        }
    }

    private boolean validParserPath(ParserPath parserPath) {
        if (this.pathPatterns == null || this.pathPatterns.isEmpty()) {
            return true;
        }
        for (PathEntry pathPattern : this.pathPatterns) {
            if (!pathPattern.matches(parserPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isIncorrectAccess(RfHid hid) {
        if (hid.getParentAccess() == null || hid.getParentHid() == null) {
            return false;
        }
        IRfNamedElement parentElement = hid.getParentHid().getElement();
        if (!(parentElement instanceof RfModule) && !(parentElement instanceof RfInstance)) {
            return false;
        }
        HidAccess parentAccess = hid.getParentAccess();
        if (!(parentAccess instanceof RfHidAccess) && parentAccess.getAccessKind() == 0) {
            return false;
        }
        String prefix = HidUtils.toNiceString((IHidObject)parentAccess);
        for (Map.Entry<String, StringMatcher> entry : this.moduleNames.entrySet()) {
            String moduleName = entry.getKey();
            StringMatcher moduleNamePattern = entry.getValue();
            if (!(String.valueOf(moduleName) + ".").equals(prefix) && !moduleNamePattern.match(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHid hid) {
            if (Check_SVTB_19_4.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!Check_SVTB_19_4.this.validParserPath(this.parserPath)) {
                return true;
            }
            Check_SVTB_19_4.this.notifyCheckAlive();
            if (Check_SVTB_19_4.this.validArguments.get(this.parserPath) != null && Check_SVTB_19_4.this.validArguments.get(this.parserPath).contains(hid.getOccurrence())) {
                return true;
            }
            if (Check_SVTB_19_4.this.isIncorrectAccess(hid)) {
                Check_SVTB_19_4.this.addHit(this.parserPath, hid, "Forbidden module access '" + HidUtils.toNiceString((IHidObject)hid) + "'!");
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }

    private final class LocalMethodCallVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;

        private LocalMethodCallVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHid hid) {
            if (Check_SVTB_19_4.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!Check_SVTB_19_4.this.validParserPath(this.parserPath)) {
                return true;
            }
            Check_SVTB_19_4.this.notifyCheckAlive();
            if (hid.isMethodCall(false) && hid.getElement() instanceof RfFunction) {
                List methodCalls;
                RfFunction function = (RfFunction)hid.getElement();
                String name = "";
                name = function == RfHid.SYSTEM_TASK_UNRESOLVED_HID ? hid.getName() : function.getFullName();
                if (Check_SVTB_19_4.this.pAllowAccessAsArgumentOfMethodsValue.contains(name) && (methodCalls = MethodCallUtils.getMethodCalls((IHid)hid)) != null && !methodCalls.isEmpty()) {
                    for (MethodCall methodCall : methodCalls) {
                        Collection argValuesCollection = methodCall.argumentValuesMap.values();
                        for (Set argValues : argValuesCollection) {
                            for (IHid argValue : argValues) {
                                if (argValue instanceof RfHid) {
                                    this.checkArgument(argValue);
                                }
                                IHid parentHid = argValue.getParentHid();
                                while (parentHid != null && parentHid instanceof RfHid) {
                                    this.checkArgument(parentHid);
                                    parentHid = parentHid.getParentHid();
                                }
                            }
                        }
                    }
                }
            }
            return true;
        }

        private void checkArgument(IHid argValue) {
            if (Check_SVTB_19_4.this.isIncorrectAccess((RfHid)argValue)) {
                Set<HidOccurrence> hidArgs = Check_SVTB_19_4.this.validArguments.get(this.parserPath);
                if (hidArgs == null) {
                    hidArgs = new HashSet<HidOccurrence>();
                }
                hidArgs.add(argValue.getOccurrence());
                Check_SVTB_19_4.this.validArguments.put(this.parserPath, hidArgs);
            }
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

