/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCrossModuleReferenceCheck;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="21.1.31")
@CheckID(value="SVTB.19.5")
@CheckName(value="SVTB.19.5")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.MACRO, RuleLabel.XMR})
@CheckTitle(value="Do not use cross module references unless they are done through macros")
@CheckDescription(value="The rule checks that cross module references are done through macros in order to increase the project's maintainability and usability with other environments. Module references to members that are under the hierarchy specified by the <include> parameter, must be done using the macro names specified by the <allowedMacroNames> parameter.\n\nExamples:\npath.to.dut.foo //NOT ALLOWED if path.to.dut is included\npath.to.other_dut.foo // ALLOWED iff path.to.other_dut.foo is not hierarchicaly under path.to.dut\n`define PATH_TO_DUT path.to.dut\n`PATH_TO_DUT.foo //ALLOWED iff PATH_TO_DUT is in allowedMacroNames, or allowedMacroNames is empty\n\nCheck supports pre-waiving.")
public class Check_SVTB_19_5
extends AbstractCrossModuleReferenceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of macro names that must be used for cross module references. If it's empty, any macro is allowed.", name="allowedMacroNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedMacroNames;

    public Check_SVTB_19_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        private LocalHidVisitor() {
        }

        public boolean enterBindInstances() {
            return true;
        }

        public boolean enterDataTypes() {
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(RfHid hid) {
            if (Check_SVTB_19_5.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!hid.hasQualifier(HidQualifierCache.LAST_QUALIFIER)) {
                return true;
            }
            Check_SVTB_19_5.this.notifyCheckAlive();
            if (!Check_SVTB_19_5.this.shouldAnalyzeXMR(hid, this.scope)) {
                return true;
            }
            if (this.macroIsValid(hid)) {
                return true;
            }
            this.addLocalHit(hid);
            return true;
        }

        private boolean macroIsValid(RfHid hid) {
            if (Check_SVTB_19_5.this.includedDesingElements.isEmpty() && Check_SVTB_19_5.this.includedInstances.isEmpty()) {
                RfHid localHid = hid;
                while (localHid.getParentHid() != null) {
                    localHid = localHid.getParentHid();
                }
                return this.checkMacro(localHid);
            }
            IELMemory memory = RfMixedLangManager.getInstance().getELMemory(Check_SVTB_19_5.this.fOVMProject.getProject());
            if (memory == null) {
                return false;
            }
            boolean returnValue = true;
            Hid localHid = hid.getParentHid();
            boolean isInHierarcy = false;
            while (returnValue && localHid != null) {
                IRfNamedElement elemnet = localHid.getElement();
                if (elemnet instanceof RfInstance) {
                    includedPath = (ElementPath)Check_SVTB_19_5.this.includedInstances.get(elemnet);
                    hidPath = Check_SVTB_19_5.this.getElemntPath(localHid, memory);
                    if (includedPath != null && hidPath == null) {
                        isInHierarcy = true;
                    }
                    if (includedPath != null && includedPath.equals((Object)hidPath)) {
                        isInHierarcy = true;
                    }
                } else {
                    includedPath = (ElementPath)Check_SVTB_19_5.this.includedDesingElements.get(elemnet);
                    hidPath = Check_SVTB_19_5.this.getElemntPath(localHid, memory);
                    if (includedPath != null && hidPath == null) {
                        isInHierarcy = true;
                    }
                    if (includedPath != null && includedPath.equals((Object)hidPath)) {
                        isInHierarcy = true;
                    }
                }
                if (isInHierarcy && !this.checkMacro(localHid)) {
                    returnValue = false;
                }
                localHid = localHid.getParentHid();
            }
            return returnValue;
        }

        private boolean checkMacro(Hid localHid) {
            IReparseInfo iReparseInfo = localHid.getReparseInfo();
            String hidName = localHid.getName();
            if (!(iReparseInfo instanceof ReparseInfo)) {
                return false;
            }
            if (Check_SVTB_19_5.this.pAllowedMacroNames.isEmpty()) {
                return true;
            }
            ReparseInfo reparseInfo = (ReparseInfo)iReparseInfo;
            ReparseInfo.ReparseElement[] stack = reparseInfo.getReparseStack();
            if (stack.length == 0) {
                return false;
            }
            boolean foundMacro = false;
            ReparseInfo.ReparseElement[] reparseElementArray = stack;
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                ReparseInfo.ReparseElement element = reparseElementArray[n2];
                String macroName = element.getReparseMacroName();
                String[] params = element.getReparseMacroParams();
                String[] unprocessedParams = element.getReparseMacroUnprocessedParams();
                if (Check_SVTB_19_5.this.pAllowedMacroNames.contains(macroName)) {
                    foundMacro = true;
                    break;
                }
                int i = 0;
                while (i < params.length) {
                    String unprocessedParam = unprocessedParams[i];
                    if (!params[i].equals(unprocessedParam)) {
                        String[] unprocessedParamParts;
                        String[] stringArray = unprocessedParamParts = unprocessedParam.split("\\.");
                        int n3 = unprocessedParamParts.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String unprocessedParamPart = stringArray[n4];
                            if (unprocessedParamPart.equals(hidName)) {
                                foundMacro = false;
                                break;
                            }
                            if (unprocessedParamPart.charAt(0) == '`' && Check_SVTB_19_5.this.pAllowedMacroNames.contains(unprocessedParamPart.substring(1))) {
                                foundMacro = true;
                            }
                            ++n4;
                        }
                    }
                    ++i;
                }
                ++n2;
            }
            return foundMacro;
        }

        private void addLocalHit(RfHid hid) {
            Check_SVTB_19_5.this.addHit(this.parserPath, hid, "Illegal XMR access: '" + HidUtils.toNiceString((IHidObject)hid) + "'!");
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

