/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCrossModuleReferenceCheck;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="21.1.31")
@CheckID(value="SVTB.19.6")
@CheckName(value="SVTB.19.6")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.CONDITIONAL_DIRECTIVE, RuleLabel.XMR})
@CheckTitle(value="Do not use cross module references unless they are enclosed in `ifdef/`ifndef guards")
@CheckDescription(value="The rule checks that statements involving module references are enclosed by `ifdef/`ifndef guards. Statements specified by <checkedStatements> that involve cross module references to <checkedReferences>, must be enclosed in `ifdef/`ifndef guards using names specified by the <allowedGuardNames> parameter.\n\nExamples:\npath.to.dut.foo //NOT ALLOWED if path.to.dut is included\npath.to.other_dut.foo // ALLOWED iff path.to.other_dut.foo is not hierarchicaly under path.to.dut\n`ifdef GATE path.to.dut\npath.to.dut.foo //ALLOWED iff GATE is in allowedGuardNames, or allowedGuardNames is empty\n\nCheck supports pre-waiving.")
public class Check_SVTB_19_6
extends AbstractCrossModuleReferenceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of allowed guard names. If empty, any guard name is allowed.", name="allowedGuardNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedGuardNames;
    @CheckParameter(defaultValue="force, release, assign, deassign, connect, bind, direct", description="Comma separated list of statement types that are going to be checked from: \"force\", \"release\", \"assign\", \"deassign\", \"connect\", \"bind\",  \"direct\".", name="checkedStatements", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCheckedStatements;
    @CheckParameter(defaultValue="port, register, net", description="Comma separated list of references that are going to be checked from: port, register, net.", name="checkedReferences", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCheckedReferences;
    @CheckParameter(defaultValue="negative", description="Comma separated list of guard branches polarities where cross module references are allowed: positive, negative.", name="guardPolarity", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pGuardPolarity;
    private static final String FORCE = "force";
    private static final String RELEASE = "release";
    private static final String ASSIGN = "assign";
    private static final String DEASSIGN = "deassign";
    private static final String CONNECT = "connect";
    private static final String BIND = "bind";
    private static final String DIRECT = "direct";
    private static final String PORT = "port";
    private static final String REGISTER = "register";
    private static final String NET = "net";
    private Map<ParserPath, List<LintUtils.DirectiveInfo>> allDirectives;
    private Map<ParserPath, Set<HidOccurrence>> visitedHids;
    private boolean isNegativePolarityAllowed;
    private boolean isPositivePolarityAllowed;

    public Check_SVTB_19_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pGuardPolarity.isEmpty()) {
            this.signalParamError("'guardPolarity' parameter cannot be empty!", true);
        }
        this.isNegativePolarityAllowed = this.pGuardPolarity.contains("negative");
        this.isPositivePolarityAllowed = this.pGuardPolarity.contains("positive");
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        this.visitedHids = new HashMap<ParserPath, Set<HidOccurrence>>();
        List<ParserPath> allFilesInProject = this.fOVMProject.getAllFilesInOrder();
        this.allDirectives = LintUtils.getAllDirectives(allFilesInProject, this.fOVMProject.getRfProject().getPreprocessingTable(), this.getWSParser());
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidOperatorVisitor());
        if (!this.pCheckedStatements.contains(DIRECT)) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
    }

    private boolean skipInclude(RfHid hid) {
        if (this.includedDesingElements.isEmpty() && this.includedInstances.isEmpty()) {
            return false;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
        if (memory == null) {
            return false;
        }
        boolean returnValue = true;
        Hid localHid = hid.getParentHid();
        while (returnValue && localHid != null) {
            IRfNamedElement elemnet = localHid.getElement();
            if (elemnet instanceof RfInstance) {
                includedPath = (ElementPath)this.includedInstances.get(elemnet);
                hidPath = this.getElemntPath(localHid, memory);
                if (includedPath != null && hidPath == null) {
                    returnValue = false;
                }
                if (includedPath != null && includedPath.equals((Object)hidPath)) {
                    returnValue = false;
                }
            } else {
                includedPath = (ElementPath)this.includedDesingElements.get(elemnet);
                hidPath = this.getElemntPath(localHid, memory);
                if (includedPath != null && hidPath == null) {
                    returnValue = false;
                }
                if (includedPath != null && includedPath.equals((Object)hidPath)) {
                    returnValue = false;
                }
            }
            localHid = localHid.getParentHid();
        }
        return returnValue;
    }

    private boolean skipType(RfHid hid) {
        if (hid == null) {
            return true;
        }
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfField)) {
            return true;
        }
        RfField field = (RfField)element;
        if (field instanceof RfPort) {
            return !this.pCheckedReferences.contains(PORT);
        }
        if (field.isNet()) {
            return !this.pCheckedReferences.contains(NET);
        }
        RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field);
        if (fieldType instanceof RfInstanceHolder) {
            return true;
        }
        return !this.pCheckedReferences.contains(REGISTER);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private void addLocalHit(RfHidOperator hidOperator, ParserPath parserPath) {
        this.addHit(parserPath, (HidOccurrence)hidOperator.getOccurrence(), "Illegal XMR access: '" + HidUtils.toNiceString((IHidObject)hidOperator) + "'!");
    }

    private void addLocalHit(RfHid hid, ParserPath parserPath) {
        this.addHit(parserPath, hid.getOccurrence(), "Illegal XMR access: '" + HidUtils.toNiceString((IHidObject)hid) + "'!");
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        public boolean enterBindInstances() {
            return true;
        }

        public boolean enterDataTypes() {
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(RfHidOperator hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (Check_SVTB_19_6.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_SVTB_19_6.this.notifyCheckAlive();
            if (LintUtils.isOffsetInsideGuard(Check_SVTB_19_6.this.allDirectives, this.parserPath, hidObject.getOccurrence().getOffset(), Check_SVTB_19_6.this.pAllowedGuardNames, Check_SVTB_19_6.this.isPositivePolarityAllowed, Check_SVTB_19_6.this.isNegativePolarityAllowed)) {
                return true;
            }
            if (!hidObject.isAssignment()) {
                boolean analyzeBindOrConnect = false;
                HidOperatorOccurrence occurance = hidObject.getOccurrence();
                if (Check_SVTB_19_6.this.pCheckedStatements.contains(Check_SVTB_19_6.CONNECT) && occurance.hasQualifier(HidOperatorQualifier.IS_PORT_CONNECTION)) {
                    analyzeBindOrConnect = true;
                }
                if (Check_SVTB_19_6.this.pCheckedStatements.contains(Check_SVTB_19_6.BIND) && occurance.hasQualifier(HidOperatorQualifier.IS_PORT_CONNECTION)) {
                    if (this.scope instanceof RfInstance.RfBindInstance) {
                        analyzeBindOrConnect = true;
                    }
                    if (this.scope.getEnclosingScope(RfInstance.RfBindInstance.class) != null) {
                        analyzeBindOrConnect = true;
                    }
                }
                if (analyzeBindOrConnect) {
                    this.checkBindOrConnect(hidObject);
                    return true;
                }
                boolean analyzeReleaseOrDeassign = false;
                if (hidObject.hasOccurrence(HidOperatorQualifier.IS_PROCEDURAL_CONTINUOUS_ASSIGN)) {
                    if (hidObject.isRelease() && Check_SVTB_19_6.this.pCheckedStatements.contains(Check_SVTB_19_6.RELEASE)) {
                        analyzeReleaseOrDeassign = true;
                    }
                    if (hidObject.isDeassign() && Check_SVTB_19_6.this.pCheckedStatements.contains(Check_SVTB_19_6.DEASSIGN)) {
                        analyzeReleaseOrDeassign = true;
                    }
                }
                if (analyzeReleaseOrDeassign) {
                    this.checkReleaseOrDeassign(hidObject);
                    return true;
                }
            } else {
                boolean analyzeAssignOrForce = false;
                HidOperatorOccurrence occurance = hidObject.getOccurrence();
                if (occurance.hasQualifier(HidOperatorQualifier.IS_PROCEDURAL_FORCE_ASSIGN) && Check_SVTB_19_6.this.pCheckedStatements.contains(Check_SVTB_19_6.FORCE)) {
                    analyzeAssignOrForce = true;
                }
                if (occurance.hasQualifier(HidOperatorQualifier.IS_PROCEDURAL_CONTINUOUS_ASSIGN) && Check_SVTB_19_6.this.pCheckedStatements.contains(Check_SVTB_19_6.ASSIGN)) {
                    analyzeAssignOrForce = true;
                }
                if (analyzeAssignOrForce) {
                    this.checkAssignOrForce(hidObject);
                }
            }
            return true;
        }

        private void checkAssignOrForce(RfHidOperator hidObject) {
            boolean checkRight;
            boolean checkLeft;
            IHidObject lhValue = hidObject.getLHValue();
            ListContainer rhValues = hidObject.getRHValues();
            RfHid lhValueHid = this.getRfHid(lhValue);
            if (lhValueHid != null) {
                Set<HidOccurrence> hids = Check_SVTB_19_6.this.visitedHids.get(this.parserPath);
                if (hids == null) {
                    hids = new HashSet<HidOccurrence>();
                }
                hids.add(lhValueHid.getOccurrence());
                Check_SVTB_19_6.this.visitedHids.put(this.parserPath, hids);
            }
            if ((checkLeft = Check_SVTB_19_6.this.shouldAnalyzeXMR(lhValueHid, this.scope)) && lhValueHid != null && !Check_SVTB_19_6.this.skipType(lhValueHid) && !Check_SVTB_19_6.this.skipInclude(lhValueHid)) {
                Check_SVTB_19_6.this.addLocalHit(hidObject, this.parserPath);
                return;
            }
            if (rhValues == null || rhValues.isEmpty()) {
                return;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            RfHid rhValueHid = this.getRfHid(rhValue);
            if (rhValueHid != null) {
                Set<HidOccurrence> hids = Check_SVTB_19_6.this.visitedHids.get(this.parserPath);
                if (hids == null) {
                    hids = new HashSet<HidOccurrence>();
                }
                hids.add(rhValueHid.getOccurrence());
                Check_SVTB_19_6.this.visitedHids.put(this.parserPath, hids);
            }
            if ((checkRight = Check_SVTB_19_6.this.shouldAnalyzeXMR(rhValueHid, this.scope)) && rhValueHid != null && !Check_SVTB_19_6.this.skipType(rhValueHid) && !Check_SVTB_19_6.this.skipInclude(rhValueHid)) {
                Check_SVTB_19_6.this.addLocalHit(hidObject, this.parserPath);
            }
        }

        private void checkReleaseOrDeassign(RfHidOperator hidObject) {
            IHidObject lhValue = hidObject.getLHValue();
            RfHid hid = this.getRfHid(lhValue);
            if (hid != null) {
                Set<HidOccurrence> hids = Check_SVTB_19_6.this.visitedHids.get(this.parserPath);
                if (hids == null) {
                    hids = new HashSet<HidOccurrence>();
                }
                hids.add(hid.getOccurrence());
                Check_SVTB_19_6.this.visitedHids.put(this.parserPath, hids);
            }
            if (!Check_SVTB_19_6.this.shouldAnalyzeXMR(hid, this.scope)) {
                return;
            }
            if (Check_SVTB_19_6.this.skipType(hid)) {
                return;
            }
            if (Check_SVTB_19_6.this.skipInclude(hid)) {
                return;
            }
            Check_SVTB_19_6.this.addLocalHit(hidObject, this.parserPath);
        }

        private void checkBindOrConnect(RfHidOperator hidObject) {
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            RfHid rhValueHid = this.getRfHid(rhValue);
            if (rhValueHid != null) {
                Set<HidOccurrence> hids = Check_SVTB_19_6.this.visitedHids.get(this.parserPath);
                if (hids == null) {
                    hids = new HashSet<HidOccurrence>();
                }
                hids.add(rhValueHid.getOccurrence());
                Check_SVTB_19_6.this.visitedHids.put(this.parserPath, hids);
            }
            if (!Check_SVTB_19_6.this.shouldAnalyzeXMR(rhValueHid, this.scope)) {
                return;
            }
            if (Check_SVTB_19_6.this.skipType(rhValueHid)) {
                return;
            }
            if (Check_SVTB_19_6.this.skipInclude(rhValueHid)) {
                return;
            }
            Check_SVTB_19_6.this.addLocalHit(hidObject, this.parserPath);
        }

        private RfHid getRfHid(IHidObject hid) {
            Hid parentHid;
            RfHid rfHid = null;
            if (hid instanceof RfHid) {
                rfHid = (RfHid)hid;
            }
            if (hid instanceof RfHidAccess && (parentHid = ((RfHidAccess)hid).getParentHid()) instanceof RfHid) {
                rfHid = (RfHid)parentHid;
            }
            return rfHid;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    public class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        public boolean enterBindInstances() {
            return true;
        }

        public boolean enterDataTypes() {
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (!hidObject.hasQualifier(HidQualifierCache.LAST_QUALIFIER)) {
                return true;
            }
            if (Check_SVTB_19_6.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_SVTB_19_6.this.notifyCheckAlive();
            if (LintUtils.isOffsetInsideGuard(Check_SVTB_19_6.this.allDirectives, this.parserPath, hidObject.getOccurrence().getOffset(), Check_SVTB_19_6.this.pAllowedGuardNames, Check_SVTB_19_6.this.isPositivePolarityAllowed, Check_SVTB_19_6.this.isNegativePolarityAllowed)) {
                return true;
            }
            this.checkDirectAccess(hidObject);
            return true;
        }

        private void checkDirectAccess(RfHid hid) {
            Set<HidOccurrence> hids = Check_SVTB_19_6.this.visitedHids.get(this.parserPath);
            if (hids != null && hids.contains(hid.getOccurrence())) {
                return;
            }
            if (!Check_SVTB_19_6.this.shouldAnalyzeXMR(hid, this.scope)) {
                return;
            }
            if (Check_SVTB_19_6.this.skipType(hid)) {
                return;
            }
            if (Check_SVTB_19_6.this.skipInclude(hid)) {
                return;
            }
            Check_SVTB_19_6.this.addLocalHit(hid, this.parserPath);
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

