/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExBaseDefinition;
import ro.amiq.dvt.ui.preferences.DVTPreferenceMapper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_0;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.formatter.VlogFormattingPreferences;
import ro.amiq.vlogdt.ui.preferences.VlogPreferenceMapper;
import ro.amiq.vlogdt.utils.Utils;

@CheckVersion(value="21.1.15")
@CheckID(value="SVTB.1.0")
@CheckName(value="SVTB.1.0")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.FILE})
@CheckTitle(value="Files should be formatted")
@CheckDescription(value="Files should be formatted according to a common set of formatting preferences to ensure the code is easy to read, maintain and understand.\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_1_0.class)
public class Check_SVTB_1_0
extends OVMComplianceCheck {
    private static final String ORG_ECLIPSE_UI_EDITORS = "org.eclipse.ui.editors";
    private static final String ALL_PREFS_WITH_DEFAULTS_VALS = "org.eclipse.ui.editors/tabWidth=4\norg.eclipse.ui.editors/spacesForTabs=false\nro.amiq.vlogdt/format.whitespace.add_after=\nro.amiq.vlogdt/format.whitespace.add_before=\nro.amiq.vlogdt/format.whitespace.remove_nl_after=\nro.amiq.vlogdt/format.whitespace.remove_nl_before=\nro.amiq.vlogdt/format.whitespace.compact=false\nro.amiq.vlogdt/format.whitespace.trim_end_of_line=true\nro.amiq.vlogdt/format.whitespace.trim_whitespace_line=true\nro.amiq.vlogdt/format.whitespace.compact_consecutive_empty_lines=false\nro.amiq.vlogdt/format.whitespace.maximum_nof_consecutive_empty_lines=1\nro.amiq.vlogdt/format.indent.begin=1\nro.amiq.vlogdt/format.indent.else=1\nro.amiq.vlogdt/format.indent.params=1\nro.amiq.vlogdt/format.indent.preproc=1\nro.amiq.vlogdt/format.indent.skip.ml.macro.definitions=false\nro.amiq.vlogdt/format.indent.preserve_sl_comment_column_zero=true\nro.amiq.vlogdt/format.indent.multiline_comments=true\nro.amiq.vlogdt/format.indent.skip_assigns=false\nro.amiq.vlogdt/format.indent.add_new_line_after_begin_and_before_end=false\nro.amiq.vlogdt/format.indent.add_new_line_after_end=false\nro.amiq.vlogdt/format.indent.no_indent_keywords=\nro.amiq.vlogdt/format.indent.ignore_lines=\nro.amiq.vlogdt/format.indent.implicit_semi_macros=ovm_info(), ovm_warning(), ovm_error(), ovm_fatal(), ovm_create(), ovm_create_on(), ovm_do(), ovm_do_pri(), ovm_do_with(), ovm_do_pri_with(), ovm_do_on(), ovm_do_on_pri(), ovm_do_on_with(), ovm_do_on_pri_with(), ovm_do_seq(), ovm_do_seq_with(), ovm_send(), ovm_send_pri(), ovm_rand_send(), ovm_rand_send_pri(), ovm_rand_send_with(), ovm_rand_send_pri_with(), ovm_do_callbacks(), ovm_do_obj_callbacks(), ovm_do_task_callbacks(), ovm_do_callbacks_exit_on(), ovm_do_obj_callbacks_exit_on(), ovm_cb_trace(), ovm_cb_trace_noobj(), uvm_info(), uvm_warning(), uvm_error(), uvm_fatal(), uvm_create(), uvm_create_on(), uvm_create_seq(), uvm_do(), uvm_do_pri(), uvm_do_with(), uvm_do_pri_with(), uvm_do_on(), uvm_do_on_pri(), uvm_do_on_with(), uvm_do_on_pri_with(), uvm_do_seq(), uvm_do_seq_with(), uvm_send(), uvm_send_pri(), uvm_rand_send(), uvm_rand_send_pri(), uvm_rand_send_with(), uvm_rand_send_pri_with(), uvm_register_cb(), uvm_set_super_type(), uvm_do_callbacks(), uvm_do_obj_callbacks(), uvm_do_callbacks_exit_on(), uvm_do_obj_callbacks_exit_on(), uvm_cb_trace(), uvm_cb_trace_noobj()\nro.amiq.vlogdt/format.indent.open_scope_macros=\nro.amiq.vlogdt/format.indent.close_scope_macros=\nro.amiq.vlogdt/format.vertical_align=false\nro.amiq.vlogdt/format.vertical_align.independent_ifdefs=false\nro.amiq.vlogdt/format.vertical_align.tokens=\\=,<\\=\nro.amiq.vlogdt/format.vertical_align.consecutive_lines=false\nro.amiq.vlogdt/format.vertical_align.paren=false\nro.amiq.vlogdt/format.vertical_align.curly=false\nro.amiq.vlogdt/format.vertical_align.sl_comments=false\nro.amiq.vlogdt/format.vertical_align.vregex=\nro.amiq.vlogdt/format.line_wrap=false\nro.amiq.vlogdt/format.line_wrap.threshold=80\nro.amiq.vlogdt/format.line_wrap.ml_comments=false\nro.amiq.vlogdt/format.line_wrap.sl_comments=false\nro.amiq.vlogdt/format.pre_external=false\nro.amiq.vlogdt/format.pre_external.command=pre_format_code %f\nro.amiq.vlogdt/format.post_external=false\nro.amiq.vlogdt/format.post_external.command=post_format_code %f\nro.amiq.vlogdt/format.external=false\nro.amiq.vlogdt/format.external.command=format_code %f.";
    private final Map<String, Integer> cachedPreferencesInteger = new HashMap<String, Integer>();
    private final Map<String, Boolean> cachedPreferencesBoolean = new HashMap<String, Boolean>();
    private final Map<String, String> cachedPreferencesString = new HashMap<String, String>();
    private static final String PREFERENCES_FILE_NAME = "preferencesFile";
    private Map<String, String> preferencesMap;
    private String preferencesMapValue;
    @CheckParameter(defaultValue="", description="Use preferences defined in <preferencesFile>. DVT for VSCode and for Eclipse preferences file formats are supported\nThe preferences in Eclipse format used by this rule with their corresponding default value are:\norg.eclipse.ui.editors/tabWidth=4\norg.eclipse.ui.editors/spacesForTabs=false\nro.amiq.vlogdt/format.whitespace.add_after=\nro.amiq.vlogdt/format.whitespace.add_before=\nro.amiq.vlogdt/format.whitespace.remove_nl_after=\nro.amiq.vlogdt/format.whitespace.remove_nl_before=\nro.amiq.vlogdt/format.whitespace.compact=false\nro.amiq.vlogdt/format.whitespace.trim_end_of_line=true\nro.amiq.vlogdt/format.whitespace.trim_whitespace_line=true\nro.amiq.vlogdt/format.whitespace.compact_consecutive_empty_lines=false\nro.amiq.vlogdt/format.whitespace.maximum_nof_consecutive_empty_lines=1\nro.amiq.vlogdt/format.indent.begin=1\nro.amiq.vlogdt/format.indent.else=1\nro.amiq.vlogdt/format.indent.params=1\nro.amiq.vlogdt/format.indent.preproc=1\nro.amiq.vlogdt/format.indent.skip.ml.macro.definitions=false\nro.amiq.vlogdt/format.indent.preserve_sl_comment_column_zero=true\nro.amiq.vlogdt/format.indent.multiline_comments=true\nro.amiq.vlogdt/format.indent.skip_assigns=false\nro.amiq.vlogdt/format.indent.add_new_line_after_begin_and_before_end=false\nro.amiq.vlogdt/format.indent.add_new_line_after_end=false\nro.amiq.vlogdt/format.indent.no_indent_keywords=\nro.amiq.vlogdt/format.indent.ignore_lines=\nro.amiq.vlogdt/format.indent.implicit_semi_macros=ovm_info(), ovm_warning(), ovm_error(), ovm_fatal(), ovm_create(), ovm_create_on(), ovm_do(), ovm_do_pri(), ovm_do_with(), ovm_do_pri_with(), ovm_do_on(), ovm_do_on_pri(), ovm_do_on_with(), ovm_do_on_pri_with(), ovm_do_seq(), ovm_do_seq_with(), ovm_send(), ovm_send_pri(), ovm_rand_send(), ovm_rand_send_pri(), ovm_rand_send_with(), ovm_rand_send_pri_with(), ovm_do_callbacks(), ovm_do_obj_callbacks(), ovm_do_task_callbacks(), ovm_do_callbacks_exit_on(), ovm_do_obj_callbacks_exit_on(), ovm_cb_trace(), ovm_cb_trace_noobj(), uvm_info(), uvm_warning(), uvm_error(), uvm_fatal(), uvm_create(), uvm_create_on(), uvm_create_seq(), uvm_do(), uvm_do_pri(), uvm_do_with(), uvm_do_pri_with(), uvm_do_on(), uvm_do_on_pri(), uvm_do_on_with(), uvm_do_on_pri_with(), uvm_do_seq(), uvm_do_seq_with(), uvm_send(), uvm_send_pri(), uvm_rand_send(), uvm_rand_send_pri(), uvm_rand_send_with(), uvm_rand_send_pri_with(), uvm_register_cb(), uvm_set_super_type(), uvm_do_callbacks(), uvm_do_obj_callbacks(), uvm_do_callbacks_exit_on(), uvm_do_obj_callbacks_exit_on(), uvm_cb_trace(), uvm_cb_trace_noobj()\nro.amiq.vlogdt/format.indent.open_scope_macros=\nro.amiq.vlogdt/format.indent.close_scope_macros=\nro.amiq.vlogdt/format.vertical_align=false\nro.amiq.vlogdt/format.vertical_align.independent_ifdefs=false\nro.amiq.vlogdt/format.vertical_align.tokens=\\=,<\\=\nro.amiq.vlogdt/format.vertical_align.consecutive_lines=false\nro.amiq.vlogdt/format.vertical_align.paren=false\nro.amiq.vlogdt/format.vertical_align.curly=false\nro.amiq.vlogdt/format.vertical_align.sl_comments=false\nro.amiq.vlogdt/format.vertical_align.vregex=\nro.amiq.vlogdt/format.line_wrap=false\nro.amiq.vlogdt/format.line_wrap.threshold=80\nro.amiq.vlogdt/format.line_wrap.ml_comments=false\nro.amiq.vlogdt/format.line_wrap.sl_comments=false\nro.amiq.vlogdt/format.pre_external=false\nro.amiq.vlogdt/format.pre_external.command=pre_format_code %f\nro.amiq.vlogdt/format.post_external=false\nro.amiq.vlogdt/format.post_external.command=post_format_code %f\nro.amiq.vlogdt/format.external=false\nro.amiq.vlogdt/format.external.command=format_code %f.", name="preferencesFile", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String preferencesFile;

    public Check_SVTB_1_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String parseParametersDescriptionForRulesetDoc(String parameterName, String defaultValue, String userValue, String description, boolean isOptional) {
        if (parameterName.equals(PREFERENCES_FILE_NAME)) {
            StringBuilder result = new StringBuilder();
            if (isOptional) {
                result.append(" : [optional] " + description);
            } else {
                result.append(" : [mandatory] " + description);
            }
            if (!defaultValue.isEmpty()) {
                result.append(" Default value: " + defaultValue + ".");
            } else {
                result.append(" No default value.");
            }
            if (this.preferencesMap == null) {
                if (!this.preferencesFile.isEmpty()) {
                    result.append(" User value: ").append("\n").append(this.preferencesMapValue);
                }
            } else {
                String propertyValue = this.getProperty(parameterName);
                if (propertyValue != null) {
                    result.append(" User value: ").append(this.getPreferenceValues());
                }
            }
            result.append('\n');
            return String.valueOf(parameterName) + result.toString().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase());
        }
        return super.parseParametersDescriptionForRulesetDoc(parameterName, defaultValue, null, description, isOptional);
    }

    private String getPreferenceValues() {
        StringBuilder result = new StringBuilder();
        result.append("\nReading from file: " + this.preferencesFile);
        for (Map.Entry<String, String> preference : this.preferencesMap.entrySet()) {
            result.append("\n").append(preference.getKey()).append("=").append(preference.getValue());
        }
        return result.toString();
    }

    @Override
    public Map<String, String> getProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(super.getProperties());
        String parameterValue = (String)properties.get(PREFERENCES_FILE_NAME);
        if (parameterValue != null && this.preferencesMap != null) {
            StringBuilder result = new StringBuilder(parameterValue);
            result.append(this.getPreferenceValues());
            properties.put(PREFERENCES_FILE_NAME, result.toString());
        }
        return properties;
    }

    @Override
    public void setProperty(String key, String value) {
        int endOfPathIndex;
        if (this.preferencesMap == null && PREFERENCES_FILE_NAME.equals(key) && (endOfPathIndex = value.indexOf("\n")) != -1) {
            String actualValue = value.substring(0, endOfPathIndex);
            this.preferencesMapValue = value.substring(endOfPathIndex + 1);
            super.setProperty(key, actualValue);
            return;
        }
        super.setProperty(key, value);
    }

    @Override
    public void performCheckImpl() {
        VerrissimoVlogFormattingPreferences formattingPrefs;
        this.preferencesMap = new HashMap<String, String>();
        VlogSourceViewerConfiguration svc = new VlogSourceViewerConfiguration();
        if (this.preferencesFile.isEmpty()) {
            this.configurePreferences(svc, null);
            formattingPrefs = new VerrissimoVlogFormattingPreferences();
        } else {
            String prefsFilePath = LintUtils.replaceAllSystemVariables(this.fOVMProject.getProject(), this.preferencesFile, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL);
            if (prefsFilePath == null) {
                this.signalParamError("Rule parameter '" + this.preferencesFile + "' contains invalid system variable!", true);
                return;
            }
            this.preferencesMap = this.getPreferencesMap(prefsFilePath);
            if (this.preferencesMap == null) {
                this.signalParamError("Could not parse preferences!", true);
                return;
            }
            boolean hadErrors = this.checkPreferences(this.preferencesMap);
            if (hadErrors) {
                return;
            }
            this.configurePreferences(svc, this.preferencesMap);
            formattingPrefs = new VerrissimoVlogFormattingPreferences(this.preferencesMap);
        }
        IContentFormatter formatter = svc.getContentFormatter(null, formattingPrefs);
        if (!(formatter instanceof DVTContentFormatter)) {
            this.addHit(null, "Could not format project!");
            return;
        }
        for (ParserPath file : this.fOVMProject.getAllImportedFiles()) {
            Set<Integer> diffRowsIndexes;
            if (this.fOVMProject.isOVMFile(Utils.getInstance().getFileName(file.getCanonicalPath()))) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(file)) continue;
            String code = DVTFileUtils.getInstance().readFileContent(new File(file.path));
            Document unformattedDocument = new Document(code);
            Document formattedDocument = new Document(code);
            ((DVTContentFormatter)formatter).format((IDocument)formattedDocument, (IRegion)new Region(0, formattedDocument.getLength()));
            LinkedHashMap<Integer, DiffRow> diffRows = this.getDiffRows((IDocument)unformattedDocument, (IDocument)formattedDocument);
            if (diffRows.isEmpty() || (diffRowsIndexes = diffRows.keySet()) == null || diffRowsIndexes.isEmpty()) continue;
            this.addHit(file, (int)diffRowsIndexes.iterator().next(), this.getDetails(diffRows), null, new VerissimoAutofixAdditionalInfo(formattedDocument.get()));
        }
    }

    private boolean checkCommandFormat(String preference, String command) {
        String[] commandComponents = command.split(" ");
        if (commandComponents.length != 2) {
            this.signalParamError("The preference `" + preference + "` requires exactly 2 parameters: the path to the script and the \"%f\" placeholder!", true);
            return true;
        }
        if (!commandComponents[1].equals("%f")) {
            this.signalParamError("The second parameter of the preference `" + preference + "` needs to be exactly \"%f\"!", true);
            return true;
        }
        File scriptFile = new File(commandComponents[0]);
        if (!scriptFile.exists()) {
            this.signalParamError("The script file specified in the preference `" + preference + "` does not exist!", true);
            return true;
        }
        if (!scriptFile.canExecute()) {
            this.signalParamError("The script file specified in the preference `" + preference + "` does not have the right permissions and cannot be executed!", true);
            return true;
        }
        return false;
    }

    private boolean checkPreferences(Map<String, String> preferences) {
        String[] commandPreferences;
        String[] stringArray = commandPreferences = new String[]{"format.pre_external.command", "format.post_external.command", "format.external.command"};
        int n = commandPreferences.length;
        int n2 = 0;
        while (n2 < n) {
            boolean hadError;
            String commandPreference = stringArray[n2];
            if (preferences.containsKey(commandPreference) && (hadError = this.checkCommandFormat(commandPreference, preferences.get(commandPreference)))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Map<String, String> getPreferencesMap(String prefsFilePath) {
        HashMap<String, String> prefsMap;
        block18: {
            block17: {
                prefsMap = new HashMap<String, String>();
                if (!prefsFilePath.endsWith(".ini")) break block17;
                Properties prefs = this.readPreferencesFromFile(prefsFilePath);
                if (prefs == null) {
                    return null;
                }
                for (Map.Entry<Object, Object> entry : prefs.entrySet()) {
                    String[] splitPath;
                    String value = (String)entry.getValue();
                    if (value == null || (splitPath = EclipsePreferences.decodePath((String)((String)entry.getKey())))[0] == null || splitPath[1] == null || !"ro.amiq.vlogdt".equals(splitPath[0]) && !ORG_ECLIPSE_UI_EDITORS.equals(splitPath[0])) continue;
                    prefsMap.put(splitPath[1], value);
                }
                break block18;
            }
            if (!prefsFilePath.endsWith(".json")) break block18;
            JSONObject prefs = this.readPreferencesFromJSONFile(prefsFilePath);
            if (prefs == null) {
                return null;
            }
            Iterator keys = prefs.keys();
            VerrissimoVlogFormattingPreferences formatPrefs = new VerrissimoVlogFormattingPreferences();
            Map<String, String> vregExPrefs = formatPrefs.getVRefVSCodeToEclipse();
            while (keys.hasNext()) {
                String LSPref = (String)keys.next();
                String eclipsePref = VlogPreferenceMapper.INSTANCE.getEclipsePreference(LSPref);
                try {
                    Object value = prefs.get(LSPref);
                    StringBuilder valueString = new StringBuilder();
                    if (value instanceof JSONObject) {
                        JSONObject jsonObject = (JSONObject)value;
                        Iterator objectKeys = jsonObject.keys();
                        while (objectKeys.hasNext()) {
                            Boolean objectValue;
                            String objectKey = (String)objectKeys.next();
                            Object a = jsonObject.get(objectKey);
                            if (!(a instanceof Boolean) || !(objectValue = (Boolean)a).booleanValue()) continue;
                            if (LSPref.equals("DVT.textEditor.systemVerilog.formatting.verticalAlignment.verticalAlignPatterns".substring(0, "DVT.textEditor.systemVerilog.formatting.verticalAlignment.verticalAlignPatterns".length()))) {
                                objectKey = vregExPrefs.get(objectKey);
                            }
                            valueString.append(objectKey);
                            if (!keys.hasNext()) continue;
                            valueString.append(", ");
                        }
                    } else if (value instanceof JSONArray) {
                        JSONArray jsonArray = (JSONArray)value;
                        int i = 0;
                        while (i < jsonArray.length()) {
                            valueString.append(jsonArray.get(i).toString());
                            if (i < jsonArray.length() - 1) {
                                valueString.append(", ");
                            }
                            ++i;
                        }
                    } else {
                        int indentValue = this.translateSpecialIndentValues(LSPref, value);
                        if (indentValue != 0) {
                            valueString.append(indentValue);
                        } else {
                            valueString.append(value.toString());
                        }
                    }
                    if (eclipsePref == null) {
                        eclipsePref = DVTPreferenceMapper.INSTANCE.getEclipsePreference(LSPref);
                    }
                    if (eclipsePref == null) continue;
                    prefsMap.put(eclipsePref, valueString.toString());
                }
                catch (JSONException e) {
                    this.fOVMProject.notifyCheckException(this, (Exception)((Object)e));
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        return prefsMap;
    }

    private int translateSpecialIndentValues(String LSPref, Object value) {
        if (LSPref.equals("DVT.textEditor.systemVerilog.formatting.indentation.optionalBegin")) {
            if (value.toString().equals("Leave as is")) {
                return 1;
            }
            if (value.toString().equals("On a new line")) {
                return 2;
            }
            if (value.toString().equals("On the same line")) {
                return 3;
            }
        } else if (LSPref.equals("DVT.textEditor.systemVerilog.formatting.indentation.else")) {
            if (value.toString().equals("Leave as is")) {
                return 1;
            }
            if (value.toString().equals("On a new line")) {
                return 2;
            }
            if (value.toString().equals("On the same line")) {
                return 3;
            }
            if (value.toString().equals("On a new line and indent")) {
                return 4;
            }
        } else if (LSPref.equals("DVT.textEditor.systemVerilog.formatting.indentation.parameters")) {
            if (value.toString().equals("Leave as is")) {
                return 1;
            }
            if (value.toString().equals("One per line (open parenthesis on the same line)")) {
                return 2;
            }
            if (value.toString().equals("One per line (open parenthesis on the next line)")) {
                return 3;
            }
            if (value.toString().equals("More per line")) {
                return 4;
            }
        } else if (LSPref.equals("DVT.textEditor.systemVerilog.formatting.indentation.preprocessing")) {
            if (value.toString().equals("Leave as is")) {
                return 1;
            }
            if (value.toString().equals("Indent")) {
                return 2;
            }
            if (value.toString().equals("Indent and increase indentation level")) {
                return 3;
            }
            if (value.toString().equals("Move at first column")) {
                return 4;
            }
            if (value.toString().equals("Indent and increase indentation level except first")) {
                return 5;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties readPreferencesFromFile(String prefsFilePath) {
        File prefsFile = new File(prefsFilePath);
        if (!prefsFile.canRead()) {
            this.signalParamError("Can't read " + prefsFile.getPath(), true);
            return null;
        }
        Reader input = null;
        Properties result = new Properties();
        try {
            try {
                input = new BufferedReader(new FileReader(prefsFile));
                result.load(input);
                return result;
            }
            catch (FileNotFoundException e) {
                this.signalParamError("Can't find " + prefsFile.getPath(), true);
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (input == null) return result;
                try {
                    input.close();
                    return result;
                }
                catch (IOException e2) {
                    this.fOVMProject.notifyCheckException(this, e2);
                    DVTLogger.INSTANCE.logError((Throwable)e2);
                }
                return result;
            }
            catch (IOException e) {
                this.signalParamError("I/O exception occured while reading " + prefsFile.getPath(), true);
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (input == null) return result;
                try {
                    input.close();
                    return result;
                }
                catch (IOException e3) {
                    this.fOVMProject.notifyCheckException(this, e3);
                    DVTLogger.INSTANCE.logError((Throwable)e3);
                }
                return result;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
    }

    private JSONObject readPreferencesFromJSONFile(String prefsFilePath) {
        StringBuilder jsonContent;
        JSONObject result;
        File prefsFile;
        block21: {
            prefsFile = new File(prefsFilePath);
            if (!prefsFile.canRead()) {
                this.signalParamError("Can't read " + prefsFile.getPath(), true);
                return null;
            }
            result = null;
            BufferedReader input = null;
            jsonContent = new StringBuilder();
            try {
                String line;
                input = new BufferedReader(new FileReader(prefsFile));
                while ((line = input.readLine()) != null) {
                    jsonContent.append(line);
                }
            }
            catch (FileNotFoundException e) {
                this.signalParamError("Can't find " + prefsFile.getPath(), true);
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        this.fOVMProject.notifyCheckException(this, e2);
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                }
                break block21;
            }
            catch (IOException e) {
                try {
                    this.signalParamError("I/O exception occured while reading " + prefsFile.getPath(), true);
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e3) {
                            this.fOVMProject.notifyCheckException(this, e3);
                            DVTLogger.INSTANCE.logError((Throwable)e3);
                        }
                    }
                }
            }
            if (input == null) break block21;
            try {
                input.close();
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        try {
            result = new JSONObject(jsonContent.toString());
        }
        catch (JSONException e) {
            this.signalParamError("Exception occured while converting file content to a JSONObject  " + prefsFile.getPath(), true);
            this.fOVMProject.notifyCheckException(this, (Exception)((Object)e));
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void configurePreferences(VlogSourceViewerConfiguration svc, Map<String, String> prefsMap) {
        this.configureTabWidth(svc, prefsMap);
        this.configureInsertSpaces(svc, prefsMap);
        this.configureVerticalAlignTokens(svc, prefsMap);
    }

    private void configureTabWidth(VlogSourceViewerConfiguration svc, Map<String, String> prefsMap) {
        if (svc == null) {
            return;
        }
        if (prefsMap == null) {
            svc.setTabWidth(4);
            return;
        }
        String tabSizeAsString = prefsMap.get("tabWidth");
        if (tabSizeAsString == null) {
            svc.setTabWidth(4);
            return;
        }
        svc.setTabWidth(Integer.parseInt(tabSizeAsString));
    }

    private void configureInsertSpaces(VlogSourceViewerConfiguration svc, Map<String, String> prefsMap) {
        if (svc == null) {
            return;
        }
        if (prefsMap == null) {
            svc.setInsertSpaces(false);
            return;
        }
        String insertSpacesAsString = prefsMap.get("spacesForTabs");
        if (insertSpacesAsString == null) {
            svc.setInsertSpaces(false);
            return;
        }
        svc.setInsertSpaces(Boolean.parseBoolean(insertSpacesAsString));
    }

    private void configureVerticalAlignTokens(VlogSourceViewerConfiguration svc, Map<String, String> prefsMap) {
        if (svc == null) {
            return;
        }
        if (prefsMap == null) {
            DVTPlugin.getDefault().getPreferenceStore().setValue("format.vertical_align.tokens", "=,<=");
            return;
        }
        String verticalAlignTokens = prefsMap.get("format.vertical_align.tokens");
        if (verticalAlignTokens == null) {
            prefsMap.put("format.vertical_align.tokens", "=,<=");
            return;
        }
        prefsMap.put("format.vertical_align.tokens", verticalAlignTokens);
    }

    private List<String> getLines(IDocument document, int line) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            if (document == null) {
                return lines;
            }
            String content = document.get();
            if (content == null) {
                return lines;
            }
            int nofLines = document.getNumberOfLines();
            if (line < nofLines) {
                IRegion lineInformation = document.getLineInformation(line);
                if (lineInformation == null) {
                    return lines;
                }
                int lineOffset = lineInformation.getOffset();
                int lineLength = lineInformation.getLength();
                lines.add(content.substring(lineOffset, lineOffset + lineLength));
            }
        }
        catch (BadLocationException e) {
            this.fOVMProject.notifyCheckException(this, (Exception)((Object)e));
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return lines;
    }

    private LinkedHashMap<Integer, DiffRow> getDiffRows(IDocument unformattedDocument, IDocument formattedDocument) {
        try {
            DiffRowGenerator generator = DiffRowGenerator.create().build();
            LinkedHashMap<Integer, DiffRow> diffRows = new LinkedHashMap<Integer, DiffRow>();
            int maxNofLines = Math.min(unformattedDocument.getNumberOfLines(), formattedDocument.getNumberOfLines());
            int line = 0;
            while (line < maxNofLines) {
                List rows = generator.generateDiffRows(this.getLines(unformattedDocument, line), this.getLines(formattedDocument, line));
                int i = 0;
                while (i < rows.size()) {
                    DiffRow row = (DiffRow)rows.get(i);
                    if (row != null && row.getTag() != DiffRow.Tag.EQUAL) {
                        diffRows.put(line + 1, row);
                    }
                    ++i;
                }
                if (diffRows.size() > 2) break;
                ++line;
            }
            return diffRows;
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new LinkedHashMap<Integer, DiffRow>();
        }
    }

    private String getDetails(LinkedHashMap<Integer, DiffRow> diffRows) {
        int counter = 0;
        StringBuilder details = new StringBuilder();
        Set<Integer> diffRowsIndexes = diffRows.keySet();
        if (diffRowsIndexes == null || diffRowsIndexes.isEmpty()) {
            return "";
        }
        for (Integer index : diffRowsIndexes) {
            DiffRow row = diffRows.get(index);
            if (row == null) continue;
            if (counter == 3) break;
            String unformattedLine = row.getOldLine();
            String formattedLine = row.getNewLine();
            if (unformattedLine == null || formattedLine == null) continue;
            if (unformattedLine.isEmpty()) {
                details.append("\nLine " + index + " is empty and it ");
            } else {
                details.append("\nLine " + index + ":\n");
                details.append(String.valueOf(unformattedLine) + "\n");
            }
            if (formattedLine.isEmpty()) {
                details.append("should be empty.\n");
            } else {
                details.append("should be:\n");
                details.append(String.valueOf(row.getNewLine()) + "\n");
            }
            ++counter;
        }
        details.append("...\n");
        return "Several lines in this file are not formatted correctly.\n" + details.toString();
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.cachedPreferencesInteger != null) {
            this.cachedPreferencesInteger.clear();
        }
        if (this.cachedPreferencesBoolean != null) {
            this.cachedPreferencesBoolean.clear();
        }
        if (this.cachedPreferencesString != null) {
            this.cachedPreferencesString.clear();
        }
    }

    private class VerrissimoVlogFormattingPreferences
    extends VlogFormattingPreferences {
        private Map<String, String> preferencesMap;

        public VerrissimoVlogFormattingPreferences() {
        }

        public VerrissimoVlogFormattingPreferences(Map<String, String> preferencesMap) {
            this.preferencesMap = preferencesMap;
            this.initAllNoIndentKeywordsPref();
            this.readNoIndentPref();
            this.initAllVRegExPref();
            this.readVRegExPref();
        }

        public String getStringProperty(String propertyID) {
            if (Check_SVTB_1_0.this.cachedPreferencesString.containsKey(propertyID)) {
                return Check_SVTB_1_0.this.cachedPreferencesString.get(propertyID);
            }
            String propertyValue = this.preferencesMap == null || !this.preferencesMap.containsKey(propertyID) ? this.getDefaultPlugin().getPreferenceStore().getDefaultString(propertyID) : this.preferencesMap.get(propertyID);
            if (!propertyID.equals("format.indent.no_indent_keywords") && !propertyID.equals("format.vertical_align.vregex")) {
                Check_SVTB_1_0.this.cachedPreferencesString.put(propertyID, propertyValue);
            }
            return propertyValue;
        }

        public boolean getBooleanProperty(String propertyID) {
            if (Check_SVTB_1_0.this.cachedPreferencesBoolean.containsKey(propertyID)) {
                return Check_SVTB_1_0.this.cachedPreferencesBoolean.get(propertyID);
            }
            boolean propertyValue = this.preferencesMap == null || !this.preferencesMap.containsKey(propertyID) ? this.getDefaultPlugin().getPreferenceStore().getDefaultBoolean(propertyID) : Boolean.parseBoolean(this.preferencesMap.get(propertyID));
            Check_SVTB_1_0.this.cachedPreferencesBoolean.put(propertyID, propertyValue);
            return propertyValue;
        }

        public int getIntegerProperty(String propertyID) {
            if (Check_SVTB_1_0.this.cachedPreferencesInteger.containsKey(propertyID)) {
                return Check_SVTB_1_0.this.cachedPreferencesInteger.get(propertyID);
            }
            int propertyValue = this.preferencesMap == null || !this.preferencesMap.containsKey(propertyID) ? this.getDefaultPlugin().getPreferenceStore().getDefaultInt(propertyID) : Integer.parseInt(this.preferencesMap.get(propertyID));
            Check_SVTB_1_0.this.cachedPreferencesInteger.put(propertyID, propertyValue);
            return propertyValue;
        }

        public boolean isUseSpacesForTabsEnabled() {
            return this.getBooleanProperty("spacesForTabs");
        }

        public Map<String, String> getVRefVSCodeToEclipse() {
            HashMap<String, String> res = new HashMap<String, String>();
            List prefs = this.getVRegExPref();
            for (CFVRegExBaseDefinition pref : prefs) {
                res.put(pref.getDescription(), pref.getName());
            }
            return res;
        }

        public int getTabWidth() {
            String editorTabWidth = "tabWidth";
            if (Check_SVTB_1_0.this.cachedPreferencesInteger.containsKey(editorTabWidth)) {
                return Check_SVTB_1_0.this.cachedPreferencesInteger.get(editorTabWidth);
            }
            int propertyValue = this.preferencesMap == null || !this.preferencesMap.containsKey(editorTabWidth) ? 4 : Integer.parseInt(this.preferencesMap.get(editorTabWidth));
            Check_SVTB_1_0.this.cachedPreferencesInteger.put(editorTabWidth, propertyValue);
            return propertyValue;
        }
    }
}

