/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.1.1.1")
@CheckName(value="SVTB.1.1.1")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Tab characters are not allowed")
@CheckDescription(value="Use spaces instead of tab. Every editor displays tabs differently - and with the spacing wrong your code will look horrible.\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", defaultValue="1"), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
@CheckAutofix(value=Autofix_SVTB_1_1_1.class)
public class Check_SVTB_1_1_1
extends AbstractSVTBSimpleIssues {
    @CheckParameter(defaultValue="false", description="When true tab characters in comments are skipped.", name="skipComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipComments;

    public Check_SVTB_1_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(25);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Tab character found!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBCharIssuesWithKind(new SVTBCharParser.Config(this.pSkipComments), 25, this);
    }
}

