/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntPredicate;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.Stack;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_10;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.svtb.MacroCall;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="18.1.21")
@CheckID(value="SVTB.1.1.10")
@CheckName(value="SVTB.1.1.10")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.OPERATOR})
@CheckTitle(value="Binary operators spacing")
@CheckDescription(value="Use space around binary operators.\n\nExamples:\nint a=b+c; // not allowed\nint a = b + c; // allowed\nint a   = b  +   c; // allowed iff allowMultipleSpaces is true\nint a = b\n      + c; // allowed iff allowIndentationOfMultilineOperators is true\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_10.class)
public class Check_SVTB_1_1_10
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="false", description="When true, indentation whitespace from start of line to operator is allowed when operators are split on multiple lines.", name="allowIndentationOfMultilineOperators", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowIndentationOfMultilineOperators;
    @CheckParameter(defaultValue="+,-,*,/,%,==,!=,===,!==,==?,!=?,&&,||,**,<,<=,>,>=,&,|,^,^~,~^,>>,<<,>>>,<<<,->,<->", description="Comma separated list of binary operators which are checked.", name="checkedOperators", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckedOperators;
    @CheckParameter(defaultValue="false", description="When true, allow multiple whitespaces around binary operators and report only when whitespace is missing.", name="allowMultipleSpaces", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowMultipleSpaces;
    private Set<WrongOperatorInfo> wrongOperators;
    private Set<Character> allOperatorCharacters;
    private Set<HidOperator> markedVisitedOperators = Collections.newSetFromMap(new IdentityHashMap());
    private static final int MAX_OPERATOR_LENGTH = 3;

    public Check_SVTB_1_1_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.wrongOperators = new HashSet<WrongOperatorInfo>();
        this.allOperatorCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('^'), Character.valueOf('~'), Character.valueOf('<'), Character.valueOf('>')));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void performCheckImpl() {
        block33: {
            excVisitor = new SetIsWithinRangeOrSelectQualifierOperatorVisitor();
            this.fOVMProject.getRfProject().visitHidObject(null, excVisitor);
            visitor = new LocalHidOperatorVisitor();
            this.fOVMProject.getRfProject().visitHidObject(null, visitor);
            operatorsMap = visitor.getOperators();
            try {
                this.wrongOperators.clear();
                for (Map.Entry<ParserPath, List<RfHidOperator>> entry : operatorsMap.entrySet()) {
                    this.notifyCheckAlive();
                    parserPath = entry.getKey();
                    operators = entry.getValue();
                    if (operators == null || operators.isEmpty()) continue;
                    Collections.sort(operators, new HidOperatorOccurrenceComparator());
                    macroCalls = new HashSet<MacroCall>();
lbl17:
                    // 8 sources

                    for (RfHidOperator operator : operators) {
                        block32: {
                            operatorOccurrence = operator.getOccurrence();
                            reparseInfo = (ReparseInfo)operatorOccurrence.getReparseInfo(ReparseInfo.class);
                            if (reparseInfo == null) ** GOTO lbl42
                            if (operator.hasQualifier(HidQualifierCache.IS_WITHIN_RANGE_OR_SELECT_QUALIFIER)) {
                                operator.removeQualifier(HidQualifierCache.IS_WITHIN_RANGE_OR_SELECT_QUALIFIER);
                                this.markedVisitedOperators.remove(operator);
                            }
                            if (macroCalls.contains(currentMacroCall = new MacroCall(reparseInfo.getLastReparseMacroName(), operatorOccurrence.getLine(), operatorOccurrence.getOffset()))) continue;
                            macroCalls.add(currentMacroCall);
                            reparseElements = reparseInfo.getReparseStack();
                            if (reparseElements != null && reparseElements.length != 0) break block32;
                            var35_38 = this.markedVisitedOperators.iterator();
                            if (true) ** GOTO lbl67
                        }
                        params = reparseElements[0].getReparseMacroParams();
                        v0 = hasParams = params != null && params.length > 0;
                        if (!hasParams) continue;
                        operatorOffset = operatorOccurrence.getOffset();
                        token = this.getWSParser().getToken(operatorOffset, parserPath);
                        if (token == null) {
                            continue;
                        }
                        ** GOTO lbl71
lbl42:
                        // 1 sources

                        operatorOffset = operatorOccurrence.getOffset();
                        operatorText = operator.getOperatorText();
                        token = this.getWSParser().getToken(operatorOffset, parserPath);
                        isOperatorInsideToken = token == null;
                        v1 = token = token == null ? this.getWSParser().getTokenContainingOffset(operatorOffset, parserPath) : token;
                        if (token == null) continue;
                        operatorOffsetOnLine = this.getOffsetOnLine(token, isOperatorInsideToken, operatorOffset);
                        this.checkWrongOperator(token, operator, isOperatorInsideToken, operatorOffset, operatorOffsetOnLine, operatorText, parserPath);
                    }
                }
            }
            catch (Throwable var33_44) {
                var35_40 = this.markedVisitedOperators.iterator();
                if (true) ** GOTO lbl149
            }
            {
                catch (Exception e) {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    var35_39 = this.markedVisitedOperators.iterator();
                    if (true) ** GOTO lbl143
                    break;
                }
            }
            var35_39 = this.markedVisitedOperators.iterator();
            if (true) ** GOTO lbl155
            do {
                markedOpi = var35_38.next();
                markedOpi.removeQualifier(HidQualifierCache.IS_WITHIN_RANGE_OR_SELECT_QUALIFIER);
lbl67:
                // 2 sources

            } while (var35_38.hasNext());
            this.markedVisitedOperators.clear();
            return;
lbl-1000:
            // 1 sources

            {
                token = this.getWSParser().getNextCodeToken(token, parserPath);
lbl71:
                // 2 sources

                ** while (token != null && !token.getStringToken().contains((CharSequence)"(") && token.getZone() == SVTBWhitespaceParser.ZoneType.CODE)
            }
lbl72:
            // 1 sources

            if (token == null) ** GOTO lbl17
            squareParanthesisOpen = 0;
            openSquareParanthesisPositions = new ArrayList<Integer>();
            closedSquareParanthesisPositions = new ArrayList<Integer>();
            roundParanthesis = 0;
            do {
                stringToken = token.getStringToken();
                squareBrackets = new Stack();
                i = 0;
                while (i < stringToken.length()) {
                    if (stringToken.charAt(i) == '[') {
                        squareBrackets.add((Object)i);
                    }
                    if (stringToken.charAt(i) == ']') {
                        if (squareBrackets.isEmpty()) {
                            --squareParanthesisOpen;
                            openSquareParanthesisPositions.add(-1);
                        } else {
                            openSquareParanthesisPositions.add((Integer)squareBrackets.pop());
                        }
                        closedSquareParanthesisPositions.add(i);
                    }
                    ++i;
                }
                while (!squareBrackets.isEmpty()) {
                    ++squareParanthesisOpen;
                    openSquareParanthesisPositions.add((Integer)squareBrackets.pop());
                    closedSquareParanthesisPositions.add(-1);
                }
                left = 0;
                right = 1;
                while (left < stringToken.length()) {
                    if (this.allOperatorCharacters.contains(Character.valueOf(stringToken.charAt(left)))) ** GOTO lbl111
                    right = ++left + 1;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        ++right;
lbl111:
                        // 2 sources

                        ** while (right < stringToken.length() && right - left < 3 && this.allOperatorCharacters.contains((Object)Character.valueOf((char)stringToken.charAt((int)right))))
                    }
lbl112:
                    // 1 sources

                    operatorString = stringToken.substring(left, right);
                    if (this.pCheckedOperators.contains(operatorString)) {
                        isOperatorInsideToken = stringToken.equals(operatorString) == false;
                        insideSquareParanthesis = false;
                        if (squareParanthesisOpen > 0) {
                            insideSquareParanthesis = true;
                        }
                        i = 0;
                        while (i < openSquareParanthesisPositions.size() && !insideSquareParanthesis) {
                            openIndex = (Integer)openSquareParanthesisPositions.get(i);
                            closedIndex = (Integer)closedSquareParanthesisPositions.get(i);
                            if (openIndex == -1 && left < closedIndex || closedIndex == -1 && left > openIndex || openIndex != -1 && closedIndex != -1 && left > openIndex && left < closedIndex) {
                                insideSquareParanthesis = true;
                            }
                            ++i;
                        }
                        if (!insideSquareParanthesis) {
                            this.checkWrongOperator(token, operator, isOperatorInsideToken, token.getOffsetFile() + left, token.getOffsetLine() + left, operatorString, parserPath);
                        }
                    }
                    left = right + 1;
                    right = left + 1;
                }
                if (stringToken.contains("(")) {
                    count = stringToken.chars().filter((IntPredicate)LambdaMetafactory.metafactory(null, null, null, (I)Z, lambda$0(int ), (I)Z)()).count();
                    roundParanthesis = (int)((long)roundParanthesis + count);
                }
                if (stringToken.contains(")")) {
                    count = stringToken.chars().filter((IntPredicate)LambdaMetafactory.metafactory(null, null, null, (I)Z, lambda$1(int ), (I)Z)()).count();
                    roundParanthesis = (int)((long)roundParanthesis - count);
                }
                token = this.getWSParser().getNextCodeToken(token, parserPath);
            } while (roundParanthesis != 0 && token != null);
            ** GOTO lbl17
            do {
                markedOpi = var35_39.next();
                markedOpi.removeQualifier(HidQualifierCache.IS_WITHIN_RANGE_OR_SELECT_QUALIFIER);
lbl143:
                // 2 sources

            } while (var35_39.hasNext());
            this.markedVisitedOperators.clear();
            break block33;
            do {
                markedOpi = var35_40.next();
                markedOpi.removeQualifier(HidQualifierCache.IS_WITHIN_RANGE_OR_SELECT_QUALIFIER);
lbl149:
                // 2 sources

            } while (var35_40.hasNext());
            this.markedVisitedOperators.clear();
            throw var33_44;
            do {
                markedOpi = var35_39.next();
                markedOpi.removeQualifier(HidQualifierCache.IS_WITHIN_RANGE_OR_SELECT_QUALIFIER);
lbl155:
                // 2 sources

            } while (var35_39.hasNext());
            this.markedVisitedOperators.clear();
        }
        if (this.wrongOperators == null) {
            return;
        }
        for (WrongOperatorInfo wrongOperator : this.wrongOperators) {
            operatorOffset = wrongOperator.lineOffset;
            hitMessage = new StringBuilder("Wrong spacing around operator '");
            hitMessage.append(wrongOperator.operatorText);
            hitMessage.append("' at line offset " + Integer.toString(operatorOffset) + "!");
            this.addHit(wrongOperator.parserPath, (HidOccurrence)wrongOperator.operator.getOccurrence(), hitMessage.toString(), new VerissimoAutofixAdditionalInfo(wrongOperator));
        }
    }

    void checkWrongOperator(LiteralToken token, RfHidOperator operator, boolean isOperatorInsideToken, int fileOffset, int operatorOffsetOnLine, String operatorText, ParserPath parserPath) {
        boolean isHit;
        if (operator.hasQualifier(HidQualifierCache.IS_WITHIN_RANGE_OR_SELECT_QUALIFIER)) {
            operator.removeQualifier(HidQualifierCache.IS_WITHIN_RANGE_OR_SELECT_QUALIFIER);
            this.markedVisitedOperators.remove(operator);
            boolean isBeforeHit = this.isBeforeHitInRangeVector(token, isOperatorInsideToken);
            boolean isAfterHit = this.isAfterHitInRangeVector(token, operatorText);
            if (isBeforeHit || isAfterHit) {
                this.wrongOperators.add(new WrongOperatorInfo(operator, parserPath, fileOffset, operatorOffsetOnLine, operatorText));
            }
            return;
        }
        boolean isBeforeOperatorHit = this.isBeforeOperatorHit(token, isOperatorInsideToken);
        boolean isAfterOperatorHit = this.isAfterOperatorHit(token, operatorText);
        boolean bl = isHit = isBeforeOperatorHit || isAfterOperatorHit;
        if (!isHit) {
            return;
        }
        if (!this.pAllowIndentationOfMultilineOperators) {
            this.wrongOperators.add(new WrongOperatorInfo(operator, parserPath, fileOffset, operatorOffsetOnLine, operatorText));
            return;
        }
        if (isBeforeOperatorHit) {
            isBeforeOperatorHit = this.isBeforeOperatorHitMultilineCase(token, isOperatorInsideToken);
        }
        if (!isAfterOperatorHit && !isBeforeOperatorHit) {
            return;
        }
        if (isAfterOperatorHit) {
            isAfterOperatorHit = this.isAfterOperatorHitMultilineCase(token, operatorText);
        }
        if (!isBeforeOperatorHit && !isAfterOperatorHit) {
            return;
        }
        this.wrongOperators.add(new WrongOperatorInfo(operator, parserPath, fileOffset, operatorOffsetOnLine, operatorText));
    }

    private int getOffsetOnLine(LiteralToken token, boolean isOperatorInsideToken, int operatorOffset) {
        if (!isOperatorInsideToken) {
            return token.getOffsetLine();
        }
        if (token == null) {
            return -1;
        }
        return token.getOffsetLine() + operatorOffset - token.getOffsetFile();
    }

    private boolean isBeforeHitInRangeVector(LiteralToken token, boolean isOperatorInsideToken) {
        if (isOperatorInsideToken) {
            return false;
        }
        int whitespacesBefore = token.getNoSpacesBefore();
        return !this.pAllowMultipleSpaces && whitespacesBefore > 1;
    }

    private boolean isAfterHitInRangeVector(LiteralToken token, String operatorText) {
        if (token == null) {
            return false;
        }
        if (!token.getStringToken().endsWith(operatorText)) {
            return false;
        }
        int whitespacesAfter = token.getNoSpacesAfter();
        return !this.pAllowMultipleSpaces && whitespacesAfter > 1;
    }

    private boolean isBeforeOperatorHit(LiteralToken token, boolean isOperatorInsideToken) {
        if (isOperatorInsideToken) {
            return true;
        }
        int whitespacesBefore = token.getNoSpacesBefore();
        if (this.pAllowMultipleSpaces && whitespacesBefore == 0 && token.getNoTabsBefore() == 0) {
            return true;
        }
        if (!(this.pAllowMultipleSpaces || whitespacesBefore == 1 && token.getNoTabsBefore() <= 0)) {
            return true;
        }
        return !this.pAllowIndentationOfMultilineOperators && (token.isFirstTokenOnLine() || token.isLastTokenOnLine());
    }

    private boolean isAfterOperatorHit(LiteralToken token, String operatorText) {
        if (token == null) {
            return true;
        }
        if (!token.getStringToken().endsWith(operatorText)) {
            return true;
        }
        int whitespacesAfter = token.getNoSpacesAfter();
        if (this.pAllowMultipleSpaces && whitespacesAfter == 0 && token.getNoTabsAfter() == 0) {
            return true;
        }
        if (!(this.pAllowMultipleSpaces || whitespacesAfter == 1 && token.getNoTabsAfter() <= 0)) {
            return true;
        }
        return !this.pAllowIndentationOfMultilineOperators && (token.isFirstTokenOnLine() || token.isLastTokenOnLine());
    }

    private boolean isAfterOperatorHitMultilineCase(LiteralToken token, String operatorText) {
        if (token == null) {
            return true;
        }
        if (!token.getStringToken().endsWith(operatorText)) {
            return true;
        }
        int whitespacesAfter = token.getNoSpacesAfter();
        if (!token.isLastTokenOnLine()) {
            return true;
        }
        if (!this.pAllowMultipleSpaces) {
            return whitespacesAfter > 1;
        }
        return false;
    }

    private boolean isBeforeOperatorHitMultilineCase(LiteralToken token, boolean isOperatorInsideToken) {
        if (isOperatorInsideToken) {
            return true;
        }
        return !token.isFirstTokenOnLine();
    }

    @Override
    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof WrongOperatorInfo)) {
            return null;
        }
        return ((WrongOperatorInfo)element).markedOperatorToString;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static /* synthetic */ boolean lambda$0(int ch) {
        return ch == 40;
    }

    private static /* synthetic */ boolean lambda$1(int ch) {
        return ch == 41;
    }

    private static final class HidOperatorOccurrenceComparator
    implements Comparator<RfHidOperator> {
        private HidOperatorOccurrenceComparator() {
        }

        @Override
        public int compare(RfHidOperator op1, RfHidOperator op2) {
            HidOperatorOccurrence o1 = op1.getOccurrence();
            HidOperatorOccurrence o2 = op2.getOccurrence();
            if (Integer.compare(o1.getOffset(), o2.getOffset()) == 0) {
                return Integer.compare(o1.getVirtualOffset(), o2.getVirtualOffset());
            }
            return Integer.compare(o1.getOffset(), o2.getOffset());
        }
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;
        private Map<ParserPath, List<RfHidOperator>> binaryOperators = new HashMap<ParserPath, List<RfHidOperator>>();

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Map<ParserPath, List<RfHidOperator>> getOperators() {
            return this.binaryOperators;
        }

        public boolean visit(RfHidOperator operator) {
            if (Check_SVTB_1_1_10.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (operator.getOperatorText() == null) {
                return true;
            }
            if (operator.isHidden()) {
                return true;
            }
            if (!Check_SVTB_1_1_10.this.pCheckedOperators.contains(operator.getOperatorText())) {
                return true;
            }
            if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                return true;
            }
            if (operator.getOperatorType() == IHidOperatorConstants.OperatorType.CASE_ITEM_CONDITION.id) {
                return true;
            }
            List<RfHidOperator> operators = this.binaryOperators.get(this.parserPath);
            if (operators == null) {
                operators = new ArrayList<RfHidOperator>();
                this.binaryOperators.put(this.parserPath, operators);
            }
            operators.add(operator);
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    public class SetIsWithinRangeOrSelectQualifierOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        public boolean visit(RfHidOperator operator) {
            if (Check_SVTB_1_1_10.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!operator.isRangeOrPartSelect()) {
                return true;
            }
            Set flattenToOperators = HidUtils.flattenToOperators((IHidOperator)operator);
            if (flattenToOperators == null) {
                return true;
            }
            for (IHidOperator flatten : flattenToOperators) {
                if (!(flatten instanceof HidOperator)) continue;
                HidOperator opi = (HidOperator)flatten;
                opi.addQualifier(HidQualifierCache.IS_WITHIN_RANGE_OR_SELECT_QUALIFIER);
                Check_SVTB_1_1_10.this.markedVisitedOperators.add(opi);
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    public static class WrongOperatorInfo {
        private RfHidOperator operator;
        private ParserPath parserPath;
        private String operatorToString;
        private String markedOperatorToString;
        private int fileOffset;
        private int lineOffset;
        private String operatorText;

        public WrongOperatorInfo(RfHidOperator operator, ParserPath parserPath, int fileOffset, int lineOffset, String operatorText) {
            this.operator = operator;
            this.parserPath = parserPath;
            this.fileOffset = fileOffset;
            this.lineOffset = lineOffset;
            this.operatorText = operatorText;
        }

        public WrongOperatorInfo(RfHidOperator operator, ParserPath parserPath, String operatorToString, int fileOffset, int lineOffset, String operatorText) {
            this.operator = operator;
            this.parserPath = parserPath;
            this.operatorToString = operatorToString;
            this.fileOffset = fileOffset;
            this.lineOffset = lineOffset;
            this.operatorText = operatorText;
        }

        public WrongOperatorInfo(RfHidOperator operator, ParserPath parserPath, String operatorToString, String markedOperatorToString, int fileOffset, int lineOffset, String operatorText) {
            this.operator = operator;
            this.parserPath = parserPath;
            this.operatorToString = operatorToString;
            this.markedOperatorToString = markedOperatorToString;
            this.fileOffset = fileOffset;
            this.lineOffset = lineOffset;
            this.operatorText = operatorText;
        }

        public RfHidOperator getOperator() {
            return this.operator;
        }

        public String getOperatorText() {
            return this.operatorText;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }

        public String getOperatorToString() {
            return this.operatorToString;
        }

        public String getMarkedOperatorToString() {
            return this.markedOperatorToString;
        }

        public int getLineOffset() {
            return this.lineOffset;
        }

        public void setOperatorToString(String operatorToString) {
            this.operatorToString = operatorToString;
        }

        public void setMarkedOperatorToString(String markedOperatorToString) {
            this.markedOperatorToString = markedOperatorToString;
        }

        public int getFileOffset() {
            return this.fileOffset;
        }
    }
}

