/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_11;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

@CheckVersion(value="18.1.22")
@CheckID(value="SVTB.1.1.11")
@CheckName(value="SVTB.1.1.11")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Space after comma")
@CheckDescription(value="Use space after comma.\nExamples:\n\nboo(a, b, c); // allowed\nmoo = {a, b, c}; // allowed\n\nboo(a,b,c); // not allowed\nmoo = {a,b,c}; // not allowed\n\nstring too = \"1,885\" // allowed\nint \\my,escaped,string  = 2; // allowed\nboo( foo,\n  moo,\n  doo); // allowed\n\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_11.class)
public class Check_SVTB_1_1_11
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="false", description="When true, don't check inside macros.", name="skipMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipMacros;
    @CheckParameter(defaultValue="false", description="When true, don't check inside inactive macros.", name="skipInactiveMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipInactiveMacros;
    @CheckParameter(defaultValue="false", description="When true, commas that are the first character on a line are ignored.", name="skipFirstCharacterCommas", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipFirstCharacterCommas;
    private static final String IFDEF = "ifdef";
    private static final String IFNDEF = "ifndef";
    private static final String ELSE = "else";
    private static final String ENDIF = "endif";

    public Check_SVTB_1_1_11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        if (files == null || files.isEmpty()) {
            return;
        }
        for (ParserPath file : files) {
            try {
                RfFileDef filedef;
                if (file.path.indexOf("__vlog__") != -1 || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(file)) == null) continue;
                this.notifyCheckAlive();
                TreeMap<Integer, Integer> macroStartEndOffsets = new TreeMap<Integer, Integer>();
                List<VlogMacroInfo> allMacros = this.fOVMProject.getRfProject().getAllMacros(file);
                for (VlogMacroInfo macro : allMacros) {
                    List<VlogMacroInfo> layers = macro.getMacroZoneLayers();
                    if (layers == null) continue;
                    for (VlogMacroInfo layer : layers) {
                        macroStartEndOffsets.put(layer.getRealOffset(), layer.getEndRealOffset());
                    }
                }
                Map<Integer, Integer> inactiveOffsetIntervals = null;
                if (this.pSkipInactiveMacros) {
                    inactiveOffsetIntervals = this.getInactiveOffsetIntervals(file);
                }
                boolean insideInactiveMacroDefinition = false;
                Throwable throwable = null;
                Object var10_13 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(file.path));){
                    int c;
                    char previousChar = '\u0000';
                    boolean isMultiLineComment = false;
                    boolean isSingleLineComment = false;
                    int currentLine = 1;
                    boolean insideEscapedIdentifier = false;
                    boolean insideStringConstant = false;
                    boolean insideMacroDefinition = false;
                    boolean isFirstCommaCharOnLine = false;
                    int offset = 0;
                    int fileOffset = 0;
                    char currentChar = (char)reader.read();
                    while ((c = reader.read()) != -1) {
                        LiteralToken token;
                        boolean isInsideCode;
                        previousChar = currentChar;
                        currentChar = (char)c;
                        ++offset;
                        ++fileOffset;
                        if (previousChar == '\n' || previousChar == '\r' && currentChar != '\n') {
                            if (insideInactiveMacroDefinition) {
                                for (LiteralToken token2 : this.getWSParser().getTokensOnLine(file, currentLine)) {
                                    if (!token2.isLastTokenOnLine() || token2.getStringToken().endsWith("\\")) continue;
                                    insideInactiveMacroDefinition = false;
                                    break;
                                }
                            }
                            ++currentLine;
                            offset = 0;
                            if (this.pSkipFirstCharacterCommas) {
                                isFirstCommaCharOnLine = false;
                            }
                        }
                        boolean bl = isInsideCode = !isSingleLineComment && !isMultiLineComment && !insideEscapedIdentifier && !insideStringConstant && !insideMacroDefinition && !insideInactiveMacroDefinition;
                        if (!isFirstCommaCharOnLine && isInsideCode && previousChar == ',' && currentChar != ' ' && currentChar != '\n' && currentChar != '\r') {
                            this.addHit(file, currentLine, "No space after comma at line offset " + offset + "!", null, new VerissimoAutofixAdditionalInfo(offset));
                        }
                        if (isInsideCode && previousChar == '/' && currentChar == '*') {
                            isMultiLineComment = true;
                            continue;
                        }
                        if (isMultiLineComment && previousChar == '*' && currentChar == '/') {
                            isMultiLineComment = false;
                            continue;
                        }
                        if (isInsideCode && currentChar == '\\') {
                            insideEscapedIdentifier = true;
                            continue;
                        }
                        if (insideEscapedIdentifier && Character.isWhitespace(currentChar)) {
                            insideEscapedIdentifier = false;
                            continue;
                        }
                        if (isInsideCode && currentChar == '\"') {
                            insideStringConstant = true;
                            continue;
                        }
                        if (insideStringConstant && previousChar != '\\' && currentChar == '\"') {
                            insideStringConstant = false;
                            continue;
                        }
                        if (isInsideCode && previousChar == '/' && currentChar == '/') {
                            isSingleLineComment = true;
                            continue;
                        }
                        if (isSingleLineComment && currentChar == '\n') {
                            isSingleLineComment = false;
                            continue;
                        }
                        if (this.pSkipInactiveMacros) {
                            if (!this.isInsideInactive(inactiveOffsetIntervals, fileOffset)) {
                                insideInactiveMacroDefinition = false;
                            } else if (!insideInactiveMacroDefinition && (token = this.getWSParser().getToken(fileOffset, file)) != null && token.getZone() == SVTBWhitespaceParser.ZoneType.CODE && token.getStringToken().endsWith("`define")) {
                                insideInactiveMacroDefinition = true;
                            }
                        }
                        if (this.pSkipMacros) {
                            Map.Entry macroOffsets = macroStartEndOffsets.floorEntry(fileOffset);
                            if (macroOffsets == null) {
                                insideMacroDefinition = false;
                                continue;
                            }
                            if (fileOffset < (Integer)macroOffsets.getValue()) {
                                insideMacroDefinition = true;
                                continue;
                            }
                            if (fileOffset > (Integer)macroOffsets.getValue()) {
                                insideMacroDefinition = false;
                                continue;
                            }
                        }
                        if (!this.pSkipFirstCharacterCommas || currentChar != ',' || (token = this.getWSParser().getTokenContainingOffset(fileOffset, file)) == null || !token.isFirstTokenOnLine() || !token.getStringToken().startsWith(",")) continue;
                        isFirstCommaCharOnLine = true;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private boolean isInsideInactive(Map<Integer, Integer> inactiveOffsetIntervals, int offset) {
        if (inactiveOffsetIntervals == null || inactiveOffsetIntervals.isEmpty()) {
            return false;
        }
        for (Map.Entry<Integer, Integer> interval : inactiveOffsetIntervals.entrySet()) {
            if (offset <= interval.getKey() || offset >= interval.getValue()) continue;
            return true;
        }
        return false;
    }

    private Map<Integer, Integer> getInactiveOffsetIntervals(ParserPath path) {
        CodePreprocFileInfo preprocInfo = this.fOVMProject.getRfProject().getPreprocessingTable().getCodePreprocFileInfos().get(path);
        if (preprocInfo == null) {
            return null;
        }
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        TreeSet<Integer> lines = preprocInfo.getLines();
        if (lines == null) {
            return null;
        }
        int lastOffSet = -1;
        for (Integer line : lines) {
            CodePreprocLineInfo info = preprocInfo.getInfo(line);
            if (info == null) continue;
            int lineInfo = info.getLine();
            for (LiteralToken token : this.getWSParser().getTokensOnLine(path, lineInfo)) {
                if (token.getLineNumber() != lineInfo || !token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE)) continue;
                String directive = token.getStringToken();
                if (info.getType() == 1 && (directive.contains(IFDEF) || directive.contains(IFNDEF))) {
                    lastOffSet = token.getOffsetFile();
                }
                if (!directive.contains(ENDIF) || lastOffSet == -1) continue;
                result.put(lastOffSet, token.getOffsetFile());
                lastOffSet = -1;
            }
        }
        return result;
    }
}

