/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_12;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedGate;

@CheckVersion(value="18.1.24")
@CheckID(value="SVTB.1.1.12")
@CheckName(value="SVTB.1.1.12")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.ARRAY})
@CheckTitle(value="Packed and unpacked dimensions formatting")
@CheckDescription(value="This rule checks the following:\n1) There is space between packed dimensions and type/identifier.\n2) There is no space between identifier and unpacked dimensions.\n3) There is no space between multiple dimensions.\n\nExamples:\n\nlogic var3[31:0][2:0]; // allowed\nlogic var4[31:0] [2:0]; // not allowed\noutput logic [2:0] a; // allowed\noutput logic [2:0]b; // not allowed\noutput logic [2:0][2:0] c; // allowed\noutput logic [2:0] d [3:0]; // not allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_12.class)
public class Check_SVTB_1_1_12
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="false", description="When true, there can be a space between the identifier and unpacked dimensions for multiple consecutive declarations.", name="skipConsecutiveUnpackedDimensions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipConsecutiveUnpackedDimensions;
    @CheckParameter(defaultValue="false", description="When true, packed and unpacked dimensions of typedefs are also checked.", name="checkTypedefs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckTypedefs;
    @CheckParameter(defaultValue="true", description="When false, checks there is no space between packed dimensions and type/identifier.", name="allowSpaceBetweenPackedDimensionAndType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowSpaceBetweenPackedDimensionAndType;
    private static final char SEMI_COLON = ';';
    private static final char EQUAL = '=';
    private static final char COMMA = ',';
    private static final char LEFT_PARAM = '[';
    private static final char RIGHT_PARAM = ']';

    public Check_SVTB_1_1_12(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        LocalDefVisitor visitor = new LocalDefVisitor(this);
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        try {
            rfProject.accept(visitor);
            Map<ParserPath, Map<RfDefElement, PackedUnpackedDimensionFieldInformation>> listDefTypeMap = visitor.getListTypeMap();
            if (listDefTypeMap == null || listDefTypeMap.isEmpty()) {
                return;
            }
            for (Map.Entry<ParserPath, Map<RfDefElement, PackedUnpackedDimensionFieldInformation>> listDefTypeEntry : listDefTypeMap.entrySet()) {
                this.notifyCheckAlive();
                ParserPath parserPath = listDefTypeEntry.getKey();
                Map<RfDefElement, PackedUnpackedDimensionFieldInformation> listDefTypePathMap = listDefTypeEntry.getValue();
                if (listDefTypePathMap == null || listDefTypePathMap.isEmpty()) continue;
                String fileContent = new String(Files.readAllBytes(Paths.get(parserPath.path, new String[0])));
                for (Map.Entry<RfDefElement, PackedUnpackedDimensionFieldInformation> listFieldDefTypePathEntry : listDefTypePathMap.entrySet()) {
                    RfDefElement defElement = listFieldDefTypePathEntry.getKey();
                    PackedUnpackedDimensionFieldInformation defInfo = listFieldDefTypePathEntry.getValue();
                    int startOffset = defElement.getStartOffset();
                    if (startOffset < 0) continue;
                    int currentOffset = startOffset;
                    if (defElement instanceof RfFunctionDef) {
                        RfNamedElement functionNamedElement = defElement.getNamedElement();
                        if (((RfFunctionDef)defElement).isOutOfClassDefinition() && (currentOffset = this.goToFunctionNameOffset(currentOffset, fileContent, functionNamedElement)) == -1) continue;
                        String functionName = functionNamedElement.getName();
                        int indexOf = functionName.indexOf(".");
                        if (indexOf != -1) {
                            int i = currentOffset - 1;
                            while (i >= 0) {
                                if (!Character.isWhitespace(fileContent.charAt(i))) {
                                    if (fileContent.charAt(i) != functionName.charAt(indexOf)) break;
                                    if (--indexOf == -1) {
                                        currentOffset = i;
                                        break;
                                    }
                                }
                                --i;
                            }
                            if (indexOf != -1) continue;
                        }
                    }
                    if (defElement instanceof RfInstanceDef) {
                        DataType type = ((RfInstanceDef)defElement).getDataType(defElement.getNamedElement());
                        if (type != null && !RfPredefinedGate.PREDEFINED_GATES.containsKey(type.getType())) {
                            currentOffset = Check_SVTB_1_1_12.goToInstanceNameOffset(currentOffset, fileContent, defElement.getEndOffset());
                        }
                        if (currentOffset == -1) continue;
                    }
                    int unpackedOffset = currentOffset + defElement.getName().length();
                    int packedOffset = currentOffset - 1;
                    if (unpackedOffset >= fileContent.length() || packedOffset < 0) continue;
                    char unpackedChar = fileContent.charAt(unpackedOffset);
                    char packedChar = fileContent.charAt(packedOffset);
                    String packedDimension = defInfo.getPackedDimension();
                    String unpackedDimension = defInfo.getUnpackedDimension();
                    DataType dataType = defElement.getDataType(defElement.getNamedElement());
                    if (defElement instanceof RfFunctionDef) {
                        dataType = ((RfFunctionDef)defElement).getTypeInfo(defElement.getNamedElement());
                    }
                    if (dataType == null) continue;
                    boolean hasPackedDimension = dataType.getPackedDimension() != null && !dataType.getPackedDimension().isEmpty();
                    boolean hasUnpackedDimension = dataType.getUnpackedDimension() != null && !dataType.getUnpackedDimension().isEmpty();
                    boolean isUnpackedDimensionFormattingOk = true;
                    boolean isPackedDimensionFormattingOk = true;
                    if (hasUnpackedDimension && unpackedDimension != null) {
                        int nOfUnpackedDimensions = 0;
                        nOfUnpackedDimensions = this.getNofDimensions(unpackedDimension);
                        if (nOfUnpackedDimensions == 1) {
                            if (unpackedChar != '[') {
                                isUnpackedDimensionFormattingOk = false;
                            }
                        } else if (nOfUnpackedDimensions != 0) {
                            int countedUnpackedDimensions = 0;
                            while (unpackedOffset < fileContent.length()) {
                                unpackedChar = fileContent.charAt(unpackedOffset);
                                if (unpackedChar != '[' && countedUnpackedDimensions < nOfUnpackedDimensions) {
                                    isUnpackedDimensionFormattingOk = false;
                                    break;
                                }
                                if (unpackedChar == ';' || unpackedChar == ',' || unpackedChar == '=') break;
                                if (unpackedChar == '[') {
                                    int rightBracket;
                                    ++countedUnpackedDimensions;
                                    unpackedOffset = rightBracket = this.getMatchingRightBracketOffset(fileContent, unpackedOffset, fileContent.length() - 1);
                                    ++unpackedOffset;
                                    continue;
                                }
                                ++unpackedOffset;
                            }
                        }
                    }
                    if (hasPackedDimension && packedDimension != null) {
                        int nOfPackedDimensions = this.getNofDimensions(packedDimension);
                        boolean shouldCheckPackedDimensionForField = true;
                        List<IndexType> packedDimensions = dataType.getPackedDimension();
                        if (defElement instanceof RfFieldDef && packedDimensions != null && !packedDimensions.isEmpty()) {
                            int dimensionsEndOffset = -1;
                            int[] endBoundaries = packedDimensions.get(packedDimensions.size() - 1).getBoundaries();
                            if (endBoundaries != null) {
                                dimensionsEndOffset = endBoundaries[1];
                            }
                            int prevNonWhitespaceOffset = this.getPrevNonWhitespaceOffset(packedOffset, fileContent, dimensionsEndOffset - 1);
                            char firstNonWhiteSpaceChar = fileContent.charAt(prevNonWhitespaceOffset);
                            if (prevNonWhitespaceOffset != dimensionsEndOffset - 1 && firstNonWhiteSpaceChar != ']') {
                                shouldCheckPackedDimensionForField = false;
                            }
                        }
                        boolean isInsideParens = false;
                        boolean isSingleSpace = false;
                        int countedPackedDimensions = 0;
                        if (shouldCheckPackedDimensionForField) {
                            while (packedOffset >= 0) {
                                packedChar = fileContent.charAt(packedOffset);
                                if (!isInsideParens && countedPackedDimensions == nOfPackedDimensions) {
                                    if ((!this.pAllowSpaceBetweenPackedDimensionAndType || Character.isWhitespace(packedChar)) && (this.pAllowSpaceBetweenPackedDimensionAndType || !Character.isWhitespace(packedChar))) break;
                                    isPackedDimensionFormattingOk = false;
                                    break;
                                }
                                if (countedPackedDimensions == 0 && !isInsideParens && packedChar == ',') break;
                                if (packedOffset == currentOffset - 1) {
                                    if (Character.isWhitespace(packedChar)) {
                                        isSingleSpace = true;
                                        --packedOffset;
                                        continue;
                                    }
                                    isPackedDimensionFormattingOk = false;
                                    break;
                                }
                                if (!isInsideParens && packedChar == ']' && isSingleSpace) {
                                    isInsideParens = true;
                                    ++countedPackedDimensions;
                                    --packedOffset;
                                    continue;
                                }
                                if (!isInsideParens && !Character.isWhitespace(packedChar) && countedPackedDimensions == 0) {
                                    isPackedDimensionFormattingOk = false;
                                    break;
                                }
                                if (!isInsideParens && countedPackedDimensions != 0 && packedChar != ']') {
                                    isPackedDimensionFormattingOk = false;
                                    break;
                                }
                                if (isInsideParens && packedChar == '[') {
                                    isInsideParens = false;
                                    --packedOffset;
                                    continue;
                                }
                                --packedOffset;
                            }
                        }
                    }
                    String defElementTypeName = LintUtils.getElementKind(defElement.getNamedElement());
                    if (!isUnpackedDimensionFormattingOk && !this.skipUnpackedDimension(defElement)) {
                        this.addHit(parserPath, defElement.getStartLine(), "The " + defElementTypeName + " '" + LintUtils.getNamedElementFullName(defElement.getNamedElement()) + "' has incorrect unpacked dimension formatting!", null, new VerissimoAutofixAdditionalInfo(defElement));
                    }
                    if (isPackedDimensionFormattingOk) continue;
                    this.addHit(parserPath, defElement.getStartLine(), "The " + defElementTypeName + " '" + LintUtils.getNamedElementFullName(defElement.getNamedElement()) + "' has incorrect packed dimension formatting!", null, new VerissimoAutofixAdditionalInfo(defElement));
                }
            }
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean skipUnpackedDimension(RfDefElement defElement) {
        if (!this.pSkipConsecutiveUnpackedDimensions) {
            return false;
        }
        if (defElement instanceof RfPortDef) {
            RfPortDef portDef = (RfPortDef)defElement;
            RfNamedElement element = portDef.getNamedElement();
            if (!(element instanceof RfPort)) {
                return false;
            }
            RfPort port = (RfPort)element;
            RfNamedElement scope = port.getEnclosingScope();
            if (!(scope instanceof RfInstanceHolder)) {
                return false;
            }
            RfInstanceHolder instanceHolder = (RfInstanceHolder)scope;
            List<IRfPortElement> ports = instanceHolder.getLocalPorts();
            if (ports != null && ports.size() >= 2) {
                return true;
            }
        } else if (defElement instanceof RfFieldDef) {
            RfFieldDef fieldDef = (RfFieldDef)defElement;
            RfNamedElement element = fieldDef.getNamedElement();
            if (!(element instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)element;
            RfNamedElement scope = field.getEnclosingScope();
            if (scope instanceof RfFunction) {
                RfFunction function = (RfFunction)scope;
                if (field.isArgument()) {
                    List<IRfFieldElement> functionArguments = function.getArguments();
                    if (functionArguments != null && functionArguments.size() >= 2) {
                        return true;
                    }
                } else {
                    List<RfField> functionFields = function.getFields();
                    if (functionFields == null) {
                        return false;
                    }
                    int size = functionFields.size();
                    for (RfField functionField : functionFields) {
                        if (!(functionField instanceof RfResultImplicitVariable)) continue;
                        --size;
                        break;
                    }
                    if (size >= 2) {
                        return true;
                    }
                }
                return false;
            }
            List<RfField> members = scope.getLocalMembers(RfField.class);
            if (members == null) {
                return false;
            }
            int size = members.size();
            for (RfField member : members) {
                if (!(member instanceof RfPort)) continue;
                --size;
            }
            if (size >= 2) {
                return true;
            }
        }
        return false;
    }

    private int getPrevNonWhitespaceOffset(int currentOffset, String fileContent, int minOffsetLimit) {
        char currentChar = fileContent.charAt(currentOffset);
        while (Character.isWhitespace(currentChar) && currentOffset > minOffsetLimit) {
            currentChar = fileContent.charAt(--currentOffset);
        }
        return currentOffset;
    }

    private int getNofDimensions(String unpackedDimension) {
        int nOfNestedParams = 0;
        int nOfDimensions = 0;
        int i = 0;
        while (i < unpackedDimension.length()) {
            char current = unpackedDimension.charAt(i);
            if (current == '[') {
                ++nOfNestedParams;
            } else if (current == ']' && --nOfNestedParams == 0) {
                ++nOfDimensions;
            }
            ++i;
        }
        return nOfDimensions;
    }

    private int goToFunctionNameOffset(int currentOffset, String fileContent, RfNamedElement functionNamedElement) {
        if (functionNamedElement == null || !(functionNamedElement.getEnclosingScope() instanceof RfClass)) {
            return -1;
        }
        RfNamedElement enclosingScope = functionNamedElement.getEnclosingScope();
        StringBuilder accessorName = new StringBuilder(enclosingScope.getName()).append("::");
        int accessorOffset = accessorName.length() - 1;
        int correctOffset = currentOffset;
        int i = currentOffset - 1;
        while (i >= 0) {
            char currentChar = fileContent.charAt(i);
            if (!Character.isWhitespace(currentChar)) {
                if (accessorOffset == -1) {
                    if (currentChar != ':') {
                        return correctOffset;
                    }
                    if (enclosingScope.getEnclosingScope() != null) {
                        if (!((enclosingScope = enclosingScope.getEnclosingScope()) instanceof RfClass) && !(enclosingScope instanceof RfPackage)) {
                            return -1;
                        }
                        accessorName.setLength(0);
                        accessorName = accessorName.append(enclosingScope.getName()).append("::");
                        accessorOffset = accessorName.length() - 1;
                    } else {
                        return -1;
                    }
                }
                if (accessorName.charAt(accessorOffset) != currentChar) {
                    return -1;
                }
                if (--accessorOffset == -1) {
                    correctOffset = i;
                }
            }
            --i;
        }
        return -1;
    }

    public static int goToInstanceNameOffset(int currentOffset, String fileContent, int instanceEndOffset) {
        if (instanceEndOffset < 0) {
            return currentOffset;
        }
        if ((currentOffset = Check_SVTB_1_1_12.skipFieldTypeName(currentOffset, fileContent, instanceEndOffset)) == -1) {
            return -1;
        }
        if ((currentOffset = Check_SVTB_1_1_12.skipWhiteSpaces(currentOffset, fileContent, instanceEndOffset)) == -1) {
            return -1;
        }
        char currentChar = fileContent.charAt(currentOffset);
        if (currentChar == '#') {
            ++currentOffset;
            if ((currentOffset = Check_SVTB_1_1_12.skipWhiteSpaces(currentOffset, fileContent, instanceEndOffset)) == -1) {
                return -1;
            }
            currentChar = fileContent.charAt(currentOffset);
            if (currentChar == '(') {
                int nOfNestedParans = 1;
                while (nOfNestedParans != 0 && currentOffset < instanceEndOffset) {
                    if ((currentChar = fileContent.charAt(++currentOffset)) == '(') {
                        ++nOfNestedParans;
                        continue;
                    }
                    if (currentChar != ')') continue;
                    --nOfNestedParans;
                }
                ++currentOffset;
                if ((currentOffset = Check_SVTB_1_1_12.skipWhiteSpaces(currentOffset, fileContent, instanceEndOffset)) == -1) {
                    return -1;
                }
            }
        }
        return currentOffset;
    }

    private static int skipWhiteSpaces(int currentOffset, String fileContent, int instanceEndOffset) {
        if (Check_SVTB_1_1_12.isEndOfFieldDefinition(currentOffset, fileContent, instanceEndOffset)) {
            return -1;
        }
        char currentChar = fileContent.charAt(currentOffset);
        while (Character.isWhitespace(currentChar)) {
            if (Check_SVTB_1_1_12.isEndOfFieldDefinition(++currentOffset, fileContent, instanceEndOffset)) {
                return -1;
            }
            currentChar = fileContent.charAt(currentOffset);
        }
        return currentOffset;
    }

    private static boolean isEndOfFieldDefinition(int currentOffset, String fileContent, int instanceEndOffset) {
        return currentOffset >= instanceEndOffset || currentOffset >= fileContent.length();
    }

    private static int skipFieldTypeName(int currentOffset, String fileContent, int instanceEndOffset) {
        if (Check_SVTB_1_1_12.isEndOfFieldDefinition(currentOffset, fileContent, instanceEndOffset)) {
            return -1;
        }
        char currentChar = fileContent.charAt(currentOffset);
        while (Character.isJavaIdentifierPart(currentChar)) {
            if (Check_SVTB_1_1_12.isEndOfFieldDefinition(++currentOffset, fileContent, instanceEndOffset)) {
                return -1;
            }
            currentChar = fileContent.charAt(currentOffset);
        }
        return currentOffset;
    }

    private int getMatchingRightBracketOffset(String text, int leftParanthesesOffset, int maxOffset) {
        int counter = 1;
        int currentOffset = 0;
        int length = maxOffset - leftParanthesesOffset - 1;
        String content = text.substring(leftParanthesesOffset + 1, Math.min(leftParanthesesOffset + length, text.length()));
        while (counter > 0 && currentOffset < content.length()) {
            char c;
            if ((c = content.charAt(currentOffset++)) == '[') {
                ++counter;
                continue;
            }
            if (c != ']') continue;
            --counter;
        }
        if (counter == 0) {
            return leftParanthesesOffset + currentOffset;
        }
        return -1;
    }

    public class LocalDefVisitor
    implements IRfDefElementVisitor {
        private Map<ParserPath, Map<RfDefElement, PackedUnpackedDimensionFieldInformation>> defTypeMap = new HashMap<ParserPath, Map<RfDefElement, PackedUnpackedDimensionFieldInformation>>();
        private OVMComplianceCheck check;

        public LocalDefVisitor(OVMComplianceCheck check) {
            this.check = check;
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            IRfNamedElement parameterType;
            RfFileDef file = defElement.getDefFile();
            if (file == null) {
                return;
            }
            if (Check_SVTB_1_1_12.this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this.check)) {
                return;
            }
            if (defElement instanceof RfFileDef) {
                return;
            }
            if (defElement instanceof RfFieldDef && ((RfFieldDef)defElement).isImplicit()) {
                return;
            }
            if (defElement.getReparseInfo() != null) {
                return;
            }
            if (defElement instanceof RfFunctionDef) {
                DataType typeInfo = ((RfFunctionDef)defElement).getTypeInfo(defElement.getNamedElement());
                if (typeInfo == null) {
                    return;
                }
                String packedDimension = typeInfo.getPackedDimensionString();
                if (packedDimension == null || packedDimension.isEmpty()) {
                    return;
                }
                Map<RfDefElement, PackedUnpackedDimensionFieldInformation> defTypePathMap = this.defTypeMap.get(defElement.getParserPath());
                if (defTypePathMap == null) {
                    defTypePathMap = new HashMap<RfDefElement, PackedUnpackedDimensionFieldInformation>();
                    this.defTypeMap.put(defElement.getParserPath(), defTypePathMap);
                }
                defTypePathMap.put(defElement, new PackedUnpackedDimensionFieldInformation(packedDimension, null));
                return;
            }
            RfNamedElement namedElement = defElement.getNamedElement();
            if (Check_SVTB_1_1_12.this.pCheckTypedefs && namedElement instanceof RfTypeAlias) {
                RfTypeAlias typedef = (RfTypeAlias)namedElement;
                IRfNamedElement typedefType = typedef.getAssociatedType();
                this.addDefTypeToMap(defElement, typedefType);
                return;
            }
            if (!(namedElement instanceof RfField)) {
                return;
            }
            RfField fieldElement = (RfField)namedElement;
            if (fieldElement.getEnclosingScope() instanceof RfStruct && ((RfStruct)fieldElement.getEnclosingScope()).isEnum()) {
                return;
            }
            if (fieldElement instanceof RfModportPort) {
                return;
            }
            if (fieldElement.getParameterKind() != null) {
                return;
            }
            if (fieldElement.getEnclosingScope() instanceof RfModule && defElement instanceof RfPortDef && ((RfModule)fieldElement.getEnclosingScope()).isNonAnsi() && ((RfPortDef)defElement).isInListOfPorts()) {
                return;
            }
            if (fieldElement.getDataType() != null && fieldElement.getDataType().getType() != null && (parameterType = fieldElement.getEnclosingScope().semanticGetMember(fieldElement.getDataType().getType(), null, null, fieldElement.getEnclosingScope(), null, true, true, false)) instanceof RfField && ((RfField)parameterType).getParameterKind() != null) {
                return;
            }
            IRfNamedElement elementType = fieldElement.getAssociatedTypeNoLastLevelParams();
            this.addDefTypeToMap(defElement, elementType);
        }

        private void addDefTypeToMap(RfDefElement defElement, IRfNamedElement elementType) {
            boolean hasUnpackedDimension;
            if (!(elementType instanceof RfListType)) {
                return;
            }
            RfListType listType = (RfListType)elementType;
            String packedDimension = listType.getPackedDimension();
            String unpackedDimension = listType.getUnpackedDimension();
            boolean hasPackedDimension = packedDimension != null && !packedDimension.isEmpty();
            boolean bl = hasUnpackedDimension = unpackedDimension != null && !unpackedDimension.isEmpty();
            if (!hasPackedDimension && !hasUnpackedDimension) {
                return;
            }
            ParserPath parserPath = defElement.getParserPath();
            Map<RfDefElement, PackedUnpackedDimensionFieldInformation> defTypePathMap = this.defTypeMap.get(parserPath);
            if (defTypePathMap == null) {
                defTypePathMap = new HashMap<RfDefElement, PackedUnpackedDimensionFieldInformation>();
                this.defTypeMap.put(defElement.getParserPath(), defTypePathMap);
            }
            defTypePathMap.put(defElement, new PackedUnpackedDimensionFieldInformation(packedDimension, unpackedDimension));
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }

        public Map<ParserPath, Map<RfDefElement, PackedUnpackedDimensionFieldInformation>> getListTypeMap() {
            return this.defTypeMap;
        }
    }

    public static class PackedUnpackedDimensionFieldInformation {
        private String packedDimension;
        private String unpackedDimension;

        public PackedUnpackedDimensionFieldInformation(String packedDimension, String unpackedDimension) {
            this.packedDimension = packedDimension;
            this.unpackedDimension = unpackedDimension;
        }

        public String getPackedDimension() {
            return this.packedDimension;
        }

        public String getUnpackedDimension() {
            return this.unpackedDimension;
        }
    }
}

