/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_13;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="18.1.25")
@CheckID(value="SVTB.1.1.13")
@CheckName(value="SVTB.1.1.13")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.PARENTHESIS})
@CheckTitle(value="Returned expression must be wrapped in parentheses.")
@CheckDescription(value="Returned expression must be wrapped in parentheses.\n\nExamples:\nreturn 0;   // NOT ALLOWED\nreturn (0);  // ALLOWED\n\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_13.class)
public class Check_SVTB_1_1_13
extends AbstractFormattingDisabledCheck {
    private static final String RETURN_STRING = "return";
    private static final char RIGHT_PAREN_CHAR = ')';
    private static final char LEFT_PAREN_CHAR = '(';
    private Map<ParserPath, Map<HidOperatorOccurrence, RfFunction>> returnStatementsMap = new HashMap<ParserPath, Map<HidOperatorOccurrence, RfFunction>>();
    Comparator<HidOperatorOccurrence> openBoundaryOffsetOccurrenceComparator = new Comparator<HidOperatorOccurrence>(){

        @Override
        public int compare(HidOperatorOccurrence occurrence1, HidOperatorOccurrence occurrence2) {
            return Integer.compare(occurrence1.getOpenBoundary(), occurrence2.getOpenBoundary());
        }
    };

    public Check_SVTB_1_1_13(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performCheckImpl() {
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllFunctions()) {
            List<RfActionBlock> functionActionBlocks;
            RfFunction function;
            if (!(rfNamedElement instanceof RfFunction) || (function = (RfFunction)rfNamedElement).isConstructor() || function.isVoid() || function.isPure()) continue;
            this.notifyCheckAlive();
            RfHidHolder hidHolder = rfNamedElement.getHidHolder();
            if (hidHolder != null) {
                this.visitHolder(hidHolder, function);
            }
            if ((functionActionBlocks = function.getLocalMembers(RfActionBlock.class)) == null || functionActionBlocks.isEmpty()) continue;
            for (RfActionBlock rfActionBlock : functionActionBlocks) {
                this.checkActionBlock(rfActionBlock, function);
            }
        }
        if (this.returnStatementsMap == null || this.returnStatementsMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.returnStatementsMap.entrySet()) {
            ParserPath parserPath = (ParserPath)entry.getKey();
            Map returnOccurrencesMap = (Map)entry.getValue();
            if (returnOccurrencesMap == null || returnOccurrencesMap.isEmpty()) continue;
            this.notifyCheckAlive();
            TreeMap sortedReturnOccurrencesMap = new TreeMap(this.openBoundaryOffsetOccurrenceComparator);
            sortedReturnOccurrencesMap.putAll(returnOccurrencesMap);
            try {
                Throwable throwable = null;
                Iterator<RfActionBlock> iterator = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(parserPath.path));){
                    int currentOffset = 0;
                    for (Map.Entry returnOccurrencesEntry : sortedReturnOccurrencesMap.entrySet()) {
                        char currentChar;
                        RfFunction function = (RfFunction)returnOccurrencesEntry.getValue();
                        HidOperatorOccurrence occurrence = (HidOperatorOccurrence)returnOccurrencesEntry.getKey();
                        while (currentOffset < occurrence.getOpenBoundary() + RETURN_STRING.length()) {
                            currentChar = (char)reader.read();
                            ++currentOffset;
                        }
                        currentChar = (char)reader.read();
                        ++currentOffset;
                        while (Character.isWhitespace(currentChar)) {
                            currentChar = (char)reader.read();
                            ++currentOffset;
                        }
                        StringBuilder returnExpressionBuilder = new StringBuilder();
                        returnExpressionBuilder.append(currentChar);
                        int startOffset = currentOffset - 1;
                        while (currentOffset < occurrence.getCloseBoundary() - 1) {
                            currentChar = (char)reader.read();
                            ++currentOffset;
                            returnExpressionBuilder.append(currentChar);
                        }
                        String returnExpression = returnExpressionBuilder.toString().trim();
                        if (this.isWrappedInParentheses(returnExpression)) continue;
                        this.addHit(parserPath, occurrence.getLine(), "Expression returned in function '" + LintUtils.getNamedElementFullName(function) + "' is not wrapped in parantheses!", null, new VerissimoAutofixAdditionalInfo(startOffset, currentOffset));
                    }
                }
                catch (Throwable throwable2) {
                    void var6_13;
                    if (throwable == null) {
                        Throwable throwable3 = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw var6_13;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.fOVMProject.notifyCheckException(this, fileNotFoundException);
                DVTLogger.INSTANCE.logError((Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                this.fOVMProject.notifyCheckException(this, iOException);
                DVTLogger.INSTANCE.logError((Throwable)iOException);
            }
        }
        this.returnStatementsMap.clear();
    }

    private boolean isWrappedInParentheses(String returnExpression) {
        if (returnExpression.length() == 1) {
            return false;
        }
        int openClosedParens = 0;
        int index = 0;
        while (index < returnExpression.length()) {
            char ch = returnExpression.charAt(index);
            if (ch == '(') {
                ++openClosedParens;
            } else if (ch == ')') {
                --openClosedParens;
            }
            if (openClosedParens == 0 && index != returnExpression.length() - 1) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private void checkActionBlock(RfActionBlock actionBlock, RfFunction function) {
        List<RfActionBlock> actionBlocks;
        RfHidHolder actionBlockHolder = actionBlock.getHidHolder();
        if (actionBlockHolder != null) {
            this.visitHolder(actionBlockHolder, function);
        }
        if ((actionBlocks = actionBlock.getLocalMembers(RfActionBlock.class)) == null || actionBlocks.isEmpty()) {
            return;
        }
        for (RfActionBlock block : actionBlocks) {
            this.checkActionBlock(block, function);
        }
    }

    private void visitHolder(RfHidHolder hidHolder, final RfFunction function) {
        hidHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<RfHidOperator>(){
            ParserPath parserPath;

            public boolean visit(RfHidOperator operator) {
                if (!operator.isReturnStatement()) {
                    return true;
                }
                HidOperatorOccurrence operatorOccurrence = operator.getOccurrence();
                ReparseInfo reparseInfo = (ReparseInfo)operatorOccurrence.getReparseInfo(ReparseInfo.class);
                if (reparseInfo != null) {
                    return true;
                }
                Map<HidOperatorOccurrence, RfFunction> returnOccurrencesMap = Check_SVTB_1_1_13.this.returnStatementsMap.get(this.parserPath);
                if (returnOccurrencesMap == null) {
                    returnOccurrencesMap = new HashMap<HidOperatorOccurrence, RfFunction>();
                    Check_SVTB_1_1_13.this.returnStatementsMap.put(this.parserPath, returnOccurrencesMap);
                }
                returnOccurrencesMap.put(operatorOccurrence, function);
                return true;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        });
    }
}

